/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport.rdhXfile;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.kapott.cryptalgs.RSAPrivateCrtKey2;
import org.kapott.hbci.datatypes.SyntaxCtr;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.rdhXfile.TLV;

public class HBCIAccount
extends TLV {
    private BankData bankdata;
    private List<UserKeys> userkeys;

    public HBCIAccount() {
        super(22091);
        this.bankdata = new BankData();
        this.userkeys = new ArrayList<UserKeys>();
    }

    public HBCIAccount(TLV tlv) {
        super(tlv);
        UserKeys userkey;
        this.bankdata = new BankData(new TLV(tlv.getData(), 0));
        this.userkeys = new ArrayList<UserKeys>();
        int size = this.getData().length;
        for (int posi = this.bankdata.getRawData().length; posi < size; posi += userkey.getRawData().length) {
            userkey = new UserKeys(new TLV(this.getData(), posi));
            this.userkeys.add(userkey);
        }
    }

    public String getCountry() {
        return this.bankdata.getCountry();
    }

    public void setCountry(String country) {
        this.bankdata.setCountry(country);
    }

    public String getBLZ() {
        return this.bankdata.getBLZ();
    }

    public void setBLZ(String blz) {
        this.bankdata.setBLZ(blz);
    }

    public String getUserId() {
        return this.bankdata.getUserId();
    }

    public void setUserId(String userid) {
        this.bankdata.setUserId(userid);
    }

    public String getCustomerId() {
        return this.bankdata.getCustomerId();
    }

    public void setCustomerId(String customerid) {
        this.bankdata.setCustomerId(customerid);
    }

    public String getHost() {
        return this.bankdata.getHost();
    }

    public void setHost(String host) {
        this.bankdata.setHost(host);
    }

    public String getSysId() {
        return this.bankdata.getSysId();
    }

    public void setSysId(String sysid) {
        this.bankdata.setSysId(sysid);
    }

    public long getSigId() {
        return this.bankdata.getSigId();
    }

    public void setSigId(long sigid) {
        this.bankdata.setSigId(sigid);
    }

    public byte getKeyStatus() {
        return this.bankdata.getKeyStatus();
    }

    public void setKeyStatus(byte keystatus) {
        this.bankdata.setKeyStatus(keystatus);
    }

    public List<UserKeys> getUserKeys() {
        return this.userkeys;
    }

    public HBCIKey[] getUserSigKeys() {
        return this.getUserKeys("S");
    }

    public void setUserSigKeys(HBCIKey[] keys) {
        this.setUserKeys("S", keys);
        if (keys == null || keys.length == 0 || keys[0] == null) {
            this.setKeyStatus((byte)((this.getKeyStatus() | 1) & 0xFF));
        } else {
            this.setKeyStatus((byte)(this.getKeyStatus() & 0xFE));
        }
    }

    public HBCIKey[] getUserEncKeys() {
        return this.getUserKeys("V");
    }

    public void setUserEncKeys(HBCIKey[] keys) {
        this.setUserKeys("V", keys);
    }

    private HBCIKey[] getUserKeys(String keytype) {
        HBCIKey[] ret = null;
        for (UserKeys key : this.userkeys) {
            if (!key.getKeyType().equals(keytype)) continue;
            ret = new HBCIKey[]{new HBCIKey(this.getCountry(), this.getBLZ(), this.getUserId(), Integer.toString(key.getKeyNum()), Integer.toString(key.getKeyVersion()), key.getPublicKey()), new HBCIKey(this.getCountry(), this.getBLZ(), this.getUserId(), Integer.toString(key.getKeyNum()), Integer.toString(key.getKeyVersion()), key.getPrivateKey())};
        }
        return ret;
    }

    private void setUserKeys(String keytype, HBCIKey[] keys) {
        if (keys != null && keys.length == 2 && keys[0] != null && keys[1] != null) {
            boolean found = false;
            for (UserKeys userkey : this.userkeys) {
                if (!userkey.getKeyType().equals(keytype)) continue;
                userkey.setKeyNum(Integer.parseInt(keys[0].num));
                userkey.setKeyVersion(Integer.parseInt(keys[0].version));
                userkey.setPublicKey(keys[0].key);
                userkey.setPrivateKey(keys[1].key);
                found = true;
            }
            if (!found) {
                UserKeys userkey = new UserKeys();
                this.userkeys.add(userkey);
                userkey.setKeyType(keytype);
                userkey.setKeyNum(Integer.parseInt(keys[0].num));
                userkey.setKeyVersion(Integer.parseInt(keys[0].version));
                userkey.setPublicKey(keys[0].key);
                userkey.setPrivateKey(keys[1].key);
            }
        }
    }

    @Override
    public void updateData() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.bankdata.updateData();
            os.write(this.bankdata.getRawData());
            for (UserKeys userkeys : this.userkeys) {
                userkeys.updateData();
                os.write(userkeys.getRawData());
            }
            this.setData(os.toByteArray());
        }
        catch (Exception e) {
            throw new HBCI_Exception(e);
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("hbciaccount: " + this.bankdata);
        Iterator<UserKeys> i = this.userkeys.iterator();
        while (i.hasNext()) {
            ret.append("; " + i.next());
        }
        return ret.toString();
    }

    public static class UserKeys
    extends TLV {
        private int keytype;
        private int keynum;
        private int keyversion;
        private byte[] exponent;
        private byte[] modulus;
        private byte[] encPrivateKey;
        private byte[] p;
        private byte[] q;
        private byte[] dP;
        private byte[] dQ;
        private byte[] Ap;
        private byte[] Aq;

        public UserKeys() {
            super(17747);
        }

        public UserKeys(TLV tlv) {
            super(tlv);
            int i;
            byte[] data = this.getData();
            this.keytype = data[1];
            this.keynum = (data[3] & 0xFF) << 8 | data[2] & 0xFF;
            this.keyversion = (data[5] & 0xFF) << 8 | data[4] & 0xFF;
            int len = (data[7] & 0xFF) << 8 | data[6] & 0xFF;
            this.exponent = new byte[len];
            for (int i2 = 0; i2 < len; ++i2) {
                this.exponent[len - i2 - 1] = data[8 + i2];
            }
            int offset = 8 + len;
            len = (data[offset + 1] & 0xFF) << 8 | data[offset] & 0xFF;
            offset += 2;
            this.modulus = new byte[len];
            for (i = 0; i < len; ++i) {
                this.modulus[len - i - 1] = data[offset + i];
            }
            offset += len;
            len = (data[offset + 1] & 0xFF) << 8 | data[offset] & 0xFF;
            offset += 2;
            this.encPrivateKey = new byte[len];
            for (i = 0; i < len; ++i) {
                this.encPrivateKey[len - i - 1] = data[offset + i];
            }
            offset += len;
            HBCIUtils.log("found userkey with keynum=" + this.keynum, 4);
        }

        public void decrypt(SecretKey key) throws Exception {
            int i;
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            cipher.init(2, (Key)key, new IvParameterSpec(new byte[8]));
            byte[] plaindata = cipher.doFinal(this.encPrivateKey);
            int offset = 0;
            int len = (plaindata[offset + 1] & 0xFF) << 8 | plaindata[offset] & 0xFF;
            offset += 2;
            byte[] modulus2 = new byte[len];
            for (i = 0; i < len; ++i) {
                modulus2[len - i - 1] = plaindata[offset + i];
            }
            offset += len;
            len = (plaindata[offset + 1] & 0xFF) << 8 | plaindata[offset] & 0xFF;
            offset += 2;
            this.p = new byte[len];
            for (i = 0; i < len; ++i) {
                this.p[len - i - 1] = plaindata[offset + i];
            }
            offset += len;
            len = (plaindata[offset + 1] & 0xFF) << 8 | plaindata[offset] & 0xFF;
            offset += 2;
            this.q = new byte[len];
            for (i = 0; i < len; ++i) {
                this.q[len - i - 1] = plaindata[offset + i];
            }
            offset += len;
            len = (plaindata[offset + 1] & 0xFF) << 8 | plaindata[offset] & 0xFF;
            offset += 2;
            this.dP = new byte[len];
            for (i = 0; i < len; ++i) {
                this.dP[len - i - 1] = plaindata[offset + i];
            }
            offset += len;
            len = (plaindata[offset + 1] & 0xFF) << 8 | plaindata[offset] & 0xFF;
            offset += 2;
            this.dQ = new byte[len];
            for (i = 0; i < len; ++i) {
                this.dQ[len - i - 1] = plaindata[offset + i];
            }
            offset += len;
            len = (plaindata[offset + 1] & 0xFF) << 8 | plaindata[offset] & 0xFF;
            offset += 2;
            this.Ap = new byte[len];
            for (i = 0; i < len; ++i) {
                this.Ap[len - i - 1] = plaindata[offset + i];
            }
            offset += len;
            len = (plaindata[offset + 1] & 0xFF) << 8 | plaindata[offset] & 0xFF;
            offset += 2;
            this.Aq = new byte[len];
            for (i = 0; i < len; ++i) {
                this.Aq[len - i - 1] = plaindata[offset + i];
            }
            offset += len;
        }

        public String getKeyType() {
            return this.keytype == 0 ? "S" : "V";
        }

        public void setKeyType(String t) {
            this.keytype = t.equals("S") ? 0 : 1;
        }

        public int getKeyNum() {
            return this.keynum;
        }

        public void setKeyNum(int num) {
            this.keynum = num;
        }

        public int getKeyVersion() {
            return this.keyversion;
        }

        public void setKeyVersion(int version) {
            this.keyversion = version;
        }

        public Key getPublicKey() {
            try {
                RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(1, this.modulus), new BigInteger(1, this.exponent));
                KeyFactory fac = KeyFactory.getInstance("RSA");
                return fac.generatePublic(spec);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void setPublicKey(Key key) {
            RSAPublicKey pubkey = (RSAPublicKey)key;
            this.exponent = this.trimba(pubkey.getPublicExponent().toByteArray());
            this.modulus = this.trimba(pubkey.getModulus().toByteArray());
        }

        public Key getPrivateKey() {
            try {
                RSAPrivateCrtKey2 k = new RSAPrivateCrtKey2(new BigInteger(1, this.p), new BigInteger(1, this.q), new BigInteger(1, this.dP), new BigInteger(1, this.dQ), new BigInteger(1, this.q).modInverse(new BigInteger(1, this.p)));
                k.setAp(new BigInteger(1, this.Ap));
                k.setAq(new BigInteger(1, this.Aq));
                return k;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void setPrivateKey(Key key) {
            if (key instanceof RSAPrivateCrtKey2) {
                RSAPrivateCrtKey2 privkey = (RSAPrivateCrtKey2)key;
                this.p = this.trimba(privkey.getP().toByteArray());
                this.q = this.trimba(privkey.getQ().toByteArray());
                this.dP = this.trimba(privkey.getdP().toByteArray());
                this.dQ = this.trimba(privkey.getdQ().toByteArray());
                this.Ap = this.trimba(privkey.getAp().toByteArray());
                this.Aq = this.trimba(privkey.getAq().toByteArray());
            } else {
                RSAPrivateCrtKey privkey = (RSAPrivateCrtKey)key;
                this.p = this.trimba(privkey.getPrimeP().toByteArray());
                this.q = this.trimba(privkey.getPrimeQ().toByteArray());
                this.dP = this.trimba(privkey.getPrimeExponentP().toByteArray());
                this.dQ = this.trimba(privkey.getPrimeExponentQ().toByteArray());
                BigInteger one = new BigInteger("1");
                BigInteger modulus = new BigInteger(1, this.p).multiply(new BigInteger(1, this.q));
                this.Ap = this.trimba(new BigInteger(1, this.q).modPow(new BigInteger(1, this.p).subtract(one), modulus).toByteArray());
                this.Aq = this.trimba(modulus.add(one).subtract(new BigInteger(1, this.Ap)).toByteArray());
            }
        }

        public void encrypt(SecretKey key) throws Exception {
            ByteArrayOutputStream plaindata = new ByteArrayOutputStream();
            plaindata.write(this.int2ba(this.modulus.length));
            plaindata.write(this.reverseba(this.modulus));
            plaindata.write(this.int2ba(this.p.length));
            plaindata.write(this.reverseba(this.p));
            plaindata.write(this.int2ba(this.q.length));
            plaindata.write(this.reverseba(this.q));
            plaindata.write(this.int2ba(this.dP.length));
            plaindata.write(this.reverseba(this.dP));
            plaindata.write(this.int2ba(this.dQ.length));
            plaindata.write(this.reverseba(this.dQ));
            plaindata.write(this.int2ba(this.Ap.length));
            plaindata.write(this.reverseba(this.Ap));
            plaindata.write(this.int2ba(this.Aq.length));
            plaindata.write(this.reverseba(this.Aq));
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            cipher.init(1, (Key)key, new IvParameterSpec(new byte[8]));
            this.encPrivateKey = cipher.doFinal(plaindata.toByteArray());
        }

        @Override
        public void updateData() {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                os.write(new byte[]{2});
                os.write(new byte[]{(byte)this.keytype});
                os.write(this.int2ba(this.keynum));
                os.write(this.int2ba(this.keyversion));
                os.write(this.int2ba(this.exponent.length));
                os.write(this.reverseba(this.exponent));
                os.write(this.int2ba(this.modulus.length));
                os.write(this.reverseba(this.modulus));
                os.write(this.int2ba(this.encPrivateKey.length));
                os.write(this.reverseba(this.encPrivateKey));
                this.setData(os.toByteArray());
            }
            catch (Exception e) {
                throw new HBCI_Exception(e);
            }
        }

        public String toString() {
            int x;
            int i;
            StringBuffer ret = new StringBuffer();
            ret.append("userkeys: keytype=" + this.keytype);
            ret.append("; keynum=" + this.keynum);
            ret.append("; keyversion=" + this.keyversion);
            ret.append("; exponent=");
            for (i = 0; i < this.exponent.length; ++i) {
                x = this.exponent[i] & 0xFF;
                ret.append(Integer.toString(x, 16) + " ");
            }
            ret.append("; modulus=");
            for (i = 0; i < this.modulus.length; ++i) {
                x = this.modulus[i] & 0xFF;
                ret.append(Integer.toString(x, 16) + " ");
            }
            if (this.p != null) {
                ret.append("; p=");
                for (i = 0; i < this.p.length; ++i) {
                    x = this.p[i] & 0xFF;
                    ret.append(Integer.toString(x, 16) + " ");
                }
            }
            if (this.q != null) {
                ret.append("; q=");
                for (i = 0; i < this.q.length; ++i) {
                    x = this.q[i] & 0xFF;
                    ret.append(Integer.toString(x, 16) + " ");
                }
            }
            if (this.dP != null) {
                ret.append("; dP=");
                for (i = 0; i < this.dP.length; ++i) {
                    x = this.dP[i] & 0xFF;
                    ret.append(Integer.toString(x, 16) + " ");
                }
            }
            if (this.dQ != null) {
                ret.append("; dQ=");
                for (i = 0; i < this.dQ.length; ++i) {
                    x = this.dQ[i] & 0xFF;
                    ret.append(Integer.toString(x, 16) + " ");
                }
            }
            if (this.Ap != null) {
                ret.append("; Ap=");
                for (i = 0; i < this.Ap.length; ++i) {
                    x = this.Ap[i] & 0xFF;
                    ret.append(Integer.toString(x, 16) + " ");
                }
            }
            if (this.Aq != null) {
                ret.append("; Aq=");
                for (i = 0; i < this.Aq.length; ++i) {
                    x = this.Aq[i] & 0xFF;
                    ret.append(Integer.toString(x, 16) + " ");
                }
            }
            return ret.toString();
        }
    }

    public static class BankData
    extends TLV {
        private String countrycode;
        private String blz;
        private String name;
        private String userid;
        private String customerid;
        private String sysid;
        private int commtype;
        private String commaddr;
        private long sigid;
        private byte keystatus;

        public BankData() {
            super(17483);
        }

        public BankData(TLV tlv) {
            super(tlv);
            byte[] data = this.getData();
            this.countrycode = new String(data, 0, 3).trim();
            this.blz = new String(data, 3, 30).trim();
            this.name = new String(data, 33, 60).trim();
            this.userid = new String(data, 93, 30).trim();
            this.customerid = new String(data, 123, 30).trim();
            this.sysid = new String(data, 153, 30).trim();
            this.commtype = data[183];
            this.commaddr = new String(data, 184, 50).trim();
            this.sigid = ((long)data[235] & 0xFFL) << 8 | (long)data[234] & 0xFFL;
            this.keystatus = data[236];
        }

        public String getCountry() {
            return new SyntaxCtr(new StringBuffer(this.countrycode), 1, 0).toString();
        }

        public void setCountry(String country) {
            this.countrycode = new SyntaxCtr(country, 1, 0).toString(0);
        }

        public String getBLZ() {
            return this.blz;
        }

        public void setBLZ(String blz) {
            this.blz = blz;
        }

        public String getUserId() {
            return this.userid;
        }

        public void setUserId(String userid) {
            this.userid = userid;
        }

        public String getCustomerId() {
            return this.customerid;
        }

        public void setCustomerId(String customerid) {
            this.customerid = customerid;
        }

        public String getHost() {
            return this.commaddr;
        }

        public void setHost(String host) {
            this.commaddr = host;
        }

        public String getSysId() {
            return this.sysid;
        }

        public void setSysId(String sysid) {
            this.sysid = sysid;
        }

        public long getSigId() {
            return this.sigid;
        }

        public void setSigId(long sigid) {
            this.sigid = sigid;
        }

        public byte getKeyStatus() {
            return this.keystatus;
        }

        public void setKeyStatus(byte keystatus) {
            this.keystatus = keystatus;
        }

        @Override
        public void updateData() {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                os.write(this.expand(this.countrycode, 3).getBytes());
                os.write(this.expand(this.getBLZ(), 30).getBytes());
                os.write(this.expand(this.name, 60).getBytes("ISO-8859-1"));
                os.write(this.expand(this.getUserId(), 30).getBytes("ISO-8859-1"));
                os.write(this.expand(this.getCustomerId(), 30).getBytes("ISO-8859-1"));
                os.write(this.expand(this.getSysId(), 30).getBytes());
                os.write(new byte[]{2});
                os.write(this.expand(this.getHost(), 50).getBytes());
                os.write(this.int2ba((int)this.getSigId()));
                os.write(new byte[]{(byte)(this.keystatus & 0xFF)});
                this.setData(os.toByteArray());
            }
            catch (Exception e) {
                throw new HBCI_Exception(e);
            }
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append("bankdata: country=" + this.countrycode);
            ret.append("; blz=" + this.blz);
            ret.append("; name=" + this.name);
            ret.append("; userid=" + this.userid);
            ret.append("; customerid=" + this.customerid);
            ret.append("; sysid=" + this.sysid);
            ret.append("; commtype=" + this.commtype);
            ret.append("; commaddr=" + this.commaddr);
            ret.append("; sigid=" + this.sigid);
            ret.append("; keystatus=0x" + Integer.toString(this.keystatus, 16));
            return ret.toString();
        }
    }
}

