/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.util.Properties;
import org.kapott.hbci.manager.HBCIUtils;

public enum HHDVersion {
    HHD_1_4(Type.CHIPTAN, "HHD1.4", "1.4", 5, "hhd14"),
    HHD_1_3(Type.CHIPTAN, "HHD1.3", "1.3", 4, "hhd13"),
    MS_1(Type.PHOTOTAN, "MS1", null, -1, "hhd14"),
    HHD_1_2(Type.CHIPTAN, null, null, -1, "hhd12");

    private Type type = null;
    private String idStart = null;
    private String versionStart = null;
    private int segVersion = 0;
    private String challengeVersion = null;

    private HHDVersion(Type type, String idStart, String versionStart, int segVersion, String challengeVersion) {
        this.type = type;
        this.idStart = idStart;
        this.versionStart = versionStart;
        this.segVersion = segVersion;
        this.challengeVersion = challengeVersion;
    }

    public String getChallengeVersion() {
        return this.challengeVersion;
    }

    public Type getType() {
        return this.type;
    }

    public static HHDVersion find(Properties secmech) {
        HBCIUtils.log("trying to determine HHD version for secmech: " + secmech, 4);
        String id = secmech.getProperty("id", "");
        HBCIUtils.log("  technical HHD id: " + id, 4);
        for (HHDVersion v : HHDVersion.values()) {
            String s = v.idStart;
            if (s == null || !id.startsWith(s)) continue;
            return v;
        }
        String version = secmech.getProperty("zkamethod_version");
        HBCIUtils.log("  ZKA version: " + version, 4);
        if (version != null && version.length() > 0) {
            for (HHDVersion v : HHDVersion.values()) {
                String s = v.versionStart;
                if (s == null || !version.startsWith(s)) continue;
                return v;
            }
        }
        String segversion = secmech.getProperty("segversion");
        HBCIUtils.log("  segment version: " + segversion, 4);
        if (segversion != null && segversion.length() > 0) {
            int i = Integer.parseInt(segversion);
            for (HHDVersion v : HHDVersion.values()) {
                int i2 = v.segVersion;
                if (i2 <= 0 || i != i2) continue;
                return v;
            }
        }
        return HHD_1_2;
    }

    public static enum Type {
        CHIPTAN,
        PHOTOTAN;

    }
}

