/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIInstitute;
import org.kapott.hbci.manager.HBCIKernelImpl;
import org.kapott.hbci.manager.HBCIUser;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.HBCIPassportList;
import org.kapott.hbci.status.HBCIDialogStatus;
import org.kapott.hbci.status.HBCIInstMessage;
import org.kapott.hbci.status.HBCIMsgStatus;

public final class HBCIDialog {
    private String dialogid;
    private long msgnum;
    private List<List<HBCIJobImpl>> msgs;
    private Properties listOfGVs;
    private HBCIPassportInternal passport;
    private HBCIKernelImpl kernel;

    public HBCIDialog(HBCIPassportInternal passport, HBCIKernelImpl kernel) {
        HBCIUtils.log("creating new dialog", 4);
        this.kernel = kernel;
        this.passport = passport;
        this.msgs = new ArrayList<List<HBCIJobImpl>>();
        this.msgs.add(new ArrayList());
        this.listOfGVs = new Properties();
    }

    private HBCIMsgStatus doDialogInit() {
        HBCIMsgStatus ret = new HBCIMsgStatus();
        try {
            HBCIUtils.log("checking whether passport is supported (but ignoring result)", 4);
            boolean s = this.passport.isSupported();
            HBCIUtils.log("passport supported: " + s, 4);
            HBCIUtils.log(HBCIUtils.getLocMsg("STATUS_DIALOG_INIT"), 4);
            this.passport.getCallback().status((HBCIPassport)this.passport, 17, null);
            String country = this.passport.getCountry();
            String blz = this.passport.getBLZ();
            boolean restarted = false;
            while (true) {
                this.kernel.rawNewMsg("DialogInit");
                this.kernel.rawSet("Idn.KIK.blz", blz);
                this.kernel.rawSet("Idn.KIK.country", country);
                this.kernel.rawSet("Idn.customerid", this.passport.getCustomerId());
                this.kernel.rawSet("Idn.sysid", this.passport.getSysId());
                String sysstatus = this.passport.getSysStatus();
                this.kernel.rawSet("Idn.sysStatus", sysstatus);
                if (this.passport.needInstKeys()) {
                    this.kernel.rawSet("KeyReq.SecProfile.method", this.passport.getProfileMethod());
                    this.kernel.rawSet("KeyReq.SecProfile.version", this.passport.getProfileVersion());
                    this.kernel.rawSet("KeyReq.KeyName.keytype", "V");
                    this.kernel.rawSet("KeyReq.KeyName.KIK.country", country);
                    this.kernel.rawSet("KeyReq.KeyName.KIK.blz", blz);
                    this.kernel.rawSet("KeyReq.KeyName.userid", this.passport.getInstEncKeyName());
                    this.kernel.rawSet("KeyReq.KeyName.keynum", this.passport.getInstEncKeyNum());
                    this.kernel.rawSet("KeyReq.KeyName.keyversion", this.passport.getInstEncKeyVersion());
                    if (this.passport.hasInstSigKey()) {
                        this.kernel.rawSet("KeyReq_2.SecProfile.method", this.passport.getProfileMethod());
                        this.kernel.rawSet("KeyReq_2.SecProfile.version", this.passport.getProfileVersion());
                        this.kernel.rawSet("KeyReq_2.KeyName.keytype", "S");
                        this.kernel.rawSet("KeyReq_2.KeyName.KIK.country", country);
                        this.kernel.rawSet("KeyReq_2.KeyName.KIK.blz", blz);
                        this.kernel.rawSet("KeyReq_2.KeyName.userid", this.passport.getInstSigKeyName());
                        this.kernel.rawSet("KeyReq_2.KeyName.keynum", this.passport.getInstSigKeyNum());
                        this.kernel.rawSet("KeyReq_2.KeyName.keyversion", this.passport.getInstSigKeyVersion());
                    }
                }
                this.kernel.rawSet("ProcPrep.BPD", this.passport.getBPDVersion());
                this.kernel.rawSet("ProcPrep.UPD", this.passport.getUPDVersion());
                this.kernel.rawSet("ProcPrep.lang", this.passport.getDefaultLang());
                this.kernel.rawSet("ProcPrep.prodName", HBCIUtils.getParam("client.product.name", "HBCI4Java"));
                this.kernel.rawSet("ProcPrep.prodVersion", HBCIUtils.getParam("client.product.version", "2.5"));
                ret = this.kernel.rawDoIt(true, true, true, true);
                boolean need_restart = this.passport.postInitResponseHook(ret);
                if (!need_restart) break;
                HBCIUtils.log("for some reason we have to restart this dialog", 3);
                if (restarted) {
                    HBCIUtils.log("this dialog already has been restarted once - to avoid endless loops we stop here", 2);
                    throw new HBCI_Exception("*** restart loop - aborting");
                }
                restarted = true;
            }
            Properties result = ret.getData();
            if (ret.isOK()) {
                HBCIInstitute inst = new HBCIInstitute(this.kernel, this.passport, false);
                inst.updateBPD(result);
                inst.extractKeys(result);
                HBCIUser user = new HBCIUser(this.kernel, this.passport, false);
                user.updateUPD(result);
                this.passport.saveChanges();
                this.msgnum = 2L;
                this.dialogid = result.getProperty("MsgHead.dialogid");
                HBCIUtils.log("dialog-id set to " + this.dialogid, 4);
                HBCIInstMessage msg = null;
                int i = 0;
                while (true) {
                    try {
                        String header = HBCIUtils.withCounter("KIMsg", i);
                        msg = new HBCIInstMessage(result, header);
                    }
                    catch (Exception e) {
                        break;
                    }
                    this.passport.getCallback().callback(this.passport, 14, msg.toString(), 0, new StringBuffer());
                    ++i;
                }
            }
            this.passport.getCallback().status((HBCIPassport)this.passport, 18, new Object[]{ret, this.dialogid});
        }
        catch (Exception e) {
            ret.addException(e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HBCIMsgStatus[] doJobs() {
        HBCIUtils.log(HBCIUtils.getLocMsg("LOG_PROCESSING_JOBS"), 3);
        ArrayList<HBCIMsgStatus> msgstatus_a = new ArrayList<HBCIMsgStatus>();
        HBCIPassportList msgPassports = new HBCIPassportList();
        int nof_messages = this.msgs.size();
        int j = 0;
        while (true) {
            if (j >= nof_messages) {
                HBCIMsgStatus[] ret = new HBCIMsgStatus[]{};
                if (msgstatus_a.size() == 0) return ret;
                return msgstatus_a.toArray(ret);
            }
            List<HBCIJobImpl> tasks = this.msgs.get(j);
            int loop = 0;
            HBCIMsgStatus msgstatus = new HBCIMsgStatus();
            while (true) {
                boolean addMsgStatus = true;
                try {
                    HBCIUtils.log("generating custom msg #" + (j + 1) + " (loop " + (loop + 1) + ")", 4);
                    int taskNum = 0;
                    msgPassports.clear();
                    this.kernel.rawNewMsg("CustomMsg");
                    for (HBCIJobImpl task : tasks) {
                        if (!task.needsContinue(loop)) continue;
                        task.setContinueOffset(loop);
                        Properties p = task.getLowlevelParams();
                        String header = HBCIUtils.withCounter("GV", taskNum);
                        String taskName = task.getName();
                        HBCIUtils.log("adding task " + taskName, 4);
                        this.passport.getCallback().status((HBCIPassport)this.passport, 1, task);
                        task.setIdx(taskNum);
                        Enumeration<Object> e = p.keys();
                        while (e.hasMoreElements()) {
                            String key = (String)e.nextElement();
                            this.kernel.rawSet(header + "." + key, p.getProperty(key));
                        }
                        msgPassports.addAll(task.getSignaturePassports());
                        ++taskNum;
                    }
                    if (taskNum == 0) {
                        HBCIUtils.log("loop " + (loop + 1) + " aborted, because there are no more tasks to be executed", 4);
                        addMsgStatus = false;
                        break;
                    }
                    this.kernel.rawSet("MsgHead.dialogid", this.dialogid);
                    this.kernel.rawSet("MsgHead.msgnum", this.getMsgNumAsString());
                    this.kernel.rawSet("MsgTail.msgnum", this.getMsgNumAsString());
                    this.nextMsgNum();
                    msgstatus = this.kernel.rawDoIt(msgPassports, true, true, true, true);
                    Properties result = msgstatus.getData();
                    int offset = 0;
                    offset = 1;
                    while (true) {
                        String path;
                        if ((path = result.getProperty(Integer.toString(offset))) == null || path.startsWith("CustomMsg.GV")) {
                            if (path != null) break;
                            offset = 0;
                            break;
                        }
                        ++offset;
                    }
                    if (offset != 0) {
                        for (HBCIJobImpl task : tasks) {
                            if (!task.needsContinue(loop)) continue;
                            try {
                                task.fillJobResult(msgstatus, offset);
                                this.passport.getCallback().status((HBCIPassport)this.passport, 2, task);
                            }
                            catch (Exception e) {
                                msgstatus.addException(e);
                            }
                        }
                    }
                    if (msgstatus.hasExceptions()) {
                        HBCIUtils.log("aborting current loop because of errors", 1);
                        break;
                    }
                    ++loop;
                    continue;
                }
                catch (Exception e) {
                    msgstatus.addException(e);
                    continue;
                }
                finally {
                    if (!addMsgStatus) continue;
                    msgstatus_a.add(msgstatus);
                    continue;
                }
                break;
            }
            ++j;
        }
    }

    private HBCIMsgStatus doDialogEnd() {
        HBCIMsgStatus ret = new HBCIMsgStatus();
        try {
            HBCIUtils.log(HBCIUtils.getLocMsg("LOG_DIALOG_END"), 4);
            this.passport.getCallback().status((HBCIPassport)this.passport, 19, null);
            this.kernel.rawNewMsg("DialogEnd");
            this.kernel.rawSet("DialogEndS.dialogid", this.dialogid);
            this.kernel.rawSet("MsgHead.dialogid", this.dialogid);
            this.kernel.rawSet("MsgHead.msgnum", this.getMsgNumAsString());
            this.kernel.rawSet("MsgTail.msgnum", this.getMsgNumAsString());
            this.nextMsgNum();
            ret = this.kernel.rawDoIt(true, true, true, true);
            this.passport.getCallback().status((HBCIPassport)this.passport, 20, ret);
        }
        catch (Exception e) {
            ret.addException(e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HBCIDialogStatus doIt(boolean closeDialog) {
        try {
            HBCIUtils.log("executing dialog", 4);
            HBCIDialogStatus ret = new HBCIDialogStatus();
            this.passport.beforeCustomDialogHook(this);
            HBCIMsgStatus initStatus = null;
            if (this.dialogid == null) {
                initStatus = this.doDialogInit();
                ret.setInitStatus(initStatus);
            }
            this.passport.afterCustomDialogInitHook(this.getMessages());
            if (this.dialogid != null || initStatus.isOK()) {
                ret.setMsgStatus(this.doJobs());
                if (closeDialog) {
                    ret.setEndStatus(this.doDialogEnd());
                }
            }
            HBCIDialogStatus hBCIDialogStatus = ret;
            return hBCIDialogStatus;
        }
        finally {
            if (closeDialog) {
                this.reset();
            }
        }
    }

    private void reset() {
        try {
            this.dialogid = null;
            this.msgnum = 1L;
            this.msgs = new ArrayList<List<HBCIJobImpl>>();
            this.msgs.add(new ArrayList());
            this.listOfGVs.clear();
        }
        catch (Exception e) {
            HBCIUtils.log(e);
        }
    }

    public String getDialogID() {
        return this.dialogid;
    }

    public String getMsgNumAsString() {
        return Long.toString(this.msgnum);
    }

    public long getMsgnum() {
        return this.msgnum;
    }

    public void nextMsgNum() {
        ++this.msgnum;
    }

    public void setDialogid(String dialogid) {
        this.dialogid = dialogid;
    }

    public void setMsgnum(long msgnum) {
        this.msgnum = msgnum;
    }

    private int getTotalNumberOfGVSegsInCurrentMessage() {
        int total = 0;
        Enumeration<Object> e = this.listOfGVs.keys();
        while (e.hasMoreElements()) {
            String hbciCode = (String)e.nextElement();
            int counter = Integer.parseInt(this.listOfGVs.getProperty(hbciCode));
            total += counter;
        }
        HBCIUtils.log("there are currently " + total + " GV segs in this message", 4);
        return total;
    }

    public void addTask(HBCIJobImpl job) {
        try {
            HBCIUtils.log(HBCIUtils.getLocMsg("EXCMSG_ADDJOB", job.getName()), 3);
            job.verifyConstraints();
            String hbciCode = job.getHBCICode();
            int gva_counter = this.listOfGVs.size();
            String counter_st = this.listOfGVs.getProperty(hbciCode);
            int gv_counter = counter_st != null ? Integer.parseInt(counter_st) : 0;
            int total_counter = this.getTotalNumberOfGVSegsInCurrentMessage();
            ++gv_counter;
            ++total_counter;
            if (counter_st == null) {
                ++gva_counter;
            }
            int maxGVA = this.passport.getMaxGVperMsg();
            int maxGVSegJob = job.getMaxNumberPerMsg();
            int maxGVSegTotal = this.passport.getMaxGVSegsPerMsg();
            if (maxGVA > 0 && gva_counter > maxGVA || maxGVSegJob > 0 && gv_counter > maxGVSegJob || maxGVSegTotal > 0 && total_counter > maxGVSegTotal) {
                if (maxGVSegTotal > 0 && total_counter > maxGVSegTotal) {
                    HBCIUtils.log("have to generate new message because current type of passport only allows " + maxGVSegTotal + " GV segs per message", 4);
                } else {
                    HBCIUtils.log("have to generate new message because of BPD restrictions for number of tasks per message; adding job to this new message", 4);
                }
                this.newMsg();
                gv_counter = 1;
                total_counter = 1;
            }
            this.listOfGVs.setProperty(hbciCode, Integer.toString(gv_counter));
            this.msgs.get(this.msgs.size() - 1).add(job);
        }
        catch (Exception e) {
            String msg = HBCIUtils.getLocMsg("EXCMSG_CANTADDJOB", job.getName());
            if (!HBCIUtils.ignoreError(null, "client.errors.ignoreAddJobErrors", msg + ": " + HBCIUtils.exception2String(e))) {
                throw new HBCI_Exception(msg, e);
            }
            HBCIUtils.log("task " + job.getName() + " will not be executed in current dialog", 1);
        }
    }

    public List<HBCIJobImpl> getAllTasks() {
        ArrayList<HBCIJobImpl> tasks = new ArrayList<HBCIJobImpl>();
        Iterator<List<HBCIJobImpl>> i = this.msgs.iterator();
        while (i.hasNext()) {
            tasks.addAll(i.next());
        }
        return tasks;
    }

    public void newMsg() {
        HBCIUtils.log("starting new message", 4);
        this.msgs.add(new ArrayList());
        this.listOfGVs.clear();
    }

    public List<List<HBCIJobImpl>> getMessages() {
        return this.msgs;
    }

    public void setKernel(HBCIKernelImpl kernel) {
        this.kernel = kernel;
    }
}

