/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.datatypes;

import org.kapott.hbci.datatypes.SyntaxDE;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.manager.HBCIUtils;

public final class SyntaxDig
extends SyntaxDE {
    private static String buildString(String st, int destlen) {
        int i;
        StringBuffer ret = new StringBuffer(destlen);
        ret.append(st);
        int len = st.length();
        for (i = 0; i < len; ++i) {
            char c = st.charAt(i);
            if (c >= '0' && c <= '9') continue;
            throw new InvalidArgumentException(HBCIUtils.getLocMsg("EXC_DTDIG_ONLY_DIGS", st));
        }
        for (i = len; i < destlen; ++i) {
            ret.insert(0, '0');
        }
        return ret.toString();
    }

    public SyntaxDig(String st, int minsize, int maxsize) {
        super(SyntaxDig.buildString(st.trim(), minsize), minsize, maxsize);
    }

    @Override
    public void init(String st, int minsize, int maxsize) {
        super.init(SyntaxDig.buildString(st.trim(), minsize), minsize, maxsize);
    }

    private void initData(StringBuffer res, int minsize, int maxsize) {
        int startidx = SyntaxDig.skipPreDelim(res);
        int endidx = SyntaxDig.findNextDelim(res, startidx);
        String st = res.substring(startidx, endidx);
        int len = st.length();
        for (int i = 0; i < len; ++i) {
            char ch = st.charAt(i);
            if (ch <= '9' && ch >= '0') continue;
            throw new InvalidArgumentException(HBCIUtils.getLocMsg("EXC_DTDIG_ONLY_DIGS", st));
        }
        this.setContent(st, minsize, maxsize);
        res.delete(0, endidx);
    }

    public SyntaxDig(StringBuffer res, int minsize, int maxsize) {
        this.initData(res, minsize, maxsize);
    }

    @Override
    public void init(StringBuffer res, int minsize, int maxsize) {
        this.initData(res, minsize, maxsize);
    }
}

