/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.comm;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import org.kapott.hbci.comm.Comm;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.protocol.MSG;

public final class CommStandard
extends Comm {
    Socket s;
    OutputStream o;
    InputStream i;

    public CommStandard(HBCIPassportInternal parentPassport) {
        super(parentPassport);
        HBCIUtils.log("opening connection to " + parentPassport.getHost() + ":" + parentPassport.getPort().toString(), 4);
        try {
            String socksServer = HBCIUtils.getParam("comm.standard.socks.server");
            if (socksServer != null && socksServer.trim().length() != 0) {
                String[] ss = socksServer.split(":");
                String socksHost = ss[0].trim();
                String socksPort = ss[1].trim();
                HBCIUtils.log("using SOCKS server at " + socksHost + ":" + socksPort, 4);
                Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(socksHost, Integer.parseInt(socksPort)));
                this.s = new Socket(proxy);
            } else {
                this.s = new Socket();
            }
            int localPort = Integer.parseInt(HBCIUtils.getParam("client.connection.localPort", "0"));
            if (localPort != 0) {
                this.s.setReuseAddress(true);
                this.s.bind(new InetSocketAddress(localPort));
            }
            this.s.connect(new InetSocketAddress(parentPassport.getHost(), (int)parentPassport.getPort()));
            this.i = this.s.getInputStream();
            this.o = this.s.getOutputStream();
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_CONNERR"), e);
        }
    }

    @Override
    protected void ping(MSG msg) {
        try {
            byte[] b = this.getPassport().getCommFilter().encode(msg.toString(0));
            this.o.write(b);
            this.o.flush();
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_SENDERR"), ex);
        }
    }

    @Override
    protected StringBuffer pong(MsgGen gen) {
        byte[] b = new byte[1024];
        StringBuffer ret = new StringBuffer();
        boolean sizeknown = false;
        int msgsize = -1;
        HBCIUtils.log("waiting for response", 3);
        try {
            int num;
            StringBuffer res = new StringBuffer();
            while (!(sizeknown && msgsize <= 0 || (num = this.i.read(b)) == -1)) {
                HBCIUtils.log("received " + num + " bytes", 5);
                String st = new String(b, 0, num, "ISO-8859-1");
                ret.append(st);
                if (!sizeknown) {
                    res.setLength(0);
                    res.append(this.getPassport().getCommFilter().decode(ret.toString()));
                    msgsize = this.extractMessageSize(res);
                    if (msgsize != -1) {
                        HBCIUtils.log("found message size: " + msgsize, 4);
                        msgsize -= ret.length();
                        sizeknown = true;
                    }
                } else {
                    msgsize -= num;
                }
                HBCIUtils.log("we still need " + msgsize + " bytes", 5);
            }
            return new StringBuffer(this.getPassport().getCommFilter().decode(ret.toString()));
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_RECVERR"), ex);
        }
    }

    private int extractMessageSize(StringBuffer st) {
        int secondPlus;
        int firstPlus;
        int ret = -1;
        if (st != null && (firstPlus = st.indexOf("+")) != -1 && (secondPlus = st.indexOf("+", firstPlus + 1)) != -1) {
            ret = Integer.parseInt(st.substring(firstPlus + 1, secondPlus));
        }
        return ret;
    }

    @Override
    protected void closeConnection() {
        try {
            HBCIUtils.log("closing communication line", 4);
            this.s.close();
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_CLOSEERR"), ex);
        }
    }
}

