/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.comm;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.kapott.hbci.exceptions.CanNotParseMessageException;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.ParseErrorException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.IHandlerData;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.protocol.MSG;
import org.kapott.hbci.rewrite.Rewrite;

public abstract class Comm {
    public static final String ENCODING = "ISO-8859-1";
    private HBCIPassportInternal passport;

    protected abstract void ping(MSG var1);

    protected abstract StringBuffer pong(MsgGen var1);

    protected abstract void closeConnection();

    public Comm() {
    }

    protected Comm(HBCIPassportInternal passport) {
        this.passport = passport;
    }

    public MSG pingpong(Hashtable<String, Object> kernelData, String msgName, MSG msg) {
        IHandlerData handler = this.getPassport().getParentHandlerData();
        MsgGen gen = handler.getMsgGen();
        HBCIUtils.log("---------------- request ----------------", 4);
        msg.log(4);
        this.getPassport().getCallback().status((HBCIPassport)this.getPassport(), 24, null);
        this.getPassport().getCallback().status((HBCIPassport)this.getPassport(), 30, msg.toString(0));
        this.ping(msg);
        this.getPassport().getCallback().status((HBCIPassport)this.getPassport(), 27, null);
        String st = this.pong(gen).toString();
        this.getPassport().getCallback().status((HBCIPassport)this.getPassport(), 31, st);
        HBCIUtils.log("---------------- response ----------------", 4);
        String[] split = st.split("'");
        for (int i = 0; i < split.length; ++i) {
            HBCIUtils.log(split[i], 4);
        }
        MSG retmsg = null;
        try {
            String rewriters_st = this.getPassport().getProperties().getProperty("kernel.rewriter");
            ArrayList<Rewrite> al = new ArrayList<Rewrite>();
            StringTokenizer tok = new StringTokenizer(rewriters_st, ",");
            while (tok.hasMoreTokens()) {
                String rewriterName = tok.nextToken().trim();
                if (rewriterName.length() == 0) continue;
                Class<?> cl = this.getClass().getClassLoader().loadClass("org.kapott.hbci.rewrite.R" + rewriterName);
                Constructor<?> con = cl.getConstructor(null);
                Rewrite rewriter = (Rewrite)con.newInstance(null);
                rewriter.setKernelData(kernelData);
                al.add(rewriter);
            }
            Rewrite[] rewriters = al.toArray(new Rewrite[al.size()]);
            for (int i = 0; i < rewriters.length; ++i) {
                st = rewriters[i].incomingCrypted(st, gen);
            }
            this.getPassport().getCallback().status((HBCIPassport)this.getPassport(), 28, "CryptedRes");
            try {
                HBCIUtils.log("trying to parse message as crypted message", 4);
                retmsg = new MSG("CryptedRes", st, st.length(), gen, false, true);
            }
            catch (ParseErrorException e) {
                HBCIUtils.log("message seems not to be encrypted; tring to parse it as " + msgName + "Res message", 4);
                gen.set("_origSignedMsg", st);
                for (int i = 0; i < rewriters.length; ++i) {
                    st = rewriters[i].incomingClearText(st, gen);
                }
                this.getPassport().getCallback().status((HBCIPassport)this.getPassport(), 28, msgName + "Res");
                retmsg = new MSG(msgName + "Res", st, st.length(), gen, true, true);
            }
        }
        catch (Exception ex) {
            throw new CanNotParseMessageException(HBCIUtils.getLocMsg("EXCMSG_CANTPARSE"), st, ex);
        }
        return retmsg;
    }

    public static Comm getInstance(String name, HBCIPassportInternal passport) {
        try {
            Class<?> cl = Class.forName("org.kapott.hbci.comm.Comm" + name);
            Constructor<?> cons = cl.getConstructor(HBCIPassportInternal.class);
            return (Comm)cons.newInstance(passport);
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_CANTCREATECOMM", name), e);
        }
    }

    protected HBCIPassportInternal getPassport() {
        return this.passport;
    }

    public void close() {
        this.closeConnection();
        this.getPassport().getCallback().callback(this.getPassport(), 25, HBCIUtils.getLocMsg("CALLB_CLOSE_CONN"), 0, new StringBuffer());
    }
}

