/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV_Result;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class GVRAccInfo
extends HBCIJobResultImpl {
    private static final BigDecimal ONE_THOUSAND = new BigDecimal("1000.00");
    private List<AccInfo> entries = new ArrayList<AccInfo>();

    public void addEntry(AccInfo info) {
        this.entries.add(info);
    }

    public AccInfo[] getEntries() {
        return this.entries.toArray(new AccInfo[this.entries.size()]);
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        String linesep = System.getProperty("line.separator");
        int num = 0;
        Iterator<AccInfo> i = this.entries.iterator();
        while (i.hasNext()) {
            ret.append("Kontoinfo #").append(++num).append(linesep);
            ret.append(i.next().toString() + linesep);
        }
        return ret.toString().trim();
    }

    public static class AccInfo {
        public static final int DELIVER_TYPE_NONE = 0;
        public static final int DELIVER_TYPE_POST = 1;
        public static final int DELIVER_TYPE_KAD = 2;
        public static final int DELIVER_TYPE_OFFICE = 3;
        public static final int DELIVER_TYPE_EDV = 4;
        public static final int TURNUS_DAILY = 1;
        public static final int TURNUS_WEEKLY = 2;
        public static final int TURNUS_MONTHLY = 3;
        public static final int TURNUS_QUARTER = 4;
        public static final int TURNUS_HALF = 5;
        public static final int TURNUS_ANNUAL = 6;
        public Konto account;
        public int type;
        public Date created;
        public long sollzins;
        public long habenzins;
        public long ueberzins;
        public Value kredit;
        public Konto refAccount;
        public int versandart;
        public int turnus;
        public String comment;
        public Address address;

        public String toString() {
            StringBuffer ret = new StringBuffer();
            String linesep = System.getProperty("line.separator");
            ret.append("Konto ").append(this.account.toString());
            ret.append(" (art: ").append(this.type).append(")").append(linesep);
            if (this.created != null) {
                ret.append("Er\u00c3\u00b6ffnungsdatum: ").append(HBCIUtils.date2StringLocal(this.created)).append(linesep);
            }
            ret.append("Sollzins:").append(HBCIUtils.bigDecimal2String(new BigDecimal(this.sollzins).divide(ONE_THOUSAND)));
            ret.append(" Habenzins:").append(HBCIUtils.bigDecimal2String(new BigDecimal(this.habenzins).divide(ONE_THOUSAND)));
            ret.append(" \u00c3\u009cberziehungszins:").append(HBCIUtils.bigDecimal2String(new BigDecimal(this.ueberzins).divide(ONE_THOUSAND)));
            ret.append(" Kredit: ").append(this.kredit).append(linesep);
            if (this.refAccount != null) {
                ret.append("Referenzkonto: ").append(this.refAccount.toString()).append(linesep);
            }
            ret.append("Kontoauszug Versandart:").append(this.versandart);
            ret.append(" Turnus:").append(this.turnus).append(linesep);
            if (this.comment != null) {
                ret.append("Bemerkungen: ").append(this.comment).append(linesep);
            }
            if (this.address != null) {
                ret.append("Anschrift").append(linesep);
                ret.append(this.address.toString()).append(linesep);
            }
            return ret.toString().trim();
        }

        public static class Address {
            public String name1;
            public String name2;
            public String street_pf;
            public String plz_ort;
            public String plz;
            public String ort;
            public String country;
            public String tel;
            public String fax;
            public String email;

            public String toString() {
                StringBuffer ret = new StringBuffer();
                String linesep = System.getProperty("line.separator");
                ret.append(this.name1);
                if (this.name2 != null) {
                    ret.append(" " + this.name2);
                }
                ret.append(linesep);
                ret.append(this.street_pf).append(linesep);
                if (this.plz_ort != null) {
                    ret.append(this.plz_ort);
                } else {
                    ret.append(this.plz).append(" ").append(this.ort);
                }
                ret.append(linesep);
                if (this.country != null) {
                    ret.append(this.country).append(linesep);
                }
                if (this.tel != null) {
                    ret.append("Tel: ").append(this.tel).append(linesep);
                }
                if (this.fax != null) {
                    ret.append("Fax: ").append(this.fax).append(linesep);
                }
                if (this.email != null) {
                    ret.append("Email: ").append(this.email).append(linesep);
                }
                return ret.toString();
            }
        }
    }
}

