/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRTANList;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIMsgStatus;

public class GVTANList
extends HBCIJobImpl {
    public static String getLowlevelName() {
        return "TANListList";
    }

    public GVTANList(HBCIHandler handler) {
        super(handler, GVTANList.getLowlevelName(), new GVRTANList());
    }

    @Override
    public void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        String tanheader;
        Properties result = msgstatus.getData();
        GVRTANList.TANList list = new GVRTANList.TANList();
        list.status = result.getProperty(header + ".liststatus").charAt(0);
        list.number = result.getProperty(header + ".listnumber");
        String st = result.getProperty(header + ".date");
        if (st != null) {
            list.date = HBCIUtils.string2DateISO(st);
        }
        list.nofTANsPerList = Integer.parseInt(result.getProperty(header + ".noftansperlist", "0"));
        list.nofUsedTANsPerList = Integer.parseInt(result.getProperty(header + ".nofusedtansperlist", "0"));
        int i = 0;
        while ((st = result.getProperty((tanheader = HBCIUtils.withCounter(header + ".TANInfo", i)) + ".usagecode")) != null) {
            GVRTANList.TANInfo info = new GVRTANList.TANInfo();
            info.usagecode = Integer.parseInt(st);
            info.usagetxt = result.getProperty(tanheader + ".usagetxt");
            info.tan = result.getProperty(tanheader + ".tan");
            String usagedate = result.getProperty(tanheader + ".usagedate");
            String usagetime = result.getProperty(tanheader + ".usagetime");
            if (usagedate != null) {
                info.timestamp = usagetime == null ? HBCIUtils.string2DateISO(usagedate) : HBCIUtils.strings2DateTimeISO(usagedate, usagetime);
            }
            list.addTANInfo(info);
            ++i;
        }
        ((GVRTANList)this.jobResult).addTANList(list);
    }
}

