/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import java.util.List;
import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.callback.HBCICallbackConsole;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportPinTan;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;

public final class AnalyzeReportOfTransactions {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        HBCIUtils.refreshBLZList(ClassLoader.getSystemResource("blz.properties").openStream());
        Properties properties = new Properties();
        properties.put("kernel.rewriter", "InvalidSegment,WrongStatusSegOrder,WrongSequenceNumbers,MissingMsgRef,HBCIVersion,SigIdLeadingZero,InvalidSuppHBCIVersion,SecTypeTAN,KUmsDelimiters,KUmsEmptyBDateSets");
        properties.put("client.passport.default", "PinTanNoFile");
        properties.put("log.loglevel.default", "2");
        properties.put("default.hbciversion", "FinTS3");
        properties.put("client.passport.PinTan.checkcert", "1");
        properties.put("client.passport.PinTan.init", "1");
        properties.put("client.passport.country", "DE");
        properties.put("client.passport.blz", System.getProperty("blz"));
        properties.put("client.passport.customerId", System.getProperty("login"));
        HBCIPassportPinTan passport = (HBCIPassportPinTan)AbstractHBCIPassport.getInstance(new HBCICallbackConsole(), properties);
        passport.setPIN(System.getProperty("pin"));
        HBCIHandler hbciHandle = null;
        try {
            hbciHandle = new HBCIHandler(passport);
            AnalyzeReportOfTransactions.analyzeReportOfTransactions(passport, hbciHandle);
        }
        finally {
            if (hbciHandle != null) {
                hbciHandle.close();
            } else if (passport != null) {
                passport.close();
            }
        }
    }

    private static void analyzeReportOfTransactions(HBCIPassport hbciPassport, HBCIHandler hbciHandle) {
        Konto myaccount = hbciPassport.getAccounts()[0];
        HBCIJobImpl bankAccountStatementJob = hbciHandle.newJob("KUmsAll");
        bankAccountStatementJob.setParam("my", myaccount);
        bankAccountStatementJob.addToQueue();
        HBCIExecStatus ret = hbciHandle.execute();
        GVRKUms result = (GVRKUms)bankAccountStatementJob.getJobResult();
        if (result.isOK()) {
            System.out.println("************************** RESULT of **************************");
            System.out.println("****************  AnalyzeReportOfTransactions  ****************\n");
            System.out.println(result.toString());
            System.out.println("***************************************************************");
            List<GVRKUms.UmsLine> lines = result.getFlatData();
            for (GVRKUms.UmsLine entry : lines) {
                List<String> usages = entry.usage;
                for (String usageline : usages) {
                    System.out.println(usageline);
                }
            }
        } else {
            System.out.println("Job-Error");
            System.out.println(result.getJobStatus().getErrorString());
            System.out.println("Global Error");
            System.out.println(ret.getErrorString());
        }
    }

    @Deprecated
    public final void main_multithreaded(String[] str) {
    }
}

