/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.comm;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.kapott.hbci.comm.Comm;
import org.kapott.hbci.comm.PinTanProxyAuthenticator;
import org.kapott.hbci.comm.PinTanSSLHostnameVerifier;
import org.kapott.hbci.comm.PinTanSSLSocketFactory;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.AbstractPinTanPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.protocol.MSG;

public final class CommPinTan
extends Comm {
    private URL url;
    private HttpURLConnection conn;
    private boolean checkCert;
    private SSLSocketFactory mySocketFactory;
    private HostnameVerifier myHostnameVerifier;
    private static final int HTTP_CONNECT_TIMEOUT = 60000;
    private static final int HTTP_READ_TIMEOUT = 300000;

    public CommPinTan() {
    }

    public CommPinTan(HBCIPassportInternal parentPassport) {
        super(parentPassport);
        this.checkCert = ((AbstractPinTanPassport)parentPassport).getCheckCert();
        String trustStore = ((AbstractPinTanPassport)parentPassport).getCertFile();
        if (this.checkCert && trustStore != null && trustStore.length() != 0) {
            System.setProperty("javax.net.ssl.trustStore", trustStore);
        }
        try {
            HBCIUtils.log("connect: " + parentPassport.getHost(), 3);
            this.url = new URL(parentPassport.getHost());
            this.mySocketFactory = new PinTanSSLSocketFactory((AbstractPinTanPassport)parentPassport);
            this.myHostnameVerifier = new PinTanSSLHostnameVerifier();
            String[] proxyData = ((AbstractPinTanPassport)parentPassport).getProxy().split(":");
            if (proxyData.length == 2) {
                HBCIUtils.log("HTTPS connections will be made using proxy " + proxyData[0] + "(Port " + proxyData[1] + ")", 3);
                Properties sysProps = System.getProperties();
                sysProps.put("https.proxyHost", proxyData[0]);
                sysProps.put("https.proxyPort", proxyData[1]);
                HBCIUtils.log("initializing HBCI4Java proxy authentication callback", 4);
                Authenticator.setDefault(new PinTanProxyAuthenticator(parentPassport));
            }
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_CONNERR"), e);
        }
    }

    @Override
    protected void ping(MSG msg) {
        try {
            byte[] b = this.getPassport().getCommFilter().encode(msg.toString(0));
            HBCIUtils.log("connecting to server", 4);
            this.conn = (HttpURLConnection)this.url.openConnection();
            this.conn.setConnectTimeout(60000);
            this.conn.setReadTimeout(300000);
            boolean checkCert = ((AbstractPinTanPassport)this.getPassport()).getCheckCert();
            boolean debugging = ((PinTanSSLSocketFactory)this.mySocketFactory).debug();
            if (!checkCert || debugging) {
                HttpsURLConnection connSSL = (HttpsURLConnection)this.conn;
                HBCIUtils.log("activating modified socket factory for checkCert=" + checkCert + " and debugging=" + debugging, 4);
                connSSL.setSSLSocketFactory(this.mySocketFactory);
                if (!checkCert) {
                    HBCIUtils.log("activating modified hostname verifier because cert checking is disabled", 4);
                    connSSL.setHostnameVerifier(this.myHostnameVerifier);
                }
            }
            this.conn.setDoOutput(true);
            this.conn.setRequestMethod("POST");
            this.conn.setRequestProperty("Content-Type", "application/octet-stream");
            this.conn.setFixedLengthStreamingMode(b.length);
            this.conn.connect();
            OutputStream out = this.conn.getOutputStream();
            HBCIUtils.log("POST data to output stream", 4);
            out.write(b);
            out.flush();
            HBCIUtils.log("closing output stream", 4);
            out.close();
        }
        catch (Exception e) {
            HBCI_Exception he = new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_SENDERR"), e);
            he.setFatal(true);
            throw he;
        }
    }

    @Override
    protected StringBuffer pong(MsgGen gen) {
        try {
            int num;
            byte[] b = new byte[1024];
            StringBuffer ret = new StringBuffer();
            HBCIUtils.log(HBCIUtils.getLocMsg("STATUS_MSG_RECV"), 4);
            int msgsize = this.conn.getContentLength();
            if (msgsize != -1) {
                HBCIUtils.log("found messagesize: " + msgsize, 4);
            } else {
                HBCIUtils.log("can not determine message size, trying to detect automatically", 4);
            }
            InputStream i = this.conn.getInputStream();
            while (msgsize != 0 && (num = i.read(b)) > 0) {
                HBCIUtils.log("received " + num + " bytes", 5);
                ret.append(new String(b, 0, num, "ISO-8859-1"));
                if ((msgsize -= num) >= 0) {
                    HBCIUtils.log("we still need " + msgsize + " bytes", 5);
                    continue;
                }
                HBCIUtils.log("read " + num + " bytes, looking for more", 5);
            }
            HBCIUtils.log("closing communication line", 4);
            this.conn.disconnect();
            return new StringBuffer(this.getPassport().getCommFilter().decode(ret.toString()));
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_RECVERR"), e);
        }
    }

    @Override
    protected void closeConnection() {
    }
}

