/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV_Result;

import java.util.ArrayList;
import java.util.List;
import org.kapott.hbci.GV_Result.GVRFestCondList;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public final class GVRFestList
extends HBCIJobResultImpl {
    private List<Entry> entries = new ArrayList<Entry>();

    public void addEntry(Entry entry) {
        this.entries.add(entry);
    }

    public Entry[] getEntries() {
        return this.entries.toArray(new Entry[this.entries.size()]);
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        String linesep = System.getProperty("line.separator");
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = this.entries.get(i);
            ret.append("Festgeldanlage #").append(i).append(linesep);
            ret.append(entry.toString());
            ret.append(linesep + linesep);
        }
        return ret.toString().trim();
    }

    public static final class Entry {
        public Konto anlagekonto;
        public Konto belastungskonto;
        public Konto ausbuchungskonto;
        public Konto zinskonto;
        public String id;
        public Value anlagebetrag;
        public Value zinsbetrag;
        public GVRFestCondList.Cond konditionen;
        public boolean verlaengern;
        public int kontoauszug;
        public int status;
        public Prolong verlaengerung;

        public String toString() {
            StringBuffer ret = new StringBuffer();
            String linesep = System.getProperty("line.separator");
            if (this.anlagekonto != null) {
                ret.append("Anlagekonto: ").append(this.anlagekonto.toString()).append(linesep);
            }
            ret.append("Belastungskonto: ").append(this.belastungskonto.toString()).append(linesep);
            ret.append("Ausbuchungskonto: ").append(this.ausbuchungskonto != null ? this.ausbuchungskonto.toString() : this.belastungskonto.toString()).append(linesep);
            ret.append("Zinskonto: ").append(this.zinskonto != null ? this.zinskonto.toString() : this.belastungskonto.toString()).append(linesep);
            ret.append("Anlagebetrag: ").append(this.anlagebetrag.toString()).append(linesep);
            if (this.zinsbetrag != null) {
                ret.append("Voraussichtlicher Zinsbetrag: ").append(this.zinsbetrag.toString()).append(linesep);
            }
            ret.append("Nach Ablauf verl\u00e4ngern: ").append(Boolean.toString(this.verlaengern)).append(linesep);
            ret.append(this.konditionen.toString() + linesep);
            if (this.verlaengern) {
                ret.append(linesep + this.verlaengerung.toString());
            }
            return ret.toString().trim();
        }

        public static final class Prolong {
            public int laufzeit;
            public Value betrag;
            public boolean verlaengern;

            public String toString() {
                StringBuffer ret = new StringBuffer();
                ret.append("Verl\u00e4ngerung: ");
                ret.append("Laufzeit ");
                ret.append(Integer.toString(this.laufzeit));
                ret.append(" Betrag ");
                ret.append(this.betrag.toString());
                ret.append(" weiter_verlaengern: ");
                ret.append(Boolean.toString(this.verlaengern));
                return ret.toString();
            }
        }
    }
}

