/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Enumeration;
import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRTermUebList;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public final class GVTermUebList
extends HBCIJobImpl {
    public static String getLowlevelName() {
        return "TermUebList";
    }

    public GVTermUebList(HBCIHandler handler) {
        super(handler, GVTermUebList.getLowlevelName(), new GVRTermUebList());
        this.addConstraint("my.country", "KTV.KIK.country", "DE", 0);
        this.addConstraint("my.blz", "KTV.KIK.blz", null, 3);
        this.addConstraint("my.number", "KTV.number", null, 2);
        this.addConstraint("my.subnumber", "KTV.subnumber", "", 3);
        this.addConstraint("startdate", "startdate", "", 0);
        this.addConstraint("enddate", "enddate", "", 0);
        this.addConstraint("maxentries", "maxentries", "", 0);
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        String usage;
        Properties result = msgstatus.getData();
        GVRTermUebList.Entry entry = new GVRTermUebList.Entry();
        entry.my = new Konto();
        entry.my.blz = result.getProperty(header + ".My.KIK.blz");
        entry.my.country = result.getProperty(header + ".My.KIK.country");
        entry.my.number = result.getProperty(header + ".My.number");
        entry.my.subnumber = result.getProperty(header + ".My.subnumber");
        this.getMainPassport().fillAccountInfo(entry.my);
        entry.other = new Konto();
        entry.other.blz = result.getProperty(header + ".Other.KIK.blz");
        entry.other.country = result.getProperty(header + ".Other.KIK.country");
        entry.other.number = result.getProperty(header + ".Other.number");
        entry.other.subnumber = result.getProperty(header + ".Other.subnumber");
        entry.other.name = result.getProperty(header + ".name");
        entry.other.name2 = result.getProperty(header + ".name2");
        this.getMainPassport().fillAccountInfo(entry.other);
        entry.key = result.getProperty(header + ".key");
        entry.addkey = result.getProperty(header + ".addkey");
        entry.orderid = result.getProperty(header + ".id");
        entry.date = HBCIUtils.string2DateISO(result.getProperty(header + ".date"));
        entry.value = new Value(result.getProperty(header + ".BTG.value"), result.getProperty(header + ".BTG.curr"));
        int i = 0;
        while ((usage = result.getProperty(HBCIUtils.withCounter(header + ".usage.usage", i))) != null) {
            entry.addUsage(usage);
            ++i;
        }
        ((GVRTermUebList)this.jobResult).addEntry(entry);
        if (entry.orderid != null && entry.orderid.length() != 0) {
            Properties p2 = new Properties();
            Enumeration<?> e = result.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith(header + ".") || key.startsWith(header + ".SegHead.") || key.endsWith(".id")) continue;
                p2.setProperty(key.substring(header.length() + 1), result.getProperty(key));
            }
            this.getMainPassport().setPersistentData("termueb_" + entry.orderid, p2);
        }
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

