/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRKontoauszug;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.swift.Swift;

public class GVKontoauszug
extends HBCIJobImpl {
    public static final String FORMAT_MT940 = "1";
    public static final String FORMAT_ISO8583 = "2";
    public static final String FORMAT_PDF = "3";

    public static String getLowlevelName() {
        return "Kontoauszug";
    }

    public GVKontoauszug(HBCIHandler handler, String name) {
        super(handler, name, new GVRKontoauszug());
    }

    public GVKontoauszug(HBCIHandler handler) {
        this(handler, GVKontoauszug.getLowlevelName());
        this.addConstraint("my.country", "My.KIK.country", "DE", 0);
        this.addConstraint("my.blz", "My.KIK.blz", null, 3);
        this.addConstraint("my.number", "My.number", null, 2);
        this.addConstraint("my.subnumber", "My.subnumber", "", 3);
        this.addConstraint("format", "format", "", 0);
        this.addConstraint("idx", "idx", "", 0);
        this.addConstraint("year", "year", "", 0);
        this.addConstraint("maxentries", "maxentries", "", 0);
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        GVRKontoauszug umsResult = (GVRKontoauszug)this.jobResult;
        String format = result.getProperty(header + ".format");
        String rawData = result.getProperty(header + ".booked");
        if (rawData != null) {
            if (format.equals(FORMAT_MT940)) {
                umsResult.appendMT940Data(Swift.decodeUmlauts(rawData));
            } else if (format.equals(FORMAT_ISO8583)) {
                umsResult.appendISOData(rawData);
            } else if (format.equals(FORMAT_PDF)) {
                umsResult.appendPDFData(rawData);
            } else {
                HBCIUtils.log("unknown format in result for GV Kontoauszug: " + format, 1);
            }
        }
        umsResult.setFormat(format);
        umsResult.setStartDate(HBCIUtils.string2DateISO(result.getProperty(header + ".TimeRange.startdate")));
        umsResult.setEndDate(HBCIUtils.string2DateISO(result.getProperty(header + ".TimeRange.enddate")));
        umsResult.setAbschlussInfo(result.getProperty(header + ".abschlussinfo"));
        umsResult.setKundenInfo(result.getProperty(header + ".kondinfo"));
        umsResult.setWerbetext(result.getProperty(header + ".ads"));
        umsResult.setIBAN(result.getProperty(header + ".iban"));
        umsResult.setBIC(result.getProperty(header + ".bic"));
        umsResult.setName(result.getProperty(header + ".name"));
        umsResult.setName2(result.getProperty(header + ".name2"));
        umsResult.setName3(result.getProperty(header + ".name3"));
        umsResult.setReceipt(result.getProperty(header + ".receipt"));
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

