/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRAccInfo;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class GVAccInfo
extends HBCIJobImpl {
    public static String getLowlevelName() {
        return "AccInfo";
    }

    public GVAccInfo(HBCIHandler handler) {
        super(handler, GVAccInfo.getLowlevelName(), new GVRAccInfo());
        this.addConstraint("my.country", "KTV.KIK.country", "DE", 0);
        this.addConstraint("my.blz", "KTV.KIK.blz", null, 3);
        this.addConstraint("my.number", "KTV.number", null, 2);
        this.addConstraint("my.subnumber", "KTV.subnumber", "", 3);
        this.addConstraint("all", "allaccounts", "N", 0);
    }

    @Override
    public void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        GVRAccInfo.AccInfo info = new GVRAccInfo.AccInfo();
        info.account = new Konto();
        info.account.blz = result.getProperty(header + ".My.KIK.blz");
        info.account.country = result.getProperty(header + ".My.KIK.country");
        info.account.number = result.getProperty(header + ".My.number");
        info.account.subnumber = result.getProperty(header + ".My.subnumber");
        info.account.curr = result.getProperty(header + ".curr");
        info.account.name = result.getProperty(header + ".name");
        info.account.name2 = result.getProperty(header + ".name2");
        info.account.type = result.getProperty(header + ".accbez");
        info.comment = result.getProperty(header + ".info");
        String st = result.getProperty(header + ".opendate");
        if (st != null) {
            info.created = HBCIUtils.string2DateISO(st);
        }
        info.habenzins = (st = result.getProperty(header + ".habenzins")) != null ? HBCIUtils.string2Long(st, 1000L) : -1L;
        st = result.getProperty(header + ".sollzins");
        info.sollzins = st != null ? HBCIUtils.string2Long(st, 1000L) : -1L;
        st = result.getProperty(header + ".overdrivezins");
        info.ueberzins = st != null ? HBCIUtils.string2Long(st, 1000L) : -1L;
        st = result.getProperty(header + ".kredit.value");
        if (st != null) {
            info.kredit = new Value(st, result.getProperty(header + ".kredit.curr"));
        }
        if ((st = result.getProperty(header + ".refkto.number")) != null) {
            info.refAccount = new Konto(result.getProperty(header + ".refkto.KIK.country"), result.getProperty(header + ".refkto.KIK.blz"), st, result.getProperty(header + ".refkto.subnumber"));
        }
        info.turnus = (st = result.getProperty(header + ".turnus")) != null ? Integer.parseInt(st) : -1;
        st = result.getProperty(header + ".versandart");
        info.versandart = st != null ? Integer.parseInt(st) : -1;
        st = result.getProperty(header + ".acctype");
        int n = info.type = st != null ? Integer.parseInt(st) : -1;
        if (result.getProperty(header + ".Address.name1") != null) {
            info.address = new GVRAccInfo.AccInfo.Address();
            info.address.name1 = result.getProperty(header + ".Address.name1");
            info.address.name2 = result.getProperty(header + ".Address.name2");
            info.address.street_pf = result.getProperty(header + ".Address.street_pf");
            if (result.getProperty(header + ".Address.plz") != null) {
                info.address.plz = result.getProperty(header + ".Address.plz");
                info.address.ort = result.getProperty(header + ".Address.ort");
                info.address.country = result.getProperty(header + ".Address.country");
                info.address.tel = result.getProperty(header + ".Address.tel");
                info.address.fax = result.getProperty(header + ".Address.fax");
                info.address.email = result.getProperty(header + ".Address.email");
            } else {
                info.address.plz_ort = result.getProperty(header + ".Address.plz_ort");
                info.address.tel = result.getProperty(header + ".Address.tel");
            }
        }
        ((GVRAccInfo)this.getJobResult()).addEntry(info);
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

