/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.datatypes.SyntaxWrt;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.swift.DTAUS;

public abstract class AbstractMultiGV
extends HBCIJobImpl {
    public AbstractMultiGV(HBCIHandler handler, String jobnameLL, HBCIJobResultImpl jobResult) {
        super(handler, jobnameLL, jobResult);
    }

    @Override
    public String getChallengeParam(String path) {
        String ret = null;
        if (path.startsWith("sum")) {
            String dtausdata = this.getLowlevelParams().getProperty(this.getName() + ".data");
            DTAUS dtaus = new DTAUS(dtausdata.substring(1));
            if (path.equals("sumOthers")) {
                long sum = 0L;
                ArrayList<DTAUS.Transaction> entries = dtaus.getEntries();
                for (DTAUS.Transaction entry : entries) {
                    sum += Long.parseLong(entry.otherAccount.number);
                }
                ret = Long.toString(sum);
                if (ret.length() > 10) {
                    ret = ret.substring(0, 10);
                }
            } else if (path.equals("sumValue")) {
                long sum = 0L;
                ArrayList<DTAUS.Transaction> entries = dtaus.getEntries();
                for (DTAUS.Transaction entry : entries) {
                    sum += entry.value.getLongValue();
                }
                String v = HBCIUtils.bigDecimal2String(new BigDecimal(sum).divide(new BigDecimal("100.0")));
                ret = new SyntaxWrt(v, 1, 0).toString();
            } else if (path.equals("sumCurr")) {
                ret = dtaus.getCurr() == 32 ? "DEM" : "EUR";
            } else if (path.equals("sumCount")) {
                ret = Integer.toString(dtaus.getEntries().size());
            }
        } else {
            ret = super.getChallengeParam(path);
        }
        return ret;
    }
}

