/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.protocol.MSG;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class SyntaxCheck {
    private static String getArg(String[] args, int idx, String st) throws IOException {
        String ret = null;
        if (args != null && idx < args.length) {
            ret = args[idx];
        } else {
            System.out.print(st + ": ");
            System.out.flush();
            ret = new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        return ret;
    }

    public static void main(String[] args) throws IOException {
        int len;
        String ifilename = SyntaxCheck.getArg(args, 0, "Dateiname der Datei mit der HBCI-Nachricht");
        String version = SyntaxCheck.getArg(args, 1, "HBCI-Version");
        String msgName = SyntaxCheck.getArg(args, 2, "Name der Nachricht");
        String checkSeq_st = SyntaxCheck.getArg(args, 3, "Sequenznummern validieren (0/1)");
        boolean checkSeq = checkSeq_st.equals("1");
        String checkValids_st = SyntaxCheck.getArg(args, 4, "Auf g\u00fcltige Werte testen (0/1)");
        boolean checkValids = checkValids_st.equals("1");
        Properties props = new Properties();
        props.setProperty("log.loglevel.default", "6");
        FileInputStream fi = new FileInputStream(ifilename);
        byte[] buffer = new byte[1024];
        StringBuffer st = new StringBuffer();
        while ((len = fi.read(buffer)) > 0) {
            st.append(new String(buffer, 0, len, "ISO-8859-1"));
        }
        fi.close();
        MsgGen gen = new MsgGen(SyntaxCheck.class.getClassLoader().getResourceAsStream("hbci-" + version + ".xml"));
        if (msgName != null && msgName.length() != 0) {
            MSG msg = new MSG(msgName, st.toString(), st.length(), gen, checkSeq, checkValids);
            String st2 = msg.toString(0);
            if (st2.equals(st.toString())) {
                System.out.println("ok");
            } else {
                System.out.println("detected, but different in- and output");
                System.out.println(st2);
            }
            Properties p = msg.getData();
            ArrayList al = new ArrayList();
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                al.add(e.nextElement());
            }
            Object[] sa = al.toArray(new String[al.size()]);
            Arrays.sort(sa);
            for (int i = 0; i < sa.length; ++i) {
                String value = p.getProperty((String)sa[i]);
                System.out.println((String)sa[i] + " = " + value + " (" + value.length() + " Bytes)");
            }
        } else {
            NodeList list = gen.getSyntax().getElementsByTagName("MSGdef");
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                MSG msg;
                msgName = ((Element)list.item(i)).getAttribute("id");
                System.out.println("checking for '" + msgName + "'");
                try {
                    msg = new MSG(msgName, st.toString(), st.length(), gen, checkSeq, checkValids);
                }
                catch (Exception e) {
                    msg = null;
                }
                if (msg == null) continue;
                String st2 = msg.toString(0);
                if (st2.equals(st.toString())) {
                    System.out.println("ok");
                    continue;
                }
                System.out.println("detected, but different in- and output");
                System.out.println(st2);
            }
        }
    }
}

