/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.structures;

import java.io.Serializable;
import java.util.List;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.structures.Limit;

public class Konto
implements Serializable {
    public String country;
    public String blz;
    public String number;
    public String subnumber;
    public String acctype;
    public String type;
    public String curr = "EUR";
    public String customerid;
    public String name;
    public String name2;
    public Limit limit;
    public List allowedGVs;
    public String bic;
    public String iban;

    public Konto() {
    }

    public Konto(String blz, String number) {
        this("DE", blz, number);
    }

    public Konto(String country, String blz, String number) {
        this(country, blz, number, null);
    }

    public Konto(String country, String blz, String number, String subnumber) {
        this();
        this.country = country;
        this.blz = blz;
        this.number = number;
        this.subnumber = subnumber;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        if (this.type != null) {
            ret.append(this.type + " ");
        }
        if (this.name != null) {
            ret.append(this.name + " ");
        }
        if (this.name2 != null) {
            ret.append(this.name2 + " ");
        }
        if (this.number != null) {
            ret.append(this.number);
        }
        if (this.subnumber != null) {
            ret.append("/" + this.subnumber);
        }
        ret.append(" ");
        if (this.blz != null) {
            ret.append("BLZ " + this.blz + " (" + HBCIUtils.getNameForBLZ(this.blz) + ") ");
        }
        if (this.bic != null) {
            ret.append("BIC " + this.bic + " ");
        }
        if (this.iban != null) {
            ret.append("IBAN " + this.iban + " ");
        }
        if (this.country != null) {
            ret.append("[" + this.country + "] ");
        }
        if (this.curr != null) {
            ret.append("(" + this.curr + ")");
        }
        return ret.toString();
    }

    public boolean checkCRC() {
        return HBCIUtils.checkAccountCRC(this.blz, this.number);
    }

    public boolean checkIBAN() {
        return HBCIUtils.checkIBANCRC(this.iban);
    }

    public boolean equals(Object o) {
        boolean ret;
        if (o instanceof Konto) {
            Konto acc = (Konto)o;
            ret = true;
            ret &= this.blz == null && acc.blz == null || this.blz.equals(acc.blz);
            ret &= this.country == null && acc.country == null || this.country.equals(acc.country);
            ret &= this.number == null && acc.number == null || this.number.equals(acc.number);
            ret &= this.subnumber == null && acc.subnumber == null || this.subnumber.equals(acc.subnumber);
            ret &= this.curr == null && acc.curr == null || this.curr.equals(acc.curr);
            ret &= this.customerid == null && acc.customerid == null || this.customerid.equals(acc.customerid);
            ret &= this.name == null && acc.name == null || this.name.equals(acc.name);
            ret &= this.name2 == null && acc.name2 == null || this.name2.equals(acc.name2);
            ret &= this.type == null && acc.type == null || this.type.equals(acc.type);
            ret &= this.bic == null && acc.bic == null || this.bic.equals(acc.bic);
            ret &= this.iban == null && acc.iban == null || this.iban.equals(acc.iban);
        } else {
            ret = super.equals(o);
        }
        return ret;
    }

    public boolean isSEPAAccount() {
        return this.bic != null && this.iban != null && this.bic.length() != 0 && this.iban.length() != 0;
    }
}

