/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.smartcardio;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.smartcardio.Card;
import javax.smartcardio.CommandAPDU;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.smartcardio.HBCICardService;
import org.kapott.hbci.smartcardio.RSABankData;
import org.kapott.hbci.smartcardio.RSAKeyData;

public class RSACardService
extends HBCICardService {
    static final int ISO7816_CLA_STD = 0;
    static final int ISO7816_INS_SELECT_FILE = 164;
    static final int ISO7816_INS_VERIFY = 32;
    static final int ISO7816_INS_READ_BINARY = 176;
    static final int ISO7816_PWD_TYPE_DF = 128;
    private byte[] cid;

    @Override
    public void init(Card card) {
        super.init(card);
        this.selectFile(16128);
        this.selectFile(12034);
        byte[] data = this.readBinary(0, 0);
        SimpleTLV tlv = new SimpleTLV(data);
        if (tlv.isMalformed() || tlv.getSize() != 1 || tlv.getTag(0) != 90) {
            throw new HBCI_Exception("malformed tlv for fid 0x2F02");
        }
        byte[] content = tlv.getContent(0);
        if (content.length != 10) {
            throw new HBCI_Exception("malformed tlv for fid 0x2F02");
        }
        this.cid = new byte[5];
        System.arraycopy(content, 4, this.cid, 0, 5);
        this.selectFile(42496);
    }

    public byte[] getCID() {
        return (byte[])this.cid.clone();
    }

    private void selectFile(int fid) {
        byte[] data = new byte[]{(byte)(fid >> 8 & 0xFF), (byte)(fid & 0xFF)};
        CommandAPDU command = new CommandAPDU(0, 164, 0, 12, data);
        this.send(command);
    }

    private byte[] readBinary(int offset, int length) {
        int p1 = offset >> 8 & 0x7F;
        int p2 = offset & 0xFF;
        int ne = length == 0 ? 256 : length;
        CommandAPDU command = new CommandAPDU(0, 176, p1, p2, ne);
        return this.receive(command);
    }

    @Override
    protected byte[] createPINVerificationDataStructure(int pwdId) throws IOException {
        ByteArrayOutputStream verifyCommand = new ByteArrayOutputStream();
        verifyCommand.write(255);
        verifyCommand.write(0);
        verifyCommand.write(130);
        verifyCommand.write(0);
        verifyCommand.write(0);
        verifyCommand.write(new byte[]{32, 0});
        verifyCommand.write(2);
        verifyCommand.write(1);
        verifyCommand.write(new byte[]{4, 9});
        verifyCommand.write(0);
        verifyCommand.write(new byte[]{0, 0, 0});
        byte[] verifyApdu = new byte[]{0, 32, 0, (byte)(0x80 | pwdId), 8, 32, 32, 32, 32, 32, 32, 32, 32};
        verifyCommand.write(verifyApdu.length & 0xFF);
        verifyCommand.write(0);
        verifyCommand.write(0);
        verifyCommand.write(0);
        verifyCommand.write(verifyApdu);
        return verifyCommand.toByteArray();
    }

    @Override
    public void verifySoftPIN(int pwdId, byte[] softPin) {
        if (softPin.length > 8) {
            throw new HBCI_Exception("illegal PIN size");
        }
        byte[] body = new byte[]{32, 32, 32, 32, 32, 32, 32, 32};
        System.arraycopy(softPin, 0, body, 0, softPin.length);
        CommandAPDU command = new CommandAPDU(0, 32, 0, (int)((byte)(0x80 | pwdId)), body);
        this.send(command);
    }

    public RSABankData readBankData(int idx) {
        this.selectFile(42499);
        byte[] rawData = this.readRecordBySFI(0, idx);
        if (rawData == null) {
            return null;
        }
        byte[] customerIdData = null;
        try {
            this.selectFile(42500);
            byte[] prefix = this.readBinary(0, 1);
            HBCIUtils.log("A604 prefix = " + prefix[0], 4);
            int max = prefix[0] >> 4;
            byte[] states = this.readBinary(1, max);
            for (int n = 0; n < max; ++n) {
                if (states[n] >> 4 != idx + 1 || (states[n] & 1) == 0) continue;
                customerIdData = this.readBinary(1 + max + n * 3 * 30, 30);
                break;
            }
        }
        catch (HBCI_Exception e) {
            HBCIUtils.log(e);
            customerIdData = null;
        }
        return new RSABankData(idx, rawData, customerIdData);
    }

    private String toHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (byte b : bytes) {
            String s = Integer.toHexString(b & 0xFF).toUpperCase();
            if (s.length() == 1) {
                sb.append("0");
            }
            sb.append(s);
            sb.append(" ");
        }
        return sb.toString();
    }

    public void writeBankData(int idx, RSABankData bankData) {
        byte[] rawData = bankData.toRecord();
        HBCIUtils.log("bankData=" + this.toHex(rawData), 4);
    }

    public RSAKeyData[] readKeyData(int idx) {
        this.selectFile(45824);
        byte[] verifyPKData = null;
        byte[] encipherPKData = null;
        byte[] signPKData = null;
        byte[] decipherPKData = null;
        byte[] pkCount = this.readBinary(0, 1);
        if (pkCount != null && pkCount.length == 1) {
            for (int n = 0; n < pkCount[0]; ++n) {
                byte[] pkData = this.readBinary(1 + n * 121, 121);
                if (pkData == null || pkData.length != 121) continue;
                if (pkData[0] == (byte)(145 + idx)) {
                    verifyPKData = pkData;
                }
                if (pkData[0] == (byte)(150 + idx)) {
                    encipherPKData = pkData;
                }
                if (pkData[0] == (byte)(129 + idx)) {
                    signPKData = pkData;
                }
                if (pkData[0] != (byte)(134 + idx)) continue;
                decipherPKData = pkData;
            }
        }
        this.selectFile(42498);
        byte[] rawData = this.readBinary(1 + idx * 4 * 8, 32);
        if (rawData == null) {
            return null;
        }
        return new RSAKeyData[]{new RSAKeyData(idx, RSAKeyData.Type.VERIFY, rawData, verifyPKData), new RSAKeyData(idx, RSAKeyData.Type.ENCIPHER, rawData, encipherPKData), new RSAKeyData(idx, RSAKeyData.Type.SIGN, rawData, signPKData), new RSAKeyData(idx, RSAKeyData.Type.DECIPHER, rawData, decipherPKData)};
    }

    public int readSigId(int idx) {
        this.selectFile(42497);
        byte[] rawData = this.readRecordBySFI(0, idx);
        if (rawData == null) {
            return 0;
        }
        return (rawData[0] & 0xFF) << 24 | (rawData[1] & 0xFF) << 16 | (rawData[2] & 0xFF) << 8 | rawData[3] & 0xFF;
    }

    public void writeSigId(int idx, int sigId) {
    }

    public byte[] sign(int idx, byte[] data) {
        this.send(new CommandAPDU(0, 34, 65, 182, new byte[]{-124, 1, (byte)(129 + idx), -125, 1, (byte)(129 + idx), -128, 1, 37}));
        this.send(new CommandAPDU(0, 42, 144, 129, data));
        return this.receive(new CommandAPDU(0, 42, 158, 154, 256));
    }

    public boolean verify(int idx, byte[] data, byte[] sig) {
        this.send(new CommandAPDU(0, 34, 65, 182, new byte[]{-124, 1, (byte)(129 + idx), -125, 1, (byte)(145 + idx), -128, 1, 37}));
        this.send(new CommandAPDU(0, 42, 144, 129, data));
        try {
            this.send(new CommandAPDU(0, 42, 0, 168, sig));
        }
        catch (HBCI_Exception e) {
            return false;
        }
        return true;
    }

    public byte[] encipher(int idx, byte[] data) {
        this.send(new CommandAPDU(0, 34, 65, 184, new byte[]{-124, 1, (byte)(134 + idx), -125, 1, (byte)(150 + idx)}));
        byte[] buffer = this.receive(new CommandAPDU(0, 42, 134, 128, data, 256));
        byte[] result = new byte[buffer.length - 1];
        System.arraycopy(buffer, 1, result, 0, result.length);
        return result;
    }

    public byte[] decipher(int idx, byte[] data) {
        byte[] buffer = new byte[data.length + 1];
        buffer[0] = 0;
        System.arraycopy(data, 0, buffer, 1, data.length);
        this.send(new CommandAPDU(0, 34, 65, 184, new byte[]{-124, 1, (byte)(134 + idx), -125, 1, (byte)(134 + idx)}));
        return this.receive(new CommandAPDU(0, 42, 128, 134, buffer, 256));
    }

    static class SimpleTLV {
        private final boolean malformed;
        private final byte[] data;
        private final byte[] tags;
        private final byte[][] contents;

        public SimpleTLV(byte[] data) {
            ArrayList<Byte> tags = new ArrayList<Byte>();
            ArrayList<byte[]> contents = new ArrayList<byte[]>();
            int pos = 0;
            while (pos < data.length) {
                int length;
                byte len;
                if (data[pos] == 0 || data[pos] == -1) {
                    ++pos;
                    continue;
                }
                if (data.length < pos + 2) {
                    pos = Integer.MAX_VALUE;
                    break;
                }
                byte tag = data[pos++];
                if ((len = data[pos++]) == -1) {
                    if (data.length < pos + 2) {
                        pos = Integer.MAX_VALUE;
                        break;
                    }
                    byte len1 = data[pos++];
                    byte len2 = data[pos++];
                    length = (len1 & 0xFF) << 8 | len2 & 0xFF;
                } else {
                    length = len & 0xFF;
                }
                if (data.length < pos + length) {
                    pos = Integer.MAX_VALUE;
                    break;
                }
                byte[] content = new byte[length];
                System.arraycopy(data, pos, content, 0, length);
                pos += length;
                tags.add(tag);
                contents.add(content);
            }
            byte[] tempTags = new byte[tags.size()];
            for (int n = 0; n < tags.size(); ++n) {
                tempTags[n] = (Byte)tags.get(n);
            }
            this.malformed = pos == Integer.MAX_VALUE;
            this.data = (byte[])data.clone();
            this.tags = this.malformed ? new byte[]{} : tempTags;
            this.contents = this.malformed ? new byte[0][0] : (byte[][])contents.toArray((T[])new byte[contents.size()][]);
        }

        public boolean isMalformed() {
            return this.malformed;
        }

        public byte[] getData() {
            return (byte[])this.data.clone();
        }

        public int getSize() {
            return this.tags.length;
        }

        public byte getTag(int idx) {
            return this.tags[idx];
        }

        public byte[] getContent(int idx) {
            return (byte[])this.contents[idx].clone();
        }
    }
}

