/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.smartcardio;

import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.smartcardio.DDVBankData;
import org.kapott.hbci.smartcardio.DDVKeyData;
import org.kapott.hbci.smartcardio.HBCICardService;

public abstract class DDVCardService
extends HBCICardService {
    public abstract DDVKeyData[] readKeyData();

    protected abstract byte[] calculateSignature(byte[] var1);

    public byte[] getCID() {
        return this.readRecordBySFI(25, 0);
    }

    public DDVBankData readBankData(int idx) {
        byte[] rawData = this.readRecordBySFI(26, idx);
        if (rawData == null) {
            return null;
        }
        try {
            DDVBankData ret = new DDVBankData();
            ret.recordnum = idx + 1;
            ret.shortname = new String(rawData, 0, 20, "ISO-8859-1").trim();
            StringBuffer blz = new StringBuffer();
            for (int i = 0; i < 4; ++i) {
                byte ch = rawData[20 + i];
                byte nibble = (byte)(ch >> 4 & 0xF);
                if (nibble > 9) {
                    nibble = (byte)(nibble ^ 0xF);
                }
                blz.append((char)(nibble + 48));
                nibble = (byte)(ch & 0xF);
                if (nibble > 9) {
                    nibble = (byte)(nibble ^ 0xF);
                }
                blz.append((char)(nibble + 48));
            }
            ret.blz = blz.toString();
            ret.commType = rawData[24];
            ret.commaddr = new String(rawData, 25, 28, "ISO-8859-1").trim();
            ret.commaddr2 = new String(rawData, 53, 2, "ISO-8859-1").trim();
            ret.country = new String(rawData, 55, 3, "ISO-8859-1").trim();
            ret.userid = new String(rawData, 58, 30, "ISO-8859-1").trim();
            return ret;
        }
        catch (HBCI_Exception e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new HBCI_Exception(e2);
        }
    }

    public void writeBankData(int idx, DDVBankData bankData) {
        try {
            byte[] rawData = new byte[88];
            System.arraycopy(this.expand(bankData.shortname, 20), 0, rawData, 0, 20);
            byte[] blzData = bankData.blz.getBytes("ISO-8859-1");
            for (int i = 0; i < 4; ++i) {
                byte ch1 = (byte)(blzData[i << 1] - 48);
                byte ch2 = (byte)(blzData[(i << 1) + 1] - 48);
                if (ch1 == 2 && ch2 == 0) {
                    ch1 = (byte)(ch1 ^ 0xF);
                }
                rawData[20 + i] = (byte)(ch1 << 4 | ch2);
            }
            rawData[24] = (byte)bankData.commType;
            System.arraycopy(this.expand(bankData.commaddr, 28), 0, rawData, 25, 28);
            System.arraycopy(this.expand(bankData.commaddr2, 2), 0, rawData, 53, 2);
            System.arraycopy(this.expand(bankData.country, 3), 0, rawData, 55, 3);
            System.arraycopy(this.expand(bankData.userid, 30), 0, rawData, 58, 30);
            this.updateRecordBySFI(26, idx, rawData);
        }
        catch (HBCI_Exception e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new HBCI_Exception(e2);
        }
    }

    public int readSigId() {
        int ret = -1;
        byte[] rawData = this.readRecordBySFI(28, 0);
        if (rawData != null) {
            ret = rawData[0] << 8 & 0xFF00 | rawData[1] & 0xFF;
        }
        return ret;
    }

    public void writeSigId(int sigId) {
        byte[] rawData = new byte[]{(byte)(sigId >> 8 & 0xFF), (byte)(sigId & 0xFF)};
        this.updateRecordBySFI(28, 0, rawData);
    }

    public byte[] sign(byte[] data) {
        byte[] data_l = new byte[8];
        byte[] data_r = new byte[12];
        System.arraycopy(data, 0, data_l, 0, 8);
        System.arraycopy(data, 8, data_r, 0, 12);
        this.updateRecordBySFI(27, 0, data_r);
        return this.calculateSignature(data_l);
    }

    public byte[][] getEncryptionKeys(int keynum) {
        byte[][] keys = new byte[2][16];
        for (int i = 0; i < 2; ++i) {
            byte[] challenge = this.getChallenge();
            System.arraycopy(challenge, 0, keys[0], i << 3, 8);
            byte[] enc = this.internalAuthenticate(keynum, challenge);
            System.arraycopy(enc, 0, keys[1], i << 3, 8);
        }
        return keys;
    }

    public byte[] decrypt(int keynum, byte[] encdata) {
        byte[] plaindata = new byte[16];
        for (int i = 0; i < 2; ++i) {
            byte[] enc = new byte[8];
            System.arraycopy(encdata, i << 3, enc, 0, 8);
            byte[] plain = this.internalAuthenticate(keynum, enc);
            System.arraycopy(plain, 0, plaindata, i << 3, 8);
        }
        return plaindata;
    }
}

