/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.protocol;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.NoSuchElementException;
import org.kapott.hbci.exceptions.NoSuchPathException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.protocol.MultipleDEGs;
import org.kapott.hbci.protocol.MultipleSEGs;
import org.kapott.hbci.protocol.MultipleSFs;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SF;
import org.kapott.hbci.protocol.factory.MultipleDEGsFactory;
import org.kapott.hbci.protocol.factory.MultipleDEsFactory;
import org.kapott.hbci.protocol.factory.MultipleSEGsFactory;
import org.kapott.hbci.protocol.factory.MultipleSFsFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class SyntaxElement {
    private List<MultipleSyntaxElements> childContainers;
    private String name;
    private String type;
    private String path;
    private char predelim;
    private boolean valid;
    private MultipleSyntaxElements parent;
    private int posInMsg;
    private Document syntax;
    private Node def;
    public static final boolean TRY_TO_CREATE = true;
    public static final boolean DONT_TRY_TO_CREATE = false;
    public static final boolean ALLOW_OVERWRITE = true;
    public static final boolean DONT_ALLOW_OVERWRITE = false;
    private boolean needsRequestTag;
    private boolean haveRequestTag;

    protected abstract String getElementTypeName();

    protected abstract char getInDelim();

    protected abstract MultipleSyntaxElements createNewChildContainer(Node var1, Document var2);

    protected abstract MultipleSyntaxElements parseNewChildContainer(Node var1, char var2, char var3, StringBuffer var4, int var5, Document var6, Hashtable<String, String> var7, Hashtable<String, String> var8);

    private void initData(String type, String name, String ppath, int idx, Document syntax) {
        if (this.getElementTypeName().equals("SEG")) {
            HBCIUtils.log("creating segment " + ppath + " -> " + name + "(" + idx + ")", 6);
        }
        this.type = type;
        this.name = name;
        this.parent = null;
        this.needsRequestTag = false;
        this.haveRequestTag = false;
        this.childContainers = new ArrayList<MultipleSyntaxElements>();
        this.predelim = '\u0000';
        this.syntax = syntax;
        this.def = null;
        StringBuffer temppath = new StringBuffer(128);
        if (ppath != null && ppath.length() != 0) {
            temppath.append(ppath).append(".");
        }
        temppath.append(HBCIUtilsInternal.withCounter(name, idx));
        this.path = temppath.toString();
        this.setValid(false);
        if (syntax != null) {
            this.def = this.getSyntaxDef(type, syntax);
            String requestTag = ((Element)this.def).getAttribute("needsRequestTag");
            if (requestTag != null && requestTag.equals("1")) {
                this.needsRequestTag = true;
            }
            try {
                int syntaxIdx = 0;
                for (Node ref = this.def.getFirstChild(); ref != null; ref = ref.getNextSibling()) {
                    if (ref.getNodeType() != 1) continue;
                    MultipleSyntaxElements child = this.createAndAppendNewChildContainer(ref, syntax);
                    if (child != null) {
                        child.setParent(this);
                        child.setSyntaxIdx(syntaxIdx);
                        if (this.getElementTypeName().equals("MSG")) {
                            HBCIUtils.log("child container " + child.getPath() + " has syntaxIdx=" + child.getSyntaxIdx(), 6);
                        }
                    }
                    ++syntaxIdx;
                }
                NodeList valueNodes = ((Element)this.def).getElementsByTagName("value");
                int len = valueNodes.getLength();
                String dottedPath = this.path + ".";
                for (int i = 0; i < len; ++i) {
                    Node valueNode = valueNodes.item(i);
                    String valuePath = ((Element)valueNode).getAttribute("path");
                    String value = valueNode.getFirstChild().getNodeValue();
                    String destpath = dottedPath + valuePath;
                    if (this.propagateValue(destpath, value, true, false)) continue;
                    throw new NoSuchPathException(destpath);
                }
                NodeList validNodes = ((Element)this.def).getElementsByTagName("valids");
                len = validNodes.getLength();
                dottedPath = this.getPath() + ".";
                for (int i = 0; i < len; ++i) {
                    Node validNode = validNodes.item(i);
                    String valuePath = ((Element)validNode).getAttribute("path");
                    String absPath = dottedPath + valuePath;
                    NodeList validvalueNodes = ((Element)validNode).getElementsByTagName("validvalue");
                    int len2 = validvalueNodes.getLength();
                    for (int j = 0; j < len2; ++j) {
                        Node validvalue = validvalueNodes.item(j);
                        String value = validvalue.getFirstChild().getNodeValue();
                        this.storeValidValueInDE(absPath, value);
                    }
                }
            }
            catch (RuntimeException e) {
                for (MultipleSyntaxElements o : this.getChildContainers()) {
                    if (o instanceof MultipleSFs) {
                        MultipleSFsFactory.getInstance().unuseObject(o);
                        continue;
                    }
                    if (o instanceof MultipleSEGs) {
                        MultipleSEGsFactory.getInstance().unuseObject(o);
                        continue;
                    }
                    if (o instanceof MultipleDEGs) {
                        MultipleDEGsFactory.getInstance().unuseObject(o);
                        continue;
                    }
                    MultipleDEsFactory.getInstance().unuseObject(o);
                }
                throw e;
            }
        }
    }

    protected SyntaxElement(String type, String name, String path, int idx, Document syntax) {
        this.initData(type, name, path, idx, syntax);
    }

    protected void init(String type, String name, String path, int idx, Document syntax) {
        this.initData(type, name, path, idx, syntax);
    }

    protected MultipleSyntaxElements createAndAppendNewChildContainer(Node ref, Document syntax) {
        MultipleSyntaxElements ret = this.createNewChildContainer(ref, syntax);
        if (ret != null) {
            this.addChildContainer(ret);
        }
        return ret;
    }

    protected boolean storeValidValueInDE(String destPath, String value) {
        boolean ret = false;
        ListIterator<MultipleSyntaxElements> i = this.childContainers.listIterator();
        while (i.hasNext()) {
            MultipleSyntaxElements l = (MultipleSyntaxElements)i.next();
            if (!l.storeValidValueInDE(destPath, value)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public int enumerateSegs(int startValue, boolean allowOverwrite) {
        int idx = startValue;
        for (MultipleSyntaxElements s : this.getChildContainers()) {
            if (s == null) continue;
            idx = s.enumerateSegs(idx, allowOverwrite);
        }
        return idx;
    }

    private void initData(String type, String name, String ppath, char predelim, int idx, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        this.type = type;
        this.name = name;
        this.parent = null;
        this.childContainers = new ArrayList<MultipleSyntaxElements>();
        this.predelim = predelim;
        this.needsRequestTag = false;
        this.haveRequestTag = false;
        this.syntax = syntax;
        this.def = null;
        this.posInMsg = fullResLen - res.length();
        StringBuffer temppath = new StringBuffer(128);
        if (ppath != null && ppath.length() != 0) {
            temppath.append(ppath).append(".");
        }
        temppath.append(HBCIUtilsInternal.withCounter(name, idx));
        this.path = temppath.toString();
        this.setValid(false);
        if (syntax != null) {
            this.def = this.getSyntaxDef(type, syntax);
            NodeList valueNodes = ((Element)this.def).getElementsByTagName("value");
            String dottedPath = this.getPath() + ".";
            int len = valueNodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node valueNode = valueNodes.item(i);
                String valuePath = ((Element)valueNode).getAttribute("path");
                String value = valueNode.getFirstChild().getNodeValue();
                predefs.put(dottedPath + valuePath, value);
            }
            if (valids != null) {
                NodeList validNodes = ((Element)this.def).getElementsByTagName("valids");
                len = validNodes.getLength();
                for (int i = 0; i < len; ++i) {
                    Node validNode = validNodes.item(i);
                    String valuePath = ((Element)validNode).getAttribute("path");
                    String absPath = dottedPath + valuePath;
                    NodeList validvalueNodes = ((Element)validNode).getElementsByTagName("validvalue");
                    int len2 = validvalueNodes.getLength();
                    for (int j = 0; j < len2; ++j) {
                        Node validvalue = validvalueNodes.item(j);
                        String value = validvalue.getFirstChild().getNodeValue();
                        valids.put(HBCIUtilsInternal.withCounter(absPath + ".value", j), value);
                    }
                }
            }
            try {
                int counter = 0;
                for (Node ref = this.def.getFirstChild(); ref != null; ref = ref.getNextSibling()) {
                    MultipleSyntaxElements child;
                    if (ref.getNodeType() != 1 || (child = this.parseAndAppendNewChildContainer(ref, counter++ == 0 ? predelim : this.getInDelim(), this.getInDelim(), res, fullResLen, syntax, predefs, valids)) == null) continue;
                    child.setParent(this);
                    if (!(this instanceof SF) || !this.getName().equals("Params") && !this.getName().equals("GVRes") || !((MultipleSEGs)child).hasValidChilds()) {
                        continue;
                    }
                    break;
                }
            }
            catch (RuntimeException e) {
                for (MultipleSyntaxElements o : this.getChildContainers()) {
                    if (o instanceof MultipleSFs) {
                        MultipleSFsFactory.getInstance().unuseObject(o);
                        continue;
                    }
                    if (o instanceof MultipleSEGs) {
                        MultipleSEGsFactory.getInstance().unuseObject(o);
                        continue;
                    }
                    if (o instanceof MultipleDEGs) {
                        MultipleDEGsFactory.getInstance().unuseObject(o);
                        continue;
                    }
                    MultipleDEsFactory.getInstance().unuseObject(o);
                }
                throw e;
            }
        }
        this.setValid(true);
    }

    protected SyntaxElement(String type, String name, String path, char predelim, int idx, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        this.initData(type, name, path, predelim, idx, res, fullResLen, syntax, predefs, valids);
    }

    protected void init(String type, String name, String path, char predelim, int idx, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        this.initData(type, name, path, predelim, idx, res, fullResLen, syntax, predefs, valids);
    }

    protected MultipleSyntaxElements parseAndAppendNewChildContainer(Node ref, char predelim0, char predelim1, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        MultipleSyntaxElements ret = this.parseNewChildContainer(ref, predelim0, predelim1, res, fullResLen, syntax, predefs, valids);
        if (ret != null) {
            this.addChildContainer(ret);
        }
        return ret;
    }

    public void extractValues(Hashtable<String, String> values) {
        ListIterator<MultipleSyntaxElements> i = this.childContainers.listIterator();
        while (i.hasNext()) {
            MultipleSyntaxElements l = (MultipleSyntaxElements)i.next();
            l.extractValues(values);
        }
    }

    protected void addChildContainer(MultipleSyntaxElements x) {
        this.childContainers.add(x);
    }

    public List<MultipleSyntaxElements> getChildContainers() {
        return this.childContainers;
    }

    public boolean propagateValue(String destPath, String value, boolean tryToCreate, boolean allowOverwrite) {
        boolean ret = false;
        if (destPath.equals(this.getPath())) {
            if (value == null || !value.equals("requested")) {
                throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_INVVALUE", new Object[]{destPath, value}));
            }
            this.haveRequestTag = true;
            ret = true;
        } else if (destPath.startsWith(this.getPath())) {
            ListIterator<MultipleSyntaxElements> i = this.childContainers.listIterator();
            while (i.hasNext()) {
                MultipleSyntaxElements l = (MultipleSyntaxElements)i.next();
                if (!l.propagateValue(destPath, value, tryToCreate, allowOverwrite)) continue;
                ret = true;
                break;
            }
            if (!ret && tryToCreate) {
                HBCIUtils.log(this.getPath() + ": could not set value for " + destPath, 6);
                String subPath = destPath.substring(this.getPath().length() + 1);
                HBCIUtils.log("  subpath is " + subPath, 6);
                int dotPos = subPath.indexOf(46);
                if (dotPos == -1) {
                    dotPos = subPath.length();
                }
                String subType = subPath.substring(0, dotPos);
                HBCIUtils.log("  subname is " + subType, 6);
                int counterPos = subType.indexOf(95);
                if (counterPos != -1) {
                    subType = subType.substring(0, counterPos);
                }
                HBCIUtils.log("  subType is " + subType, 6);
                boolean found = false;
                for (MultipleSyntaxElements c : this.childContainers) {
                    if (!c.getName().equals(subType)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    int newChildIdx = 0;
                    Node ref = null;
                    found = false;
                    for (ref = this.def.getFirstChild(); ref != null; ref = ref.getNextSibling()) {
                        if (ref.getNodeType() != 1) continue;
                        String type = ((Element)ref).getAttribute("type");
                        String name = ((Element)ref).getAttribute("name");
                        if (name.length() == 0) {
                            name = type;
                        }
                        if (name.equals(subType)) {
                            found = true;
                            break;
                        }
                        ++newChildIdx;
                    }
                    if (found) {
                        MultipleSyntaxElements child = this.createNewChildContainer(ref, this.syntax);
                        child.setParent(this);
                        child.setSyntaxIdx(newChildIdx);
                        if (this.getElementTypeName().equals("MSG")) {
                            HBCIUtils.log("child container " + child.getPath() + " has syntaxIdx=" + child.getSyntaxIdx(), 6);
                        }
                        int newPosi = 0;
                        for (MultipleSyntaxElements c : this.childContainers) {
                            if (c.getSyntaxIdx() > newChildIdx) break;
                            ++newPosi;
                        }
                        HBCIUtils.log("  inserting child container with syntaxIdx " + newChildIdx + " at position " + newPosi, 6);
                        this.childContainers.add(newPosi, child);
                        ret = child.propagateValue(destPath, value, tryToCreate, allowOverwrite);
                    }
                } else {
                    HBCIUtils.log("  subtype " + subType + " already existing - will not try to create", 6);
                }
            }
        }
        return ret;
    }

    public String getValueOfDE(String path) {
        MultipleSyntaxElements l;
        String ret = null;
        ListIterator<MultipleSyntaxElements> i = this.childContainers.listIterator();
        while (i.hasNext() && (ret = (l = (MultipleSyntaxElements)i.next()).getValueOfDE(path)) == null) {
        }
        return ret;
    }

    public String getValueOfDE(String path, int zero) {
        MultipleSyntaxElements l;
        String ret = null;
        ListIterator<MultipleSyntaxElements> i = this.childContainers.listIterator();
        while (i.hasNext() && (ret = (l = i.next()).getValueOfDE(path, 0)) == null) {
        }
        return ret;
    }

    public SyntaxElement getElement(String path) {
        SyntaxElement ret = null;
        if (this.getPath().equals(path)) {
            ret = this;
        } else {
            MultipleSyntaxElements l;
            ListIterator<MultipleSyntaxElements> i = this.childContainers.listIterator();
            while (i.hasNext() && (ret = (l = i.next()).getElement(path)) == null) {
            }
        }
        return ret;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    public final String getPath() {
        return this.path;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    protected char getPreDelim() {
        return this.predelim;
    }

    public final Node getSyntaxDef(String type, Document syntax) {
        Element ret = syntax.getElementById(type);
        if (ret == null) {
            throw new NoSuchElementException(this.getElementTypeName(), type);
        }
        return ret;
    }

    public String toString(int zero) {
        return this.toString();
    }

    protected final void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int checkSegSeq(int value) {
        for (MultipleSyntaxElements a : this.childContainers) {
            value = a.checkSegSeq(value);
        }
        return value;
    }

    public void validate() {
        if (!this.needsRequestTag || this.haveRequestTag) {
            ListIterator<MultipleSyntaxElements> i = this.childContainers.listIterator();
            while (i.hasNext()) {
                MultipleSyntaxElements l = i.next();
                l.validate();
            }
            this.setValid(true);
        }
    }

    public void getElementPaths(Properties p, int[] segref, int[] degref, int[] deref) {
    }

    public void setParent(MultipleSyntaxElements parent) {
        this.parent = parent;
    }

    public MultipleSyntaxElements getParent() {
        return this.parent;
    }

    public int getPosInMsg() {
        return this.posInMsg;
    }

    protected void destroy() {
        this.childContainers.clear();
        this.childContainers = null;
        this.name = null;
        this.parent = null;
        this.path = null;
        this.type = null;
        this.syntax = null;
        this.def = null;
    }
}

