/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.protocol;

import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.kapott.hbci.exceptions.InvalidSegSeqException;
import org.kapott.hbci.exceptions.NoSuchPathException;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.protocol.MultipleDEGs;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SyntaxElement;
import org.kapott.hbci.protocol.factory.MultipleDEGsFactory;
import org.kapott.hbci.protocol.factory.MultipleDEsFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class SEG
extends SyntaxElement {
    @Override
    protected String getElementTypeName() {
        return "SEG";
    }

    @Override
    protected MultipleSyntaxElements createNewChildContainer(Node ref, Document syntax) {
        MultipleSyntaxElements ret = null;
        if (ref.getNodeName().equals("DE")) {
            ret = MultipleDEsFactory.getInstance().createMultipleDEs(ref, '+', this.getPath(), syntax);
        } else if (ref.getNodeName().equals("DEG")) {
            ret = MultipleDEGsFactory.getInstance().createMultipleDEGs(ref, '+', this.getPath(), syntax);
        }
        return ret;
    }

    public SEG(String type, String name, String path, int idx, Document syntax) {
        super(type, name, path, idx, syntax);
    }

    @Override
    public void init(String type, String name, String path, int idx, Document syntax) {
        super.init(type, name, path, idx, syntax);
    }

    @Override
    public String toString(int zero) {
        StringBuffer ret = new StringBuffer(256);
        boolean first = true;
        if (this.isValid()) {
            int tooMuch = 0;
            ListIterator<MultipleSyntaxElements> i = this.getChildContainers().listIterator();
            while (i.hasNext()) {
                if (!first) {
                    ret.append('+');
                }
                int saveLen = ret.length();
                MultipleSyntaxElements dataList = i.next();
                if (dataList != null) {
                    ret.append(dataList.toString(0));
                }
                tooMuch = ret.length() == saveLen && !first ? ++tooMuch : 0;
                first = false;
            }
            int retlen = ret.length();
            ret.delete(retlen - tooMuch, retlen);
            ret.append('\'');
        }
        return ret.toString();
    }

    public void log(int loglevel) {
        ListIterator<MultipleSyntaxElements> i = this.getChildContainers().listIterator();
        while (i.hasNext()) {
            MultipleSyntaxElements dataList = i.next();
            if (dataList == null) continue;
            dataList.log(loglevel);
        }
    }

    public void setSeq(int idx, boolean allowOverwrite) {
        String segcounterPath = "SegHead.seq";
        String targetPath = this.getPath() + "." + segcounterPath;
        if (!this.propagateValue(targetPath, Integer.toString(idx), false, allowOverwrite)) {
            throw new NoSuchPathException(targetPath);
        }
    }

    @Override
    public int enumerateSegs(int idx, boolean allowOverwrite) {
        if (idx == 0 || this.isValid()) {
            this.setSeq(idx, allowOverwrite);
            if (idx != 0) {
                ++idx;
            }
        }
        return idx;
    }

    public String getCode(MsgGen gen) {
        String codePath = "SegHead.code";
        SyntaxElement code = this.getElement(this.getPath() + "." + codePath);
        return code.toString();
    }

    @Override
    protected MultipleSyntaxElements parseNewChildContainer(Node dataref, char predelim0, char predelim1, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        MultipleSyntaxElements ret = null;
        if (dataref.getNodeName().equals("DEG")) {
            ret = MultipleDEGsFactory.getInstance().createMultipleDEGs(dataref, '+', this.getPath(), predelim0, predelim1, res, fullResLen, syntax, predefs, valids);
        } else if (dataref.getNodeName().equals("DE")) {
            ret = MultipleDEsFactory.getInstance().createMultipleDEs(dataref, '+', this.getPath(), predelim0, predelim1, res, fullResLen, syntax, predefs, valids);
        }
        return ret;
    }

    @Override
    protected char getInDelim() {
        return '+';
    }

    public SEG(String type, String name, String path, char predelim, int idx, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        super(type, name, path, predelim, idx, res, fullResLen, syntax, predefs, valids);
    }

    @Override
    public void init(String type, String name, String path, char predelim, int idx, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        super.init(type, name, path, predelim, idx, res, fullResLen, syntax, predefs, valids);
    }

    @Override
    public int checkSegSeq(int value) {
        int num = Integer.parseInt(this.getValueOfDE(this.getPath() + ".SegHead.seq"));
        if (num != value && !HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreSegSeqErrors", HBCIUtilsInternal.getLocMsg("EXCMSG_INVSEQNUM", new Object[]{this.getPath(), new Integer(value), new Integer(num)}))) {
            throw new InvalidSegSeqException(this.getPath(), value, num);
        }
        return value + 1;
    }

    @Override
    public void getElementPaths(Properties p, int[] segref, int[] degref, int[] deref) {
        if (this.isValid()) {
            p.setProperty(Integer.toString(segref[0]), this.getPath());
            degref = new int[]{1};
            for (MultipleSyntaxElements l : this.getChildContainers()) {
                if (l == null) continue;
                l.getElementPaths(p, segref, degref, null);
            }
            segref[0] = segref[0] + 1;
        }
    }

    @Override
    public void destroy() {
        List<MultipleSyntaxElements> childContainers = this.getChildContainers();
        for (MultipleSyntaxElements child : childContainers) {
            if (child instanceof MultipleDEGs) {
                MultipleDEGsFactory.getInstance().unuseObject(child);
                continue;
            }
            MultipleDEsFactory.getInstance().unuseObject(child);
        }
        super.destroy();
    }
}

