/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.protocol;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.protocol.DE;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SyntaxElement;
import org.kapott.hbci.protocol.factory.DEFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class MultipleDEs
extends MultipleSyntaxElements {
    private char delimiter;
    private List<String> valids;

    @Override
    protected SyntaxElement createAndAppendNewElement(Node deref, String path, int idx, Document syntax) {
        DE ret = null;
        ret = DEFactory.getInstance().createDE(deref, this.getName(), path, idx, syntax);
        this.addElement(ret);
        return ret;
    }

    private void initData(Node dedef, char delimiter, String path, Document syntax) {
        this.delimiter = delimiter;
        this.valids = new ArrayList<String>();
    }

    public MultipleDEs(Node dedef, char delimiter, String path, Document syntax) {
        super(dedef, path, syntax);
        this.initData(dedef, delimiter, path, syntax);
    }

    public void init(Node dedef, char delimiter, String path, Document syntax) {
        super.init(dedef, path, syntax);
        this.initData(dedef, delimiter, path, syntax);
    }

    @Override
    protected boolean storeValidValueInDE(String destPath, String value) {
        boolean ret = false;
        if (destPath.equals(this.getPath())) {
            this.valids.add(value);
            ret = true;
        }
        return ret;
    }

    @Override
    protected void validateOneElement(SyntaxElement elem, int idx) {
        ((DE)elem).setValids(this.valids);
        super.validateOneElement(elem, idx);
    }

    @Override
    public String toString(int zero) {
        StringBuffer ret = new StringBuffer(128);
        boolean first = true;
        ListIterator<SyntaxElement> i = this.getElements().listIterator();
        while (i.hasNext()) {
            if (!first) {
                ret.append(this.delimiter);
            }
            first = false;
            DE de = (DE)i.next();
            if (de == null) continue;
            ret.append(de.toString(0));
        }
        return ret.toString();
    }

    @Override
    public void log(int logLevel) {
        ListIterator<SyntaxElement> i = this.getElements().listIterator();
        while (i.hasNext()) {
            DE de = (DE)i.next();
            if (de == null) continue;
            HBCIUtils.log(de.toString(0), logLevel);
        }
    }

    @Override
    protected SyntaxElement parseAndAppendNewElement(Node ref, String path, char predelim, int idx, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        DE ret = null;
        if (idx != 0 && valids != null) {
            String header = this.getPath() + ".value";
            Enumeration<String> e = valids.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                if (!key.startsWith(header) || key.indexOf(".", header.length()) != -1) continue;
                int dotPos = key.lastIndexOf(46);
                String newkey = key.substring(0, dotPos) + HBCIUtilsInternal.withCounter("", idx) + key.substring(dotPos);
                valids.put(newkey, valids.get(key));
            }
        }
        ret = DEFactory.getInstance().createDE(ref, this.getName(), path, predelim, idx, res, fullResLen, syntax, predefs, valids);
        this.addElement(ret);
        return ret;
    }

    private void initData(Node deref, char delimiter, String path, char predelim0, char predelim1, StringBuffer res, int fullResLen, Document syntax, Hashtable<?, ?> predefs, Hashtable<?, ?> valids) {
        this.delimiter = delimiter;
        this.valids = new ArrayList<String>();
    }

    public MultipleDEs(Node deref, char delimiter, String path, char predelim0, char predelim1, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        super(deref, path, predelim0, predelim1, res, fullResLen, syntax, predefs, valids);
        this.initData(deref, delimiter, path, predelim0, predelim1, res, fullResLen, syntax, predefs, valids);
    }

    public void init(Node deref, char delimiter, String path, char predelim0, char predelim1, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        super.init(deref, path, predelim0, predelim1, res, fullResLen, syntax, predefs, valids);
        this.initData(deref, delimiter, path, predelim0, predelim1, res, fullResLen, syntax, predefs, valids);
    }

    @Override
    public void getElementPaths(Properties p, int[] segref, int[] degref, int[] deref) {
        if (this.getElements().size() != 0) {
            for (SyntaxElement e : this.getElements()) {
                if (e == null) continue;
                e.getElementPaths(p, segref, degref, deref);
            }
        } else if (deref == null) {
            p.setProperty(Integer.toString(segref[0]) + ":" + Integer.toString(degref[0]), this.getPath());
            degref[0] = degref[0] + 1;
        } else {
            p.setProperty(Integer.toString(segref[0]) + ":" + Integer.toString(degref[0]) + "," + Integer.toString(deref[0]), this.getPath());
            deref[0] = deref[0] + 1;
        }
    }

    @Override
    public void destroy() {
        List<SyntaxElement> children = this.getElements();
        Iterator<SyntaxElement> i = children.iterator();
        while (i.hasNext()) {
            DEFactory.getInstance().unuseObject(i.next());
        }
        this.valids.clear();
        this.valids = null;
        super.destroy();
    }
}

