/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport.rdhXfile;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.kapott.cryptalgs.PBKDF2;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidPassphraseException;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.rdhXfile.BankKeys;
import org.kapott.hbci.passport.rdhXfile.DateField;
import org.kapott.hbci.passport.rdhXfile.FileHeader;
import org.kapott.hbci.passport.rdhXfile.HBCIAccount;
import org.kapott.hbci.passport.rdhXfile.MACField;
import org.kapott.hbci.passport.rdhXfile.TLV;

public class RDHXFile {
    private List<TLV> fields = new ArrayList<TLV>();
    private byte[] passphrase;

    public RDHXFile(byte[] passphrase) {
        this.passphrase = passphrase;
    }

    public RDHXFile(byte[] data, byte[] passphrase) {
        this(passphrase);
        TLV tlv;
        int len = data.length;
        for (int posi = 0; posi < len; posi += 4 + tlv.getLength()) {
            tlv = new TLV(data, posi);
            long tag = tlv.getTag();
            if (tag == 20054L) {
                HBCIUtils.log("found diskhead field", 6);
                tlv = new FileHeader(tlv);
            } else if (tag == 22091L) {
                HBCIUtils.log("found hbciaccount field", 6);
                tlv = new HBCIAccount(tlv);
            } else if (tag == 21462L) {
                HBCIUtils.log("found bankkeys field", 6);
                tlv = new BankKeys(tlv);
            } else if (tag == 17490L) {
                HBCIUtils.log("found date field", 6);
                tlv = new DateField(tlv);
            } else if (tag == 19780L) {
                HBCIUtils.log("found mac field", 6);
                tlv = new MACField(tlv);
            } else {
                throw new HBCI_Exception("*** invalid field tag found: 0x" + Long.toString(tlv.getTag(), 16));
            }
            this.addField(tlv);
        }
        if (this.getField(FileHeader.class) == null) {
            throw new HBCI_Exception("*** RDH-2/10-file does not contain a header field - aborting");
        }
        MACField macfield = (MACField)this.getField(MACField.class);
        if (macfield != null) {
            byte[] storedMac = macfield.getMac();
            byte[] calculatedMac = this.calculateMAC();
            boolean macOK = Arrays.equals(storedMac, calculatedMac);
            HBCIUtils.log("MAC field ok: " + macOK, 4);
            if (!macOK) {
                throw new InvalidPassphraseException();
            }
        } else {
            HBCIUtils.log("RDH-2/10-file does not contain a MAC field - ignoring this for now", 1);
        }
        try {
            FileHeader fileHeader = (FileHeader)this.getField(FileHeader.class);
            String algname = fileHeader.getProfileVersion() == 2 ? "HmacSHA1" : "HmacSHA256";
            byte[] derivedKey = this.deriveKey(24, algname);
            SecretKeyFactory keyfac = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec desKeyspec = new DESedeKeySpec(derivedKey);
            SecretKey key = keyfac.generateSecret(desKeyspec);
            TLV[] accounts = this.getFields(HBCIAccount.class);
            for (int i = 0; i < accounts.length; ++i) {
                HBCIAccount account = (HBCIAccount)accounts[i];
                List<HBCIAccount.UserKeys> userkeys = account.getUserKeys();
                for (HBCIAccount.UserKeys userkey : userkeys) {
                    userkey.decrypt(key);
                    HBCIUtils.log(userkey.toString(), 6);
                }
            }
        }
        catch (Exception e) {
            throw new HBCI_Exception(e);
        }
    }

    public byte[] getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(byte[] passphrase) {
        this.passphrase = passphrase;
    }

    public void addField(TLV field) {
        this.fields.add(field);
    }

    public TLV getField(Class cl) {
        TLV ret = null;
        for (TLV tlv : this.fields) {
            if (!tlv.getClass().equals(cl)) continue;
            ret = tlv;
            break;
        }
        return ret;
    }

    public TLV[] getFields(Class cl) {
        ArrayList<TLV> ret = new ArrayList<TLV>();
        for (TLV tlv : this.fields) {
            if (!tlv.getClass().equals(cl)) continue;
            ret.add(tlv);
        }
        return ret.toArray(new TLV[ret.size()]);
    }

    public byte[] getFileData(int profileVersion) {
        DateField dateField = (DateField)this.getField(DateField.class);
        if (dateField == null) {
            dateField = new DateField();
            this.addField(dateField);
        }
        dateField.setDate(new Date());
        FileHeader headerField = (FileHeader)this.getField(FileHeader.class);
        if (headerField == null) {
            headerField = new FileHeader();
            this.addField(headerField);
            headerField.setNofIterations(10000);
            headerField.setRandomSalt();
            headerField.setVersion(1);
        }
        headerField.setProfileVersion(profileVersion);
        MACField macField = (MACField)this.getField(MACField.class);
        if (macField == null) {
            macField = new MACField();
            this.addField(macField);
        }
        try {
            FileHeader fileHeader = (FileHeader)this.getField(FileHeader.class);
            String algname = fileHeader.getProfileVersion() == 2 ? "HmacSHA1" : "HmacSHA256";
            byte[] derivedKey = this.deriveKey(24, algname);
            SecretKeyFactory keyfac = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec desKeyspec = new DESedeKeySpec(derivedKey);
            SecretKey key = keyfac.generateSecret(desKeyspec);
            TLV[] accounts = this.getFields(HBCIAccount.class);
            for (int i = 0; i < accounts.length; ++i) {
                HBCIAccount account = (HBCIAccount)accounts[i];
                List<HBCIAccount.UserKeys> userkeys = account.getUserKeys();
                for (HBCIAccount.UserKeys userkey : userkeys) {
                    userkey.encrypt(key);
                }
            }
        }
        catch (Exception e) {
            throw new HBCI_Exception(e);
        }
        ArrayList<TLV> newFields = new ArrayList<TLV>();
        Class[] order = new Class[]{FileHeader.class, HBCIAccount.class, BankKeys.class, DateField.class, MACField.class};
        for (int i = 0; i < order.length; ++i) {
            Class c = order[i];
            TLV[] fields = this.getFields(c);
            newFields.addAll(Arrays.asList(fields));
        }
        this.fields = newFields;
        for (TLV tlv : this.fields) {
            tlv.updateData();
        }
        byte[] mac = this.calculateMAC();
        MACField macfield = (MACField)this.getField(MACField.class);
        macfield.setMac(mac);
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            for (TLV tlv : this.fields) {
                os.write(tlv.getRawData());
            }
            byte[] ret = os.toByteArray();
            os.close();
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public HBCIKey getBankSigKey(HBCIAccount account) {
        return this.getBankKey(account, "S");
    }

    public void setBankSigKey(HBCIAccount account, HBCIKey key) {
        this.setBankKey(account, "S", key);
    }

    public HBCIKey getBankEncKey(HBCIAccount account) {
        return this.getBankKey(account, "V");
    }

    public void setBankEncKey(HBCIAccount account, HBCIKey key) {
        this.setBankKey(account, "V", key);
    }

    private HBCIKey getBankKey(HBCIAccount account, String keytype) {
        HBCIKey ret = null;
        String blz = account.getBLZ();
        String country = account.getCountry();
        TLV[] keyfields = this.getFields(BankKeys.class);
        for (int i = 0; i < keyfields.length; ++i) {
            BankKeys bankkeys = (BankKeys)keyfields[i];
            if (!bankkeys.getCountry().equals(country) || !bankkeys.getBLZ().equals(blz) || !bankkeys.getKeyType().equals(keytype)) continue;
            ret = bankkeys.getHBCIKey();
            break;
        }
        return ret;
    }

    private void setBankKey(HBCIAccount account, String keytype, HBCIKey key) {
        if (key != null) {
            String blz = account.getBLZ();
            String country = account.getCountry();
            TLV[] keyfields = this.getFields(BankKeys.class);
            boolean found = false;
            for (int i = 0; i < keyfields.length; ++i) {
                BankKeys bankkeys = (BankKeys)keyfields[i];
                if (!bankkeys.getCountry().equals(country) || !bankkeys.getBLZ().equals(blz) || !bankkeys.getKeyType().equals(keytype)) continue;
                bankkeys.setKey(keytype, key);
                account.setKeyStatus((byte)(account.getKeyStatus() | 4));
                found = true;
                break;
            }
            if (!found) {
                BankKeys bankkeys = new BankKeys();
                this.addField(bankkeys);
                bankkeys.setCountry(account.getCountry());
                bankkeys.setBLZ(account.getBLZ());
                bankkeys.setKey(keytype, key);
                account.setKeyStatus((byte)(account.getKeyStatus() | 4));
            }
        }
    }

    private byte[] getHashData() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            for (TLV tlv : this.fields) {
                if (tlv.getClass().equals(MACField.class)) continue;
                tlv.updateData();
                os.write(tlv.getRawData());
            }
            byte[] ret = os.toByteArray();
            os.close();
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] deriveKey(int dkLen, String algname) {
        FileHeader diskhead = (FileHeader)this.getField(FileHeader.class);
        HBCIUtils.log("calculating key with alg " + algname + " and length " + dkLen, 4);
        byte[] derivedKey = PBKDF2.deriveKey(diskhead.getSalt(), diskhead.getNofIterations(), this.getPassphrase(), dkLen, algname);
        return derivedKey;
    }

    private byte[] calculateMAC() {
        try {
            FileHeader header = (FileHeader)this.getField(FileHeader.class);
            int pversion = header.getProfileVersion();
            int keysize = pversion == 2 ? 20 : 32;
            HBCIUtils.log("using " + keysize + "-byte-key for MAC calculation", 4);
            String algname = pversion == 2 ? "HmacSHA1" : "HmacSHA256";
            HBCIUtils.log("MAC algorithm is " + algname, 4);
            byte[] derivedKey = this.deriveKey(keysize, algname);
            SecretKeySpec keyspec = new SecretKeySpec(derivedKey, algname);
            Mac mac = Mac.getInstance(algname);
            mac.init(keyspec);
            byte[] hashdata = this.getHashData();
            byte[] calculatedMac = mac.doFinal(hashdata);
            return calculatedMac;
        }
        catch (Exception e) {
            throw new HBCI_Exception(e);
        }
    }
}

