/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.protocol.MSG;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MsgGen {
    private Document syntax;
    private Hashtable<String, String> clientValues;

    public MsgGen(Document syntax) {
        this.syntax = syntax;
        this.clientValues = new Hashtable();
    }

    public MsgGen(InputStream syntaxFileStream) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setValidating(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.syntax = db.parse(syntaxFileStream);
            syntaxFileStream.close();
            this.clientValues = new Hashtable();
        }
        catch (FactoryConfigurationError e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_MSGGEN_DBFAC"), e);
        }
        catch (ParserConfigurationException e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_MSGGEN_DB"), e);
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_MSGGEN_STXFILE"), e);
        }
    }

    public MSG generate(String msgName) {
        return new MSG(msgName, this, this.clientValues);
    }

    public void set(String path, String value) {
        this.clientValues.put(path, value);
    }

    public void reset() {
        this.clientValues.clear();
    }

    public Document getSyntax() {
        return this.syntax;
    }

    public Hashtable<String, List<String>> getLowlevelGVs() {
        Hashtable<String, List<String>> result = new Hashtable<String, List<String>>();
        Element gvlist = this.syntax.getElementById("GV");
        NodeList gvs = gvlist.getChildNodes();
        int len = gvs.getLength();
        StringBuffer type = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            char ch;
            Node gvref = gvs.item(i);
            if (gvref.getNodeType() != 1) continue;
            type.setLength(0);
            type.append(((Element)gvref).getAttribute("type"));
            int pos = type.length() - 1;
            while ((ch = type.charAt(pos)) >= '0' && ch <= '9') {
                --pos;
            }
            String gvname = type.substring(0, pos + 1);
            List<String> entry = result.get(gvname);
            if (entry == null) {
                entry = new ArrayList<String>();
                result.put(gvname, entry);
            }
            entry.add(type.substring(pos + 1));
        }
        return result;
    }

    public List<String> getGVParameterNames(String specname) {
        char ch;
        int versionPos = specname.length() - 1;
        while ((ch = specname.charAt(versionPos)) >= '0' && ch <= '9') {
            --versionPos;
        }
        return this.getGVParameterNames(specname.substring(0, versionPos + 1), specname.substring(versionPos + 1));
    }

    public List<String> getGVParameterNames(String gvname, String version) {
        ArrayList<String> ret = new ArrayList<String>();
        Element gvdef = this.syntax.getElementById(gvname + version);
        NodeList gvcontent = gvdef.getChildNodes();
        int len = gvcontent.getLength();
        boolean first = true;
        for (int i = 0; i < len; ++i) {
            Node contentref = gvcontent.item(i);
            if (contentref.getNodeType() != 1) continue;
            if (first) {
                first = false;
                continue;
            }
            this.addLowlevelProperties(ret, "", (Element)contentref);
        }
        return ret;
    }

    public List<String> getGVResultNames(String specname) {
        char ch;
        int versionPos = specname.length() - 1;
        while ((ch = specname.charAt(versionPos)) >= '0' && ch <= '9') {
            --versionPos;
        }
        return this.getGVResultNames(specname.substring(0, versionPos + 1), specname.substring(versionPos + 1));
    }

    public List<String> getGVResultNames(String gvname, String version) {
        ArrayList<String> ret = new ArrayList<String>();
        Element gvdef = this.syntax.getElementById(gvname + "Res" + version);
        if (gvdef != null) {
            NodeList gvcontent = gvdef.getChildNodes();
            int len = gvcontent.getLength();
            boolean first = true;
            for (int i = 0; i < len; ++i) {
                Node contentref = gvcontent.item(i);
                if (contentref.getNodeType() != 1) continue;
                if (first) {
                    first = false;
                    continue;
                }
                this.addLowlevelProperties(ret, "", (Element)contentref);
            }
        }
        return ret;
    }

    public List<String> getGVRestrictionNames(String specname) {
        char ch;
        int versionPos = specname.length() - 1;
        while ((ch = specname.charAt(versionPos)) >= '0' && ch <= '9') {
            --versionPos;
        }
        return this.getGVRestrictionNames(specname.substring(0, versionPos + 1), specname.substring(versionPos + 1));
    }

    public List<String> getGVRestrictionNames(String gvname, String version) {
        ArrayList<String> ret = new ArrayList<String>();
        Element gvdef = this.syntax.getElementById(gvname + "Par" + version);
        if (gvdef != null) {
            NodeList gvcontent = gvdef.getChildNodes();
            int len = gvcontent.getLength();
            for (int i = 0; i < len; ++i) {
                String type;
                Node contentref = gvcontent.item(i);
                if (contentref.getNodeType() != 1 || !(type = ((Element)contentref).getAttribute("type")).startsWith("Par")) continue;
                gvdef = this.syntax.getElementById(type);
                gvcontent = gvdef.getChildNodes();
                len = gvcontent.getLength();
                for (i = 0; i < len; ++i) {
                    contentref = gvcontent.item(i);
                    if (contentref.getNodeType() != 1) continue;
                    this.addLowlevelProperties(ret, "", (Element)contentref);
                }
                break;
            }
        }
        return ret;
    }

    private void addLowlevelProperties(ArrayList<String> result, String path, Element ref) {
        if (ref.getAttribute("type").length() != 0) {
            if (ref.getNodeName().equals("DE")) {
                String name = ref.getAttribute("name");
                result.add(MsgGen.pathWithDot(path) + name);
            } else {
                String name = ref.getAttribute("name");
                if (name.length() == 0) {
                    name = ref.getAttribute("type");
                }
                Element def = this.syntax.getElementById(ref.getAttribute("type"));
                NodeList defcontent = def.getChildNodes();
                int len = defcontent.getLength();
                for (int i = 0; i < len; ++i) {
                    Node content = defcontent.item(i);
                    if (content.getNodeType() != 1) continue;
                    this.addLowlevelProperties(result, MsgGen.pathWithDot(path) + name, (Element)content);
                }
            }
        }
    }

    private static String pathWithDot(String path) {
        return path.length() == 0 ? path : path + ".";
    }

    public String get(String key) {
        return this.clientValues.get(key);
    }
}

