/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.datatypes.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.kapott.hbci.datatypes.SyntaxDE;
import org.kapott.hbci.exceptions.InitializingException;
import org.kapott.hbci.exceptions.NoSuchConstructorException;
import org.kapott.hbci.exceptions.NoSuchSyntaxException;
import org.kapott.hbci.exceptions.ParseErrorException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.tools.ObjectFactory;

public class SyntaxDEFactory {
    private static SyntaxDEFactory instance;

    public static SyntaxDEFactory getInstance() {
        if (instance == null) {
            instance = new SyntaxDEFactory();
        }
        return instance;
    }

    private SyntaxDEFactory() {
    }

    public SyntaxDE createSyntaxDE(String dataType, String path, String value, int minsize, int maxsize) {
        SyntaxDE ret = null;
        ObjectFactory factory = new ObjectFactory(Integer.parseInt(HBCIUtils.getParam("kernel.objpool.Syntax", "1024")));
        ret = (SyntaxDE)factory.getFreeObject();
        if (ret == null) {
            Constructor<?> con;
            Class<?> c;
            try {
                c = Class.forName("org.kapott.hbci.datatypes.Syntax" + dataType, false, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new NoSuchSyntaxException(dataType, path);
            }
            try {
                con = c.getConstructor(String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchConstructorException(dataType);
            }
            try {
                ret = (SyntaxDE)con.newInstance(value, new Integer(minsize), new Integer(maxsize));
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                throw new InitializingException((Exception)e.getCause(), path);
            }
            if (ret != null) {
                factory.addToUsedPool(ret);
            }
        } else {
            try {
                ret.init(value, minsize, maxsize);
                factory.addToUsedPool(ret);
            }
            catch (RuntimeException e) {
                factory.addToFreePool(ret);
                throw new InitializingException(e, path);
            }
        }
        return ret;
    }

    public SyntaxDE createSyntaxDE(String dataType, String path, StringBuffer res, int minsize, int maxsize) {
        SyntaxDE ret = null;
        ObjectFactory factory = new ObjectFactory(Integer.parseInt(HBCIUtils.getParam("kernel.objpool.Syntax", "1024")));
        ret = (SyntaxDE)factory.getFreeObject();
        if (ret == null) {
            Constructor<?> con;
            Class<?> c;
            try {
                c = Class.forName("org.kapott.hbci.datatypes.Syntax" + dataType, false, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new NoSuchSyntaxException(dataType, path);
            }
            try {
                con = c.getConstructor(StringBuffer.class, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchConstructorException(dataType);
            }
            try {
                ret = (SyntaxDE)con.newInstance(res, new Integer(minsize), new Integer(maxsize));
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                throw new ParseErrorException(HBCIUtilsInternal.getLocMsg("EXCMSG_PROT_ERRSYNDE", path), (Exception)e.getCause());
            }
            if (ret != null) {
                factory.addToUsedPool(ret);
            }
        } else {
            try {
                ret.init(res, minsize, maxsize);
                factory.addToUsedPool(ret);
            }
            catch (RuntimeException e) {
                factory.addToFreePool(ret);
                throw new ParseErrorException(HBCIUtilsInternal.getLocMsg("EXCMSG_PROT_ERRSYNDE", path), (Exception)e.getCause());
            }
        }
        return ret;
    }

    public void unuseObject(SyntaxDE sde, String type) {
    }
}

