/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.callback;

import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.Date;
import java.util.StringTokenizer;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.callback.AbstractHBCICallback;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.LogFilter;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.INILetter;
import org.kapott.hbci.status.HBCIMsgStatus;

public class HBCICallbackIOStreams
extends AbstractHBCICallback {
    private PrintStream outStream;
    private BufferedReader inStream;

    public HBCICallbackIOStreams(PrintStream outStream, BufferedReader inStream) {
        this.outStream = outStream;
        this.inStream = inStream;
    }

    protected void setInStream(BufferedReader in) {
        this.inStream = in;
    }

    protected BufferedReader getInStream() {
        return this.inStream;
    }

    protected void setOutStream(PrintStream out) {
        this.outStream = out;
    }

    protected PrintStream getOutStream() {
        return this.outStream;
    }

    @Override
    public void log(String msg, int level, Date date, StackTraceElement trace) {
        String line = this.createDefaultLogLine(msg, level, date, trace);
        this.getOutStream().println(line);
    }

    @Override
    public void callback(HBCIPassport passport, int reason, String msg, int datatype, StringBuffer retData) {
        try {
            LogFilter logfilter = LogFilter.getInstance();
            switch (reason) {
                case 21: 
                case 22: {
                    this.getOutStream().print(msg + ": ");
                    this.getOutStream().flush();
                    String st = this.getInStream().readLine();
                    if (reason == 22) {
                        this.getOutStream().print(msg + " (again): ");
                        this.getOutStream().flush();
                        String st2 = this.getInStream().readLine();
                        if (!st.equals(st2)) {
                            throw new InvalidUserDataException(HBCIUtilsInternal.getLocMsg("EXCMSG_PWDONTMATCH"));
                        }
                    }
                    logfilter.addSecretData(st, "X", 1);
                    retData.replace(0, retData.length(), st);
                    break;
                }
                case 2: {
                    this.getOutStream().println(msg);
                    break;
                }
                case 3: {
                    this.getOutStream().println(msg);
                    break;
                }
                case 4: 
                case 16: 
                case 17: 
                case 29: 
                case 33: {
                    this.getOutStream().print(msg + ": ");
                    this.getOutStream().flush();
                    String secret = this.getInStream().readLine();
                    logfilter.addSecretData(secret, "X", 1);
                    retData.replace(0, retData.length(), secret);
                    break;
                }
                case 5: {
                    HBCIUtils.log("end of entering hardpin", 4);
                    break;
                }
                case 6: {
                    HBCIUtils.log("end of waiting for chipcard", 4);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 18: 
                case 26: 
                case 28: {
                    this.getOutStream().print(msg + " [" + retData.toString() + "]: ");
                    this.getOutStream().flush();
                    String st = this.getInStream().readLine();
                    if (st.length() == 0) {
                        st = retData.toString();
                    }
                    if (reason == 8) {
                        logfilter.addSecretData(st, "X", 3);
                    } else if (reason == 11 || reason == 18 || reason == 28) {
                        logfilter.addSecretData(st, "X", 2);
                    }
                    retData.replace(0, retData.length(), st);
                    break;
                }
                case 12: {
                    this.getOutStream().println(msg);
                    INILetter iniletter = new INILetter(passport, 1);
                    this.getOutStream().println(HBCIUtilsInternal.getLocMsg("EXPONENT") + ": " + HBCIUtils.data2hex(iniletter.getKeyExponentDisplay()));
                    this.getOutStream().println(HBCIUtilsInternal.getLocMsg("MODULUS") + ": " + HBCIUtils.data2hex(iniletter.getKeyModulusDisplay()));
                    this.getOutStream().print("<ENTER>=OK, \"ERR\"=ERROR: ");
                    this.getOutStream().flush();
                    retData.replace(0, retData.length(), this.getInStream().readLine());
                    break;
                }
                case 13: {
                    INILetter iniletter = new INILetter(passport, 2);
                    Date date = new Date();
                    this.getOutStream().println(HBCIUtilsInternal.getLocMsg("DATE") + ": " + HBCIUtils.date2StringLocal(date));
                    this.getOutStream().println(HBCIUtilsInternal.getLocMsg("TIME") + ": " + HBCIUtils.time2StringLocal(date));
                    this.getOutStream().println(HBCIUtilsInternal.getLocMsg("BLZ") + ": " + passport.getBLZ());
                    this.getOutStream().println(HBCIUtilsInternal.getLocMsg("USERID") + ": " + passport.getUserId());
                    this.getOutStream().println(HBCIUtilsInternal.getLocMsg("KEYNUM") + ": " + passport.getMyPublicSigKey().num);
                    this.getOutStream().println(HBCIUtilsInternal.getLocMsg("KEYVERSION") + ": " + passport.getMyPublicSigKey().version);
                    this.getOutStream().println(HBCIUtilsInternal.getLocMsg("EXPONENT") + ": " + HBCIUtils.data2hex(iniletter.getKeyExponentDisplay()));
                    this.getOutStream().println(HBCIUtilsInternal.getLocMsg("MODULUS") + ": " + HBCIUtils.data2hex(iniletter.getKeyModulusDisplay()));
                    this.getOutStream().println(msg);
                    break;
                }
                case 14: {
                    this.getOutStream().println(msg);
                    this.getOutStream().println(HBCIUtilsInternal.getLocMsg("CONTINUE"));
                    this.getOutStream().flush();
                    this.getInStream().readLine();
                    break;
                }
                case 15: {
                    this.getOutStream().println(msg);
                    break;
                }
                case 19: {
                    this.getOutStream().println(msg);
                    int idx = retData.indexOf("|");
                    String blz = retData.substring(0, idx);
                    String number = retData.substring(idx + 1);
                    this.getOutStream().print(HBCIUtilsInternal.getLocMsg("BLZ") + " [" + blz + "]: ");
                    this.getOutStream().flush();
                    String s = this.getInStream().readLine();
                    if (s.length() == 0) {
                        s = blz;
                    }
                    blz = s;
                    this.getOutStream().print(HBCIUtilsInternal.getLocMsg("ACCNUMBER") + " [" + number + "]: ");
                    this.getOutStream().flush();
                    s = this.getInStream().readLine();
                    if (s.length() == 0) {
                        s = number;
                    }
                    number = s;
                    logfilter.addSecretData(blz, "X", 3);
                    logfilter.addSecretData(number, "X", 2);
                    retData.replace(0, retData.length(), blz + "|" + number);
                    break;
                }
                case 30: {
                    this.getOutStream().println(msg);
                    String iban = retData.toString();
                    this.getOutStream().print(HBCIUtilsInternal.getLocMsg("IBAN") + " [" + iban + "]: ");
                    this.getOutStream().flush();
                    String newiban = this.getInStream().readLine();
                    if (newiban.length() != 0 && !newiban.equals(iban)) {
                        retData.replace(0, retData.length(), newiban);
                        logfilter.addSecretData(newiban, "X", 2);
                    }
                    break;
                }
                case 20: {
                    this.getOutStream().println(msg);
                    this.getOutStream().print("<ENTER>=OK, \"ERR\"=ERROR: ");
                    this.getOutStream().flush();
                    retData.replace(0, retData.length(), this.getInStream().readLine());
                    break;
                }
                case 23: {
                    StringTokenizer tok = new StringTokenizer(retData.toString(), "|");
                    while (tok.hasMoreTokens()) {
                        String entry = tok.nextToken();
                        StringTokenizer tok2 = new StringTokenizer(entry, ";");
                        String tempblz = tok2.nextToken();
                        this.getOutStream().println(tok2.nextToken() + ": " + HBCIUtilsInternal.getLocMsg("BLZ") + "=" + tempblz + " (" + HBCIUtils.getNameForBLZ(tempblz) + ") " + HBCIUtilsInternal.getLocMsg("USERID") + "=" + tok2.nextToken());
                    }
                    this.getOutStream().print(HBCIUtilsInternal.getLocMsg("CALLB_SELECT_ENTRY") + ": ");
                    this.getOutStream().flush();
                    retData.replace(0, retData.length(), this.getInStream().readLine());
                    break;
                }
                case 27: {
                    for (String entry : retData.toString().split("\\|")) {
                        String[] values = entry.split(":");
                        this.getOutStream().println(values[0] + ": " + values[1]);
                    }
                    this.getOutStream().print(HBCIUtilsInternal.getLocMsg("CALLB_SELECT_ENTRY") + ": ");
                    this.getOutStream().flush();
                    retData.replace(0, retData.length(), this.getInStream().readLine());
                    break;
                }
                case 32: {
                    String[] medias;
                    String medialist = retData.toString();
                    if (medialist.length() > 0 && !medialist.contains("|")) {
                        retData.replace(0, retData.length(), medialist);
                        break;
                    }
                    for (String media : medias = medialist.split("\\|")) {
                        this.getOutStream().println(media);
                    }
                    this.getOutStream().print(HBCIUtilsInternal.getLocMsg("CALLB_SELECT_ENTRY") + ": ");
                    this.getOutStream().flush();
                    retData.replace(0, retData.length(), this.getInStream().readLine());
                    break;
                }
                case 31: {
                    this.getOutStream().println(msg);
                    this.getOutStream().println(retData);
                    this.getOutStream().print("Press <RETURN> to send this data; enter \"NO\" to NOT send this data: ");
                    this.getOutStream().flush();
                    retData.replace(0, retData.length(), this.getInStream().readLine());
                    break;
                }
                case 24: 
                case 25: {
                    this.getOutStream().println(msg);
                    this.getOutStream().println(HBCIUtilsInternal.getLocMsg("CONTINUE"));
                    this.getOutStream().flush();
                    this.getInStream().readLine();
                    break;
                }
                case 41: {
                    this.getOutStream().println(msg);
                    break;
                }
                default: {
                    throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CALLB_UNKNOWN", Integer.toString(reason)));
                }
            }
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CALLB_ERR"), e);
        }
    }

    @Override
    public boolean tanCallback(HBCIPassport passport, GVTAN2Step hktan) {
        return false;
    }

    @Override
    public void status(HBCIPassport passport, int statusTag, Object[] o) {
        switch (statusTag) {
            case 3: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_REC_INST_DATA"));
                break;
            }
            case 4: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_REC_INST_DATA_DONE", passport.getBPDVersion()));
                break;
            }
            case 5: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_REC_INST_KEYS"));
                break;
            }
            case 6: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_REC_INST_KEYS_DONE"));
                break;
            }
            case 7: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_SEND_MY_KEYS"));
                break;
            }
            case 8: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_SEND_MY_KEYS_DONE"));
                this.getOutStream().println("status: " + ((HBCIMsgStatus)o[0]).toString());
                break;
            }
            case 9: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_REC_SYSID"));
                break;
            }
            case 10: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_REC_SYSID_DONE", o[1].toString()));
                this.getOutStream().println("status: " + ((HBCIMsgStatus)o[0]).toString());
                break;
            }
            case 15: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_REC_SIGID"));
                break;
            }
            case 16: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_REC_SIGID_DONE", o[1].toString()));
                this.getOutStream().println("status: " + ((HBCIMsgStatus)o[0]).toString());
                break;
            }
            case 11: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_REC_USER_DATA"));
                break;
            }
            case 12: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_REC_USER_DATA_DONE", passport.getUPDVersion()));
                break;
            }
            case 13: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_USR_LOCK"));
                break;
            }
            case 14: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_USR_LOCK_DONE"));
                this.getOutStream().println("status: " + ((HBCIMsgStatus)o[0]).toString());
                break;
            }
            case 17: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_DIALOG_INIT"));
                break;
            }
            case 18: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_DIALOG_INIT_DONE", o[1]));
                this.getOutStream().println("status: " + ((HBCIMsgStatus)o[0]).toString());
                break;
            }
            case 1: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_DIALOG_NEW_JOB", ((HBCIJob)o[0]).getName()));
                break;
            }
            case 2: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_DIALOG_JOB_DONE", ((HBCIJob)o[0]).getName()));
                break;
            }
            case 19: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_DIALOG_END"));
                break;
            }
            case 20: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_DIALOG_END_DONE"));
                this.getOutStream().println("status: " + ((HBCIMsgStatus)o[0]).toString());
                break;
            }
            case 21: {
                this.getOutStream().println("  " + HBCIUtilsInternal.getLocMsg("STATUS_MSG_CREATE", o[0].toString()));
                break;
            }
            case 22: {
                this.getOutStream().println("  " + HBCIUtilsInternal.getLocMsg("STATUS_MSG_SIGN"));
                break;
            }
            case 23: {
                this.getOutStream().println("  " + HBCIUtilsInternal.getLocMsg("STATUS_MSG_CRYPT"));
                break;
            }
            case 24: {
                this.getOutStream().println("  " + HBCIUtilsInternal.getLocMsg("STATUS_MSG_SEND"));
                break;
            }
            case 27: {
                this.getOutStream().println("  " + HBCIUtilsInternal.getLocMsg("STATUS_MSG_RECV"));
                break;
            }
            case 28: {
                this.getOutStream().println("  " + HBCIUtilsInternal.getLocMsg("STATUS_MSG_PARSE", o[0].toString() + ")"));
                break;
            }
            case 25: {
                this.getOutStream().println("  " + HBCIUtilsInternal.getLocMsg("STATUS_MSG_DECRYPT"));
                break;
            }
            case 26: {
                this.getOutStream().println("  " + HBCIUtilsInternal.getLocMsg("STATUS_MSG_VERIFY"));
                break;
            }
            case 29: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_SEND_INFOPOINT_DATA"));
                break;
            }
            case 30: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_MSG_RAW_SEND", o[0].toString()));
                break;
            }
            case 31: {
                this.getOutStream().println(HBCIUtilsInternal.getLocMsg("STATUS_MSG_RAW_RECV", o[0].toString()));
                break;
            }
            default: {
                throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("STATUS_INVALID", Integer.toString(statusTag)));
            }
        }
    }
}

