/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.parsers;

import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXB;
import javax.xml.datatype.XMLGregorianCalendar;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.parsers.AbstractSepaParser;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.sepa.jaxb.pain_008_001_01.DirectDebitTransactionInformation2;
import org.kapott.hbci.sepa.jaxb.pain_008_001_01.Document;
import org.kapott.hbci.sepa.jaxb.pain_008_001_01.EuroMax9Amount;
import org.kapott.hbci.sepa.jaxb.pain_008_001_01.Pain00800101;
import org.kapott.hbci.sepa.jaxb.pain_008_001_01.PaymentInstructionInformation5;

public class ParsePain00800101
extends AbstractSepaParser {
    @Override
    public void parse(InputStream xml, List<Properties> sepaResults) {
        Document doc = (Document)JAXB.unmarshal((InputStream)xml, Document.class);
        Pain00800101 pain = doc.getPain00800101();
        PaymentInstructionInformation5 pmtInf = pain.getPmtInf();
        List<DirectDebitTransactionInformation2> txList = pmtInf.getDrctDbtTxInf();
        for (DirectDebitTransactionInformation2 tx : txList) {
            XMLGregorianCalendar date;
            Properties prop = new Properties();
            this.put(prop, ISEPAParser.Names.PMTINFID, pmtInf.getPmtInfId());
            this.put(prop, ISEPAParser.Names.SRC_NAME, pain.getGrpHdr().getInitgPty().getNm());
            this.put(prop, ISEPAParser.Names.SRC_IBAN, pmtInf.getCdtrAcct().getId().getIBAN());
            this.put(prop, ISEPAParser.Names.SRC_BIC, pmtInf.getCdtrAgt().getFinInstnId().getBIC());
            this.put(prop, ISEPAParser.Names.DST_NAME, tx.getDbtr().getNm());
            this.put(prop, ISEPAParser.Names.DST_IBAN, tx.getDbtrAcct().getId().getIBAN());
            this.put(prop, ISEPAParser.Names.DST_BIC, tx.getDbtrAgt().getFinInstnId().getBIC());
            EuroMax9Amount amt = tx.getInstdAmt();
            this.put(prop, ISEPAParser.Names.VALUE, SepaUtil.format(amt.getValue()));
            this.put(prop, ISEPAParser.Names.CURR, amt.getCcy());
            if (tx.getRmtInf() != null) {
                this.put(prop, ISEPAParser.Names.USAGE, tx.getRmtInf().getUstrd());
            }
            if ((date = pmtInf.getReqdColltnDt()) != null) {
                this.put(prop, ISEPAParser.Names.TARGETDATE, SepaUtil.format(date, null));
            }
            this.put(prop, ISEPAParser.Names.ENDTOENDID, tx.getPmtId().getEndToEndId());
            this.put(prop, ISEPAParser.Names.CREDITORID, tx.getDrctDbtTx().getCdtrSchmeId().getId().getPrvtId().getOthrId().getId());
            this.put(prop, ISEPAParser.Names.MANDATEID, tx.getDrctDbtTx().getMndtRltdInf().getMndtId());
            XMLGregorianCalendar mandDate = tx.getDrctDbtTx().getMndtRltdInf().getDtOfSgntr();
            if (mandDate != null) {
                this.put(prop, ISEPAParser.Names.MANDDATEOFSIG, SepaUtil.format(mandDate, null));
            }
            this.put(prop, ISEPAParser.Names.SEQUENCETYPE, pmtInf.getPmtTpInf().getSeqTp().value());
            sepaResults.add(prop);
        }
    }
}

