/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.parsers;

import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXB;
import javax.xml.datatype.XMLGregorianCalendar;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.parsers.AbstractSepaParser;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.CreditTransferTransactionInformation2;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.Document;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.EuroMax9Amount;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.Pain00100102;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.PaymentIdentification1;
import org.kapott.hbci.sepa.jaxb.pain_001_001_02.PaymentInstructionInformation4;

public class ParsePain00100102
extends AbstractSepaParser {
    @Override
    public void parse(InputStream xml, List<Properties> sepaResults) {
        Document doc = (Document)JAXB.unmarshal((InputStream)xml, Document.class);
        Pain00100102 pain = doc.getPain00100102();
        if (pain == null) {
            return;
        }
        PaymentInstructionInformation4 pmtInf = pain.getPmtInf();
        List<CreditTransferTransactionInformation2> txList = pmtInf.getCdtTrfTxInf();
        for (CreditTransferTransactionInformation2 tx : txList) {
            PaymentIdentification1 pmtId;
            XMLGregorianCalendar date;
            Properties prop = new Properties();
            this.put(prop, ISEPAParser.Names.PMTINFID, pmtInf.getPmtInfId());
            this.put(prop, ISEPAParser.Names.SRC_NAME, pain.getGrpHdr().getInitgPty().getNm());
            this.put(prop, ISEPAParser.Names.SRC_IBAN, pmtInf.getDbtrAcct().getId().getIBAN());
            this.put(prop, ISEPAParser.Names.SRC_BIC, pmtInf.getDbtrAgt().getFinInstnId().getBIC());
            this.put(prop, ISEPAParser.Names.DST_NAME, tx.getCdtr().getNm());
            this.put(prop, ISEPAParser.Names.DST_IBAN, tx.getCdtrAcct().getId().getIBAN());
            this.put(prop, ISEPAParser.Names.DST_BIC, tx.getCdtrAgt().getFinInstnId().getBIC());
            EuroMax9Amount amt = tx.getAmt().getInstdAmt();
            this.put(prop, ISEPAParser.Names.VALUE, SepaUtil.format(amt.getValue()));
            this.put(prop, ISEPAParser.Names.CURR, amt.getCcy());
            if (tx.getRmtInf() != null) {
                this.put(prop, ISEPAParser.Names.USAGE, tx.getRmtInf().getUstrd());
            }
            if ((date = pmtInf.getReqdExctnDt()) != null) {
                this.put(prop, ISEPAParser.Names.DATE, SepaUtil.format(date, null));
            }
            if ((pmtId = tx.getPmtId()) != null) {
                this.put(prop, ISEPAParser.Names.ENDTOENDID, pmtId.getEndToEndId());
            }
            sepaResults.add(prop);
        }
    }
}

