/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.generators;

import java.util.logging.Logger;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.GV.generators.ISEPAGenerator;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.sepa.PainVersion;

public class SEPAGeneratorFactory {
    private static final Logger LOG = Logger.getLogger(SEPAGeneratorFactory.class.getName());

    public static ISEPAGenerator get(HBCIJob job, PainVersion version) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String jobname = ((AbstractSEPAGV)job).getPainJobName();
        return SEPAGeneratorFactory.get(jobname, version);
    }

    public static ISEPAGenerator get(String jobname, PainVersion version) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!version.isSupported(jobname)) {
            throw new InvalidUserDataException("PAIN version is not supported: " + version);
        }
        String className = version.getGeneratorClass(jobname);
        LOG.fine("trying to init SEPA creator: " + className);
        Class<?> cl = Class.forName(className);
        return (ISEPAGenerator)cl.newInstance();
    }
}

