/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtilsInternal;

public class GVUeb
extends HBCIJobImpl {
    public static String getLowlevelName() {
        return "Ueb";
    }

    public GVUeb(HBCIHandler handler, String name) {
        super(handler, name, new HBCIJobResultImpl());
    }

    public GVUeb(HBCIHandler handler) {
        this(handler, GVUeb.getLowlevelName());
        this.addConstraint("src.country", "My.KIK.country", "DE", 0);
        this.addConstraint("src.blz", "My.KIK.blz", null, 3);
        this.addConstraint("src.number", "My.number", null, 2);
        this.addConstraint("src.subnumber", "My.subnumber", "", 3);
        this.addConstraint("dst.country", "Other.KIK.country", "DE", 0);
        this.addConstraint("dst.blz", "Other.KIK.blz", null, 3);
        this.addConstraint("dst.number", "Other.number", null, 2);
        this.addConstraint("dst.subnumber", "Other.subnumber", "", 3);
        this.addConstraint("btg.value", "BTG.value", null, 3);
        this.addConstraint("btg.curr", "BTG.curr", null, 0);
        this.addConstraint("name", "name", null, 2);
        this.addConstraint("name2", "name2", "", 2);
        this.addConstraint("key", "key", "51", 0);
        Properties parameters = this.getJobRestrictions();
        int maxusage = Integer.parseInt(parameters.getProperty("maxusage"));
        for (int i = 0; i < maxusage; ++i) {
            String name = HBCIUtilsInternal.withCounter("usage", i);
            this.addConstraint(name, "usage." + name, "", 3);
        }
    }

    @Override
    public void setParam(String paramName, String value) {
        Properties res = this.getJobRestrictions();
        if (paramName.equals("key")) {
            String st;
            boolean atLeastOne = false;
            boolean found = false;
            int i = 0;
            while ((st = res.getProperty(HBCIUtilsInternal.withCounter("key", i))) != null) {
                atLeastOne = true;
                if (st.equals(value)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (atLeastOne && !found) {
                String msg = HBCIUtilsInternal.getLocMsg("EXCMSG_INV_KEY", value);
                if (!HBCIUtilsInternal.ignoreError(this.getMainPassport(), "client.errors.ignoreWrongJobDataErrors", msg)) {
                    throw new InvalidUserDataException(msg);
                }
            }
        }
        super.setParam(paramName, value);
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("src");
        this.checkAccountCRC("dst");
    }
}

