/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIMsgStatus;

public class GVTAN2Step
extends HBCIJobImpl {
    private GVTAN2Step otherTAN2StepTask;
    private HBCIJobImpl origTask;

    public static String getLowlevelName() {
        return "TAN2Step";
    }

    public GVTAN2Step(HBCIHandler handler) {
        super(handler, GVTAN2Step.getLowlevelName(), new GVRSaldoReq());
        this.addConstraint("process", "process", null, 0);
        this.addConstraint("orderhash", "orderhash", "", 0);
        this.addConstraint("orderref", "orderref", "", 0);
        this.addConstraint("listidx", "listidx", "", 0);
        this.addConstraint("notlasttan", "notlasttan", "N", 0);
        this.addConstraint("info", "info", "", 0);
        this.addConstraint("storno", "storno", "", 0);
        this.addConstraint("challengeklass", "challengeklass", "", 0);
        this.addConstraint("ChallengeKlassParam1", "ChallengeKlassParams.param1", "", 2);
        this.addConstraint("ChallengeKlassParam2", "ChallengeKlassParams.param2", "", 2);
        this.addConstraint("ChallengeKlassParam3", "ChallengeKlassParams.param3", "", 2);
        this.addConstraint("ChallengeKlassParam4", "ChallengeKlassParams.param4", "", 2);
        this.addConstraint("ChallengeKlassParam5", "ChallengeKlassParams.param5", "", 2);
        this.addConstraint("ChallengeKlassParam6", "ChallengeKlassParams.param6", "", 2);
        this.addConstraint("ChallengeKlassParam7", "ChallengeKlassParams.param7", "", 2);
        this.addConstraint("ChallengeKlassParam8", "ChallengeKlassParams.param8", "", 2);
        this.addConstraint("ChallengeKlassParam9", "ChallengeKlassParams.param9", "", 2);
        this.addConstraint("tanmedia", "tanmedia", "", 2);
        this.addConstraint("ordersegcode", "ordersegcode", "", 0);
        this.addConstraint("orderaccount.bic", "OrderAccount.bic", null, 3);
        this.addConstraint("orderaccount.iban", "OrderAccount.iban", null, 2);
        this.addConstraint("orderaccount.number", "OrderAccount.number", null, 2);
        this.addConstraint("orderaccount.subnumber", "OrderAccount.subnumber", "", 3);
        this.addConstraint("orderaccount.blz", "OrderAccount.KIK.blz", null, 3);
        this.addConstraint("orderaccount.country", "OrderAccount.KIK.country", "DE", 0);
    }

    @Override
    public void setParam(String paramName, String value) {
        if (paramName.equals("orderhash")) {
            value = "B" + value;
        }
        super.setParam(paramName, value);
    }

    public void storeOtherTAN2StepTask(GVTAN2Step other) {
        this.otherTAN2StepTask = other;
    }

    public void storeOriginalTask(HBCIJobImpl task) {
        this.origTask = task;
    }

    @Override
    protected void saveReturnValues(HBCIMsgStatus status, int sref) {
        super.saveReturnValues(status, sref);
        if (this.origTask != null) {
            int orig_segnum = Integer.parseInt(this.origTask.getJobResult().getSegNum());
            HBCIUtils.log("storing return values in orig task (segnum=" + orig_segnum + ")", 4);
            this.origTask.saveReturnValues(status, orig_segnum);
        }
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        String segcode = result.getProperty(header + ".SegHead.code");
        HBCIUtils.log("found HKTAN response with segcode " + segcode, 4);
        if (this.origTask != null && new StringBuffer(this.origTask.getHBCICode()).replace(1, 2, "I").toString().equals(segcode)) {
            HBCIUtils.log("this is a response segment for the original task - storing results in the original job", 4);
            this.origTask.extractResults(msgstatus, header, idx);
        } else {
            String orderref;
            String hhdUc;
            HBCIUtils.log("this is a \"real\" HKTAN response - analyzing HITAN data", 4);
            String challenge = result.getProperty(header + ".challenge");
            if (challenge != null) {
                HBCIUtils.log("found challenge '" + challenge + "' in HITAN - saving it temporarily in passport", 4);
                this.getMainPassport().setPersistentData("pintan_challenge", challenge);
                this.getMainPassport().setPersistentData("externalid", this.getExternalId());
            }
            if ((hhdUc = result.getProperty(header + ".challenge_hhd_uc")) != null) {
                HBCIUtils.log("found Challenge HHDuc '" + hhdUc + "' in HITAN - saving it temporarily in passport", 4);
                this.getMainPassport().setPersistentData("pintan_challenge_hhd_uc", hhdUc);
            }
            if ((orderref = result.getProperty(header + ".orderref")) != null) {
                HBCIUtils.log("found orderref '" + orderref + "' in HITAN", 4);
                if (this.otherTAN2StepTask != null) {
                    HBCIUtils.log("storing it in following HKTAN task", 4);
                    this.otherTAN2StepTask.setParam("orderref", orderref);
                } else {
                    HBCIUtils.log("no other HKTAN task known - ignoring orderref", 4);
                }
            }
            this.getMainPassport().getCallback().tanCallback(this.getMainPassport(), this.otherTAN2StepTask);
        }
    }
}

