/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRStatus;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.status.HBCIRetVal;

public final class GVStatus
extends HBCIJobImpl {
    public static String getLowlevelName() {
        return "Status";
    }

    public GVStatus(HBCIHandler handler) {
        super(handler, GVStatus.getLowlevelName(), new GVRStatus());
        this.addConstraint("startdate", "startdate", "", 0);
        this.addConstraint("enddate", "enddate", "", 0);
        this.addConstraint("maxentries", "maxentries", "", 0);
        this.addConstraint("jobid", null, "", 0);
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        GVRStatus.Entry entry = new GVRStatus.Entry();
        entry.dialogid = result.getProperty(header + ".MsgRef.dialogid");
        entry.msgnum = result.getProperty(header + ".MsgRef.msgnum");
        entry.retval = new HBCIRetVal(result, header + ".RetVal", result.getProperty(header + ".segref"));
        entry.retval.element = null;
        String date = result.getProperty(header + ".date");
        String time = result.getProperty(header + ".time");
        entry.timestamp = HBCIUtils.strings2DateTimeISO(date, time);
        ((GVRStatus)this.jobResult).addEntry(entry);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setParam(String paramName, String value) {
        if (paramName.equals("jobid")) {
            try {
                Date dateOfJob = new SimpleDateFormat("yyyyMMdd").parse(value.substring(0, value.indexOf("/")));
                this.setParam("startdate", dateOfJob);
                this.setParam("enddate", dateOfJob);
                return;
            }
            catch (Exception e) {
                String msg = HBCIUtilsInternal.getLocMsg("EXCMSG_CANTEXTRACTDATE", value);
                if (HBCIUtilsInternal.ignoreError(this.getMainPassport(), "client.errors.ignoreWrongJobDataErrors", msg + ": " + HBCIUtils.exception2String(e))) return;
                throw new InvalidUserDataException(msg, e);
            }
        } else {
            super.setParam(paramName, value);
        }
    }
}

