/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.GV.parsers.SEPAParserFactory;
import org.kapott.hbci.GV_Result.GVRDauerList;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.sepa.PainVersion;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public final class GVDauerSEPAList
extends AbstractSEPAGV {
    private static final PainVersion DEFAULT = PainVersion.PAIN_001_001_02;

    @Override
    protected PainVersion getDefaultPainVersion() {
        return DEFAULT;
    }

    @Override
    protected PainVersion.Type getPainType() {
        return PainVersion.Type.PAIN_001;
    }

    public static String getLowlevelName() {
        return "DauerSEPAList";
    }

    public GVDauerSEPAList(HBCIHandler handler) {
        super(handler, GVDauerSEPAList.getLowlevelName(), new GVRDauerList());
        this.addConstraint("src.bic", "My.bic", null, 3);
        this.addConstraint("src.iban", "My.iban", null, 2);
        if (this.canNationalAcc(handler)) {
            this.addConstraint("src.country", "My.KIK.country", "", 0);
            this.addConstraint("src.blz", "My.KIK.blz", "", 3);
            this.addConstraint("src.number", "My.number", "", 2);
            this.addConstraint("src.subnumber", "My.subnumber", "", 3);
        }
        this.addConstraint("_sepadescriptor", "sepadescr", this.getPainVersion().getURN(), 0);
        this.addConstraint("orderid", "orderid", "", 0);
        this.addConstraint("maxentries", "maxentries", "", 0);
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        GVRDauerList.Dauer entry = new GVRDauerList.Dauer();
        HBCIUtils.log("parsing SEPA standing orders from msg data [size: " + result.size() + "]", 3);
        entry.my = new Konto();
        entry.my.country = result.getProperty(header + ".My.KIK.country");
        entry.my.blz = result.getProperty(header + ".My.KIK.blz");
        entry.my.number = result.getProperty(header + ".My.number");
        entry.my.subnumber = result.getProperty(header + ".My.subnumber");
        entry.my.iban = result.getProperty(header + ".My.iban");
        entry.my.bic = result.getProperty(header + ".My.bic");
        this.getMainPassport().fillAccountInfo(entry.my);
        entry.other = new Konto();
        String sepadescr = result.getProperty(header + ".sepadescr");
        String pain = result.getProperty(header + ".sepapain");
        PainVersion version = PainVersion.choose(sepadescr, pain);
        ISEPAParser parser = SEPAParserFactory.get(version);
        ArrayList<Properties> sepaResults = new ArrayList<Properties>();
        try {
            HBCIUtils.log("  parsing sepa data: " + pain, 5);
            parser.parse(new ByteArrayInputStream(pain.getBytes("ISO-8859-1")), sepaResults);
            HBCIUtils.log("  parsed sepa data, entries: " + sepaResults.size(), 3);
        }
        catch (Exception e) {
            HBCIUtils.log("  unable to parse sepa data: " + e.getMessage(), 1);
            throw new HBCI_Exception("Error parsing SEPA pain document", e);
        }
        if (sepaResults.isEmpty()) {
            HBCIUtils.log("  found no sepa data", 2);
            return;
        }
        Properties sepaResult = sepaResults.get(0);
        entry.other.iban = sepaResult.getProperty("dst.iban");
        entry.other.bic = sepaResult.getProperty("dst.bic");
        entry.other.name = sepaResult.getProperty("dst.name");
        entry.pmtinfid = sepaResult.getProperty("pmtinfid");
        entry.purposecode = sepaResult.getProperty("purposecode");
        entry.value = new Value(sepaResult.getProperty("value"), sepaResult.getProperty("curr"));
        entry.addUsage(sepaResult.getProperty("usage"));
        entry.orderid = result.getProperty(header + ".orderid");
        entry.firstdate = HBCIUtils.string2DateISO(result.getProperty(header + ".DauerDetails.firstdate"));
        entry.timeunit = result.getProperty(header + ".DauerDetails.timeunit");
        entry.turnus = Integer.parseInt(result.getProperty(header + ".DauerDetails.turnus"));
        entry.execday = Integer.parseInt(result.getProperty(header + ".DauerDetails.execday"));
        String st = result.getProperty(header + ".DauerDetails.lastdate");
        if (st != null) {
            entry.lastdate = HBCIUtils.string2DateISO(st);
        }
        boolean bl = entry.aus_available = result.getProperty(header + ".Aussetzung.annual") != null;
        if (entry.aus_available) {
            entry.aus_annual = result.getProperty(header + ".Aussetzung.annual").equals("J");
            st = result.getProperty(header + ".Aussetzung.startdate");
            if (st != null) {
                entry.aus_start = HBCIUtils.string2DateISO(st);
            }
            if ((st = result.getProperty(header + ".Aussetzung.enddate")) != null) {
                entry.aus_end = HBCIUtils.string2DateISO(st);
            }
            entry.aus_breakcount = result.getProperty(header + ".Aussetzung.number");
            st = result.getProperty(header + ".Aussetzung.newvalue.value");
            if (st != null) {
                entry.aus_newvalue = new Value(st, result.getProperty(header + ".Aussetzung.newvalue.curr"));
            }
        }
        entry.can_change = result.getProperty(header + ".canchange") == null || result.getProperty(header + ".canchange").equals("J");
        entry.can_skip = result.getProperty(header + ".canskip") == null || result.getProperty(header + ".canskip").equals("J");
        entry.can_delete = result.getProperty(header + ".candel") == null || result.getProperty(header + ".candel").equals("J");
        ((GVRDauerList)this.jobResult).addEntry(entry);
        if (entry.orderid != null && entry.orderid.length() != 0) {
            Properties p2 = new Properties();
            Enumeration<?> e = result.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith(header + ".") || key.startsWith(header + ".SegHead.") || key.endsWith(".orderid")) continue;
                p2.setProperty(key.substring(header.length() + 1), result.getProperty(key));
            }
            this.getMainPassport().setPersistentData("dauer_" + entry.orderid, p2);
        }
    }

    @Override
    public String getPainJobName() {
        return "UebSEPA";
    }
}

