/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.status;

import java.util.ArrayList;
import java.util.List;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIRetVal;

public final class HBCIStatus {
    public static final int STATUS_OK = 0;
    public static final int STATUS_UNKNOWN = 1;
    public static final int STATUS_ERR = 2;
    private List<HBCIRetVal> retVals = new ArrayList<HBCIRetVal>();
    private List<Exception> exceptions = new ArrayList<Exception>();

    public void addException(Exception e) {
        this.exceptions.add(e);
        HBCIUtils.log(e);
    }

    public void addRetVal(HBCIRetVal ret) {
        this.retVals.add(ret);
        if (ret.isError()) {
            HBCIUtils.log("HBCI error code: " + ret.toString(), 1);
        }
    }

    public boolean hasExceptions() {
        return this.exceptions.size() != 0;
    }

    private boolean hasX(char code) {
        boolean ret = false;
        for (HBCIRetVal retVal : this.retVals) {
            if (retVal.code.charAt(0) != code) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean hasErrors() {
        return this.hasX('9');
    }

    public boolean hasWarnings() {
        return this.hasX('3');
    }

    public boolean hasSuccess() {
        return this.hasX('0');
    }

    private HBCIRetVal[] getX(char code) {
        ArrayList<HBCIRetVal> ret_a = new ArrayList<HBCIRetVal>();
        for (HBCIRetVal retVal : this.retVals) {
            if (retVal.code.charAt(0) != code) continue;
            ret_a.add(retVal);
        }
        HBCIRetVal[] ret = new HBCIRetVal[]{};
        if (ret_a.size() != 0) {
            ret = ret_a.toArray(ret);
        }
        return ret;
    }

    public Exception[] getExceptions() {
        return this.exceptions.toArray(new Exception[this.exceptions.size()]);
    }

    public HBCIRetVal[] getRetVals() {
        return this.retVals.toArray(new HBCIRetVal[this.retVals.size()]);
    }

    public HBCIRetVal[] getErrors() {
        return this.getX('9');
    }

    public HBCIRetVal[] getWarnings() {
        return this.getX('3');
    }

    public HBCIRetVal[] getSuccess() {
        return this.getX('0');
    }

    public int getStatusCode() {
        int code = this.hasExceptions() || this.hasErrors() ? 2 : (this.hasSuccess() || this.hasWarnings() ? 0 : 1);
        return code;
    }

    public boolean isOK() {
        return this.getStatusCode() == 0;
    }

    public String getErrorString() {
        StringBuffer ret = new StringBuffer();
        if (this.hasExceptions()) {
            for (Exception ex : this.exceptions) {
                ret.append(HBCIUtils.exception2StringShort(ex));
                ret.append(System.getProperty("line.separator"));
            }
        }
        if (this.hasErrors()) {
            HBCIRetVal[] errList = this.getErrors();
            for (int i = 0; i < errList.length; ++i) {
                ret.append(errList[i].toString());
                ret.append(System.getProperty("line.separator"));
            }
        }
        return ret.toString().trim();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (Exception ex : this.exceptions) {
            ret.append(HBCIUtils.exception2StringShort(ex));
            ret.append(System.getProperty("line.separator"));
        }
        HBCIRetVal[] errList = this.getErrors();
        for (int i = 0; i < errList.length; ++i) {
            ret.append(errList[i].toString());
            ret.append(System.getProperty("line.separator"));
        }
        HBCIRetVal[] warnList = this.getWarnings();
        for (int i = 0; i < warnList.length; ++i) {
            ret.append(warnList[i].toString());
            ret.append(System.getProperty("line.separator"));
        }
        HBCIRetVal[] succList = this.getSuccess();
        for (int i = 0; i < succList.length; ++i) {
            ret.append(succList[i].toString());
            ret.append(System.getProperty("line.separator"));
        }
        return ret.toString().trim();
    }
}

