/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.status;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIDialogStatus;

public class HBCIExecStatus {
    private HBCIDialogStatus statusData;
    private ArrayList<Exception> exceptions = new ArrayList();

    public void addDialogStatus(HBCIDialogStatus status) {
        this.statusData = status;
    }

    public void addException(Exception e) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
            this.exceptions.add(e);
        }
        HBCIUtils.log(e);
    }

    public HBCIDialogStatus getDialogStatusList() {
        return this.statusData;
    }

    public HBCIDialogStatus getDialogStatus() {
        return this.statusData;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public String getErrorString() {
        String errMsg;
        HBCIDialogStatus status;
        StringBuffer ret = new StringBuffer();
        String linesep = System.getProperty("line.separator");
        List<Exception> exc = this.getExceptions();
        if (exc != null && exc.size() != 0) {
            Iterator<Exception> j = exc.iterator();
            while (j.hasNext()) {
                ret.append(HBCIUtils.exception2StringShort(j.next()));
                ret.append(linesep);
            }
        }
        if ((status = this.getDialogStatus()) != null && (errMsg = status.getErrorString()).length() != 0) {
            ret.append(errMsg + linesep);
        }
        return ret.toString().trim();
    }

    public String toString() {
        HBCIDialogStatus status;
        StringBuffer ret = new StringBuffer();
        String linesep = System.getProperty("line.separator");
        List<Exception> exc = this.getExceptions();
        if (exc != null) {
            Iterator<Exception> j = exc.iterator();
            while (j.hasNext()) {
                ret.append(HBCIUtils.exception2StringShort(j.next()));
                ret.append(linesep);
            }
        }
        if ((status = this.getDialogStatus()) != null) {
            ret.append(status.toString() + linesep);
        }
        return ret.toString().trim();
    }

    public boolean isOK() {
        boolean ok = true;
        List<Exception> exc = this.getExceptions();
        HBCIDialogStatus status = this.getDialogStatus();
        ok &= exc == null || exc.size() == 0;
        ok &= status != null;
        return ok &= status.isOK();
    }
}

