/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.smartcardio;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;

public abstract class HBCICardService {
    private static final Map<String, String> statusCodes = new HashMap<String, String>();
    static final int HBCI_DDV_EF_ID = 25;
    static final int HBCI_DDV_EF_BNK = 26;
    static final int HBCI_DDV_EF_MAC = 27;
    static final int HBCI_DDV_EF_SEQ = 28;
    static final int SECCOS_SELECT_RET_NOTHING = 12;
    static final int SECCOS_CLA_EXT = 176;
    static final int SECCOS_CLA_SM_PROPR = 4;
    static final int SECCOS_CLA_SM1 = 8;
    static final int SECCOS_CLA_STD = 0;
    static final int SECCOS_INS_GET_CHALLENGE = 132;
    static final int SECCOS_INS_GET_KEYINFO = 238;
    static final int SECCOS_INS_INT_AUTH = 136;
    static final int SECCOS_INS_PUT_DATA = 218;
    static final int SECCOS_INS_READ_RECORD = 178;
    static final int SECCOS_INS_SELECT_FILE = 164;
    static final int SECCOS_INS_VERIFY = 32;
    static final int SECCOS_INS_UPDATE_RECORD = 220;
    static final int SECCOS_INS_WRITE_RECORD = 210;
    static final int SECCOS_KEY_TYPE_DF = 128;
    static final int SECCOS_PWD_TYPE_DF = 128;
    static final byte SECCOS_SM_CRT_CC = -76;
    static final byte SECCOS_SM_REF_INIT_DATA = -121;
    static final byte SECCOS_SM_RESP_DESCR = -70;
    static final byte SECCOS_SM_VALUE_LE = -106;
    private static final String[] FEATURES;
    static final Byte FEATURE_VERIFY_PIN_START;
    static final Byte FEATURE_VERIFY_PIN_FINISH;
    static final Byte FEATURE_GET_KEY_PRESSED;
    static final Byte FEATURE_VERIFY_PIN_DIRECT;
    static final Byte FEATURE_MCT_READER_DIRECT;
    static final Byte FEATURE_MCT_UNIVERSAL;
    static final Byte FEATURE_IFD_PIN_PROPERTIES;
    private static final int IOCTL_GET_FEATURE_REQUEST;
    private Map<Byte, Integer> features = new HashMap<Byte, Integer>();
    private Card smartCard = null;

    private static int SCARD_CTL_CODE(int code) {
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1) {
            return 0x310000 | code << 2;
        }
        return 0x42000000 + code;
    }

    public void init(Card card) {
        this.smartCard = card;
        try {
            HBCIUtils.log("querying features", 3);
            byte[] response = this.smartCard.transmitControlCommand(IOCTL_GET_FEATURE_REQUEST, new byte[0]);
            for (int i = 0; i < response.length; i += 6) {
                Byte feature = new Byte(response[i]);
                Integer ioctl = new Integer((0xFF & response[i + 2]) << 24) | (0xFF & response[i + 3]) << 16 | (0xFF & response[i + 4]) << 8 | 0xFF & response[i + 5];
                String name = null;
                try {
                    name = FEATURES[feature.intValue()];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    name = "FEATURE_UNKNOWN";
                }
                HBCIUtils.log("  " + name + ": " + Integer.toHexString(ioctl), 3);
                this.features.put(feature, ioctl);
            }
        }
        catch (Exception e) {
            throw new HBCI_Exception(e);
        }
    }

    public Map<Byte, Integer> getFeatures() {
        return Collections.unmodifiableMap(this.features);
    }

    public void verifyHardPIN(int pwdId) {
        try {
            byte[] response = this.smartCard.transmitControlCommand(this.features.get(FEATURE_VERIFY_PIN_DIRECT), this.createPINVerificationDataStructure(pwdId));
            ResponseAPDU apdu = new ResponseAPDU(response);
            int sw = apdu.getSW();
            if (sw == 25536) {
                throw new HBCI_Exception("PIN falsch. Noch 1 Versuch");
            }
            if (sw == 25537) {
                throw new HBCI_Exception("PIN falsch. Noch 2 Versuche");
            }
            if (sw == 25538) {
                throw new HBCI_Exception("PIN falsch. Noch 3 Versuche");
            }
            if (sw == 25600) {
                throw new HBCI_Exception("PIN-Eingabe aufgrund Timeout abgebrochen");
            }
            if (sw == 25601) {
                throw new HBCI_Exception("PIN-Eingabe vom User abgebrochen");
            }
            if (sw == 27011) {
                throw new HBCI_Exception("Chipkarte ist gesperrt oder besitzt ein unbekanntes Format");
            }
            this.check(apdu, new byte[]{-112});
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception(e);
        }
    }

    public void verifySoftPIN(int pwdId, byte[] softPin) {
        byte[] body = new byte[]{37, -1, -1, -1, -1, -1, -1, -1};
        for (int i = 0; i < softPin.length; ++i) {
            int n = 1 + (i >> 1);
            body[n] = (byte)(body[n] & (byte)(15 << 4 * (i & 1) & 0xFF));
            int n2 = 1 + (i >> 1);
            body[n2] = (byte)(body[n2] | (byte)(softPin[i] - 48 << 4 - 4 * (i & 1) & 0xFF));
        }
        CommandAPDU command = new CommandAPDU(0, 32, 0, (int)((byte)(0x80 | pwdId)), body);
        this.send(command);
    }

    protected void writeRecordBySFI(int sfi, int idx, byte[] data) {
        CommandAPDU command = new CommandAPDU(0, 210, (int)((byte)(idx + 1)), (int)((byte)(sfi << 3 | 4)), data);
        this.send(command);
    }

    protected void updateRecordBySFI(int sfi, int idx, byte[] data) {
        CommandAPDU command = new CommandAPDU(0, 220, idx + 1, sfi << 3 | 4, data);
        this.send(command);
    }

    protected byte[] readRecordBySFI(int sfi, int idx) {
        CommandAPDU command = new CommandAPDU(0, 178, idx + 1, sfi << 3 | 4, 256);
        return this.receive(command);
    }

    protected byte[] readRecord(int idx) {
        return this.readRecordBySFI(0, idx);
    }

    protected void selectSubFile(int id) {
        CommandAPDU command = new CommandAPDU(0, 164, 2, 12, new byte[]{(byte)(id >> 8 & 0xFF), (byte)(id & 0xFF)});
        this.send(command);
    }

    protected byte[] getKeyInfo(int idx) {
        CommandAPDU command = new CommandAPDU(176, 238, 128, idx + 1, 256);
        return this.receive(command);
    }

    protected void putData(int tag, byte[] data) {
        CommandAPDU command = new CommandAPDU(0, 218, (int)((byte)(tag >> 8 & 0xFF)), (int)((byte)(tag & 0xFF)), data);
        this.send(command);
    }

    protected byte[] getChallenge() {
        CommandAPDU command = new CommandAPDU(0, 132, 0, 0, 8);
        return this.receive(command);
    }

    protected byte[] internalAuthenticate(int keynum, byte[] challenge) {
        CommandAPDU command = new CommandAPDU(0, 136, 0, 0x80 | keynum, challenge, 8);
        return this.receive(command);
    }

    void send(CommandAPDU command) {
        this._receive(command, new byte[]{-112, 97});
    }

    byte[] receive(CommandAPDU command) {
        return this._receive(command, new byte[]{-112});
    }

    private byte[] _receive(CommandAPDU command, byte[] returncodes) {
        try {
            String caller = "";
            try {
                StackTraceElement[] stack = Thread.currentThread().getStackTrace();
                caller = stack[3].getMethodName();
            }
            catch (Exception stack) {
                // empty catch block
            }
            CardChannel channel = this.smartCard.getBasicChannel();
            ResponseAPDU response = channel.transmit(command);
            HBCIUtils.log(caller + " command : " + this.toHex(command.getBytes()), 4);
            HBCIUtils.log(caller + " response: " + this.toHex(response.getBytes()), 4);
            this.check(response, returncodes);
            return response.getData();
        }
        catch (HBCI_Exception e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new HBCI_Exception(e2);
        }
    }

    private void check(ResponseAPDU response, byte[] returncodes) {
        byte sw1 = (byte)response.getSW1();
        for (byte b : returncodes) {
            if (sw1 != b) continue;
            return;
        }
        String code = Integer.toHexString(response.getSW()).toUpperCase();
        String msg = statusCodes.get(code);
        if (msg != null) {
            throw new HBCI_Exception("Fehler " + code + ": " + msg);
        }
        throw new HBCI_Exception("Fehler " + code + " bei Kartenleser-Zugriff");
    }

    private String toHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (byte b : bytes) {
            String s = Integer.toHexString(b & 0xFF).toUpperCase();
            if (s.length() == 1) {
                sb.append("0");
            }
            sb.append(s);
            sb.append(" ");
        }
        return sb.toString();
    }

    protected byte[] expand(String st, int len) {
        try {
            StringBuffer st_new = new StringBuffer(st);
            for (int i = st.length(); i < len; ++i) {
                st_new.append(" ");
            }
            return st_new.toString().getBytes("ISO-8859-1");
        }
        catch (HBCI_Exception e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new HBCI_Exception(e2);
        }
    }

    protected byte[] createPINVerificationDataStructure(int pwdId) throws IOException {
        ByteArrayOutputStream verifyCommand = new ByteArrayOutputStream();
        verifyCommand.write(15);
        verifyCommand.write(5);
        verifyCommand.write(137);
        verifyCommand.write(7);
        verifyCommand.write(16);
        verifyCommand.write(new byte[]{8, 4});
        verifyCommand.write(2);
        verifyCommand.write(1);
        verifyCommand.write(new byte[]{4, 9});
        verifyCommand.write(0);
        verifyCommand.write(new byte[]{0, 0, 0});
        byte[] verifyApdu = new byte[]{0, 32, 0, (byte)(0x80 | pwdId), 8, 37, -1, -1, -1, -1, -1, -1, -1};
        verifyCommand.write(verifyApdu.length & 0xFF);
        verifyCommand.write(0);
        verifyCommand.write(0);
        verifyCommand.write(0);
        verifyCommand.write(verifyApdu);
        return verifyCommand.toByteArray();
    }

    static {
        statusCodes.put("6281", "Die zur\u00fcckgegebenen Daten k\u00f6nnen fehlerhaft sein");
        statusCodes.put("6282", "Da das Dateiende vorher erreicht wurde, konnten nur weniger als Le Bytes gelesen werden");
        statusCodes.put("6283", "Die ausgew\u00e4hlte Datei ist gesperrt");
        statusCodes.put("6284", "Die File Control Information (FCI) ist nicht ISO 7816-4 konform");
        statusCodes.put("6381", "File filled up by the last write");
        statusCodes.put("6581", "Speicherfehler");
        statusCodes.put("6700", "L\u00e4nge (Lc oder Le) falsch");
        statusCodes.put("6800", "Funktionen im Class Byte werden nicht unterst\u00fctzt");
        statusCodes.put("6881", "Logische Kan\u00e4le werden nicht unterst\u00fctzt");
        statusCodes.put("6882", "Secure Messaging wird nicht unterst\u00fctzt");
        statusCodes.put("6900", "Kommando nicht erlaubt");
        statusCodes.put("6981", "Kommando inkompatibel zur Dateistruktur");
        statusCodes.put("6982", "Sicherheitszustand nicht erf\u00fcllt");
        statusCodes.put("6983", "Authentisierungsmethode ist gesperrt");
        statusCodes.put("6984", "Referenzierte Daten sind gesperrt");
        statusCodes.put("6985", "Nutzungsbedingungen sind nicht erf\u00fcllt");
        statusCodes.put("6986", "Kommando nicht erlaubt (kein EF selektiert)");
        statusCodes.put("6987", "Erwartete Secure Messaging Objekte nicht gefunden");
        statusCodes.put("6988", "Secure Messaging Datenobjekte sind inkorrekt");
        statusCodes.put("6A00", "Falsche Parameter P1/P2");
        statusCodes.put("6A80", "Falsche Daten");
        statusCodes.put("6A81", "Funktion wird nicht unterst\u00fctzt");
        statusCodes.put("6A82", "Datei wurde nicht gefunden");
        statusCodes.put("6A83", "Record der Datei nicht gefunden");
        statusCodes.put("6A84", "Nicht gen\u00fcgend Speicherplatz in der Datei");
        statusCodes.put("6A85", "Lc nicht konsistent mit der TLV Struktur");
        statusCodes.put("6A86", "Inkorrekte Parameter P1/P2");
        statusCodes.put("6A87", "Lc inkonsistent mit P1/P2");
        statusCodes.put("6A88", "Referenzierte Daten nicht gefunden");
        statusCodes.put("6B00", "Parameter P1/P2 falsch");
        statusCodes.put("6D00", "Das Kommando (INS) wird nicht unterst\u00fctzt");
        statusCodes.put("6E00", "Die Kommandoklasse (CLA) wird nicht unterst\u00fctzt");
        statusCodes.put("6F00", "Kommando wurde mit unbekanntem Fehler abgebrochen");
        FEATURES = new String[]{"NO_FEATURE", "FEATURE_VERIFY_PIN_START", "FEATURE_VERIFY_PIN_FINISH", "FEATURE_MODIFY_PIN_START", "FEATURE_MODIFY_PIN_FINISH", "FEATURE_GET_KEY_PRESSED", "FEATURE_VERIFY_PIN_DIRECT", "FEATURE_MODIFY_PIN_DIRECT", "FEATURE_MCT_READER_DIRECT", "FEATURE_MCT_UNIVERSAL", "FEATURE_IFD_PIN_PROPERTIES", "FEATURE_ABORT", "FEATURE_SET_SPE_MESSAGE", "FEATURE_VERIFY_PIN_DIRECT_APP_ID", "FEATURE_MODIFY_PIN_DIRECT_APP_ID", "FEATURE_WRITE_DISPLAY", "FEATURE_GET_KEY", "FEATURE_IFD_DISPLAY_PROPERTIES", "FEATURE_GET_TLV_PROPERTIES", "FEATURE_CCID_ESC_COMMAND"};
        FEATURE_VERIFY_PIN_START = new Byte(1);
        FEATURE_VERIFY_PIN_FINISH = new Byte(2);
        FEATURE_GET_KEY_PRESSED = new Byte(5);
        FEATURE_VERIFY_PIN_DIRECT = new Byte(6);
        FEATURE_MCT_READER_DIRECT = new Byte(8);
        FEATURE_MCT_UNIVERSAL = new Byte(9);
        FEATURE_IFD_PIN_PROPERTIES = new Byte(10);
        IOCTL_GET_FEATURE_REQUEST = HBCICardService.SCARD_CTL_CODE(3400);
    }
}

