/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.protocol;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.kapott.hbci.exceptions.NoSuchPathException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.protocol.DE;
import org.kapott.hbci.protocol.MultipleSFs;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SyntaxElement;
import org.kapott.hbci.protocol.factory.MultipleSEGsFactory;
import org.kapott.hbci.protocol.factory.MultipleSFsFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class MSG
extends SyntaxElement {
    public static final boolean CHECK_SEQ = true;
    public static final boolean DONT_CHECK_SEQ = false;
    public static final boolean CHECK_VALIDS = true;
    public static final boolean DONT_CHECK_VALIDS = false;

    @Override
    protected MultipleSyntaxElements createNewChildContainer(Node ref, Document syntax) {
        MultipleSyntaxElements ret = null;
        if (ref.getNodeName().equals("SEG")) {
            ret = MultipleSEGsFactory.getInstance().createMultipleSEGs(ref, this.getPath(), syntax);
        } else if (ref.getNodeName().equals("SF")) {
            ret = MultipleSFsFactory.getInstance().createMultipleSFs(ref, this.getPath(), syntax);
        }
        return ret;
    }

    @Override
    protected String getElementTypeName() {
        return "MSG";
    }

    private void propagateUserData(String name, Hashtable<String, String> clientValues) {
        String dottedName = name + ".";
        Enumeration<String> e = clientValues.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = clientValues.get(key);
            if (!key.startsWith(dottedName) || value.length() == 0 || this.propagateValue(key, value, true, false)) continue;
            HBCIUtils.log("could not insert the following user-defined data into message: " + key + "=" + value, 2);
        }
    }

    private void setMsgSizeValue(MsgGen gen, int value, boolean allowOverwrite) {
        String absPath = this.getPath() + ".MsgHead.msgsize";
        SyntaxElement msgsizeElem = this.getElement(absPath);
        if (msgsizeElem == null) {
            throw new NoSuchPathException(absPath);
        }
        int size = ((DE)msgsizeElem).getMinSize();
        char[] zeros = new char[size];
        Arrays.fill(zeros, '0');
        DecimalFormat df = new DecimalFormat(String.valueOf(zeros));
        if (!this.propagateValue(absPath, df.format(value), false, allowOverwrite)) {
            throw new NoSuchPathException(absPath);
        }
    }

    private void initMsgSize(MsgGen gen) {
        this.setMsgSizeValue(gen, 0, false);
    }

    public void autoSetMsgSize(MsgGen gen) {
        this.setMsgSizeValue(gen, this.toString(0).length(), true);
    }

    public MSG(String type, MsgGen gen, Hashtable<String, String> clientValues) {
        super(type, type, null, 0, gen.getSyntax());
        this.initData(type, gen, clientValues);
    }

    public void init(String type, MsgGen gen, Hashtable<String, String> clientValues) {
        super.init(type, type, null, 0, gen.getSyntax());
        this.initData(type, gen, clientValues);
    }

    private void initData(String type, MsgGen gen, Hashtable<String, String> clientValues) {
        this.propagateUserData(this.getName(), clientValues);
        this.enumerateSegs(0, false);
        this.initMsgSize(gen);
        this.validate();
        this.enumerateSegs(1, true);
        this.autoSetMsgSize(gen);
    }

    @Override
    public String toString(int zero) {
        StringBuffer ret = new StringBuffer(1024);
        if (this.isValid()) {
            ListIterator<MultipleSyntaxElements> i = this.getChildContainers().listIterator();
            while (i.hasNext()) {
                MultipleSyntaxElements list = (MultipleSyntaxElements)i.next();
                if (list == null) continue;
                ret.append(list.toString(0));
            }
        }
        return ret.toString();
    }

    public void log(int logLevel) {
        if (this.isValid()) {
            ListIterator<MultipleSyntaxElements> i = this.getChildContainers().listIterator();
            while (i.hasNext()) {
                MultipleSyntaxElements list = (MultipleSyntaxElements)i.next();
                if (list == null) continue;
                HBCIUtils.log(list.toString(0), logLevel);
            }
        }
    }

    private void initData(String type, String res, int fullResLen, MsgGen gen, boolean checkSeq, boolean checkValids) {
        if (checkSeq) {
            this.checkSegSeq(1);
        }
    }

    public MSG(String type, String res, int fullResLen, MsgGen gen, boolean checkSeq, boolean checkValids) {
        super(type, type, null, '\u0000', 0, new StringBuffer(res), fullResLen, gen.getSyntax(), new Hashtable<String, String>(), checkValids ? new Hashtable() : null);
        this.initData(type, res, fullResLen, gen, checkSeq, checkValids);
    }

    public void init(String type, String res, int fullResLen, MsgGen gen, boolean checkSeq, boolean checkValids) {
        super.init(type, type, null, '\u0000', 0, new StringBuffer(res), fullResLen, gen.getSyntax(), new Hashtable<String, String>(), checkValids ? new Hashtable() : null);
        this.initData(type, res, fullResLen, gen, checkSeq, checkValids);
    }

    @Override
    protected char getInDelim() {
        return '\'';
    }

    @Override
    protected MultipleSyntaxElements parseNewChildContainer(Node segref, char predelim0, char predelim1, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        MultipleSyntaxElements ret = null;
        if (segref.getNodeName().equals("SEG")) {
            ret = MultipleSEGsFactory.getInstance().createMultipleSEGs(segref, this.getPath(), predelim0, predelim1, res, fullResLen, syntax, predefs, valids);
        } else if (segref.getNodeName().equals("SF")) {
            ret = MultipleSFsFactory.getInstance().createMultipleSFs(segref, this.getPath(), predelim0, predelim1, res, fullResLen, syntax, predefs, valids);
        }
        return ret;
    }

    @Override
    public String getValueOfDE(String path) {
        String ret = null;
        ListIterator<MultipleSyntaxElements> i = this.getChildContainers().listIterator();
        while (i.hasNext()) {
            MultipleSyntaxElements l = i.next();
            String temp = l.getValueOfDE(path);
            if (temp == null) continue;
            ret = temp;
            break;
        }
        if (ret == null) {
            throw new NoSuchPathException(path);
        }
        return ret;
    }

    public Properties getData() {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        Properties p = new Properties();
        int nameskip = this.getName().length() + 1;
        this.extractValues(hash);
        Enumeration<String> e = hash.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            p.setProperty(key.substring(nameskip), hash.get(key));
        }
        return p;
    }

    @Override
    public void getElementPaths(Properties p, int[] segref, int[] degref, int[] deref) {
        segref = new int[]{1};
        for (MultipleSyntaxElements l : this.getChildContainers()) {
            if (l == null) continue;
            l.getElementPaths(p, segref, null, null);
        }
    }

    @Override
    public void destroy() {
        List<MultipleSyntaxElements> childContainers = this.getChildContainers();
        for (MultipleSyntaxElements child : childContainers) {
            if (child instanceof MultipleSFs) {
                MultipleSFsFactory.getInstance().unuseObject(child);
                continue;
            }
            MultipleSEGsFactory.getInstance().unuseObject(child);
        }
        super.destroy();
    }
}

