/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.comm.CommPinTan;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidPassphraseException;
import org.kapott.hbci.manager.FlickerCode;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.HHDVersion;
import org.kapott.hbci.manager.LogFilter;
import org.kapott.hbci.passport.AbstractPinTanPassport;

public class HBCIPassportPinTan
extends AbstractPinTanPassport {
    private String filename;
    private static final byte[] CIPHER_SALT = new byte[]{38, 25, 56, -89, -103, -68, -15, 85};
    private static final int CIPHER_ITERATIONS = 987;

    public HBCIPassportPinTan(Properties properties, HBCICallback callback, Object init, int dummy) {
        super(properties, callback, init);
        this.properties = properties;
    }

    public HBCIPassportPinTan(Properties properties, HBCICallback callback, Object initObject) {
        this(properties, callback, initObject, 0);
        if (properties == null) {
            return;
        }
        String header = "client.passport.PinTan.";
        String fname = properties.getProperty(header + "filename");
        boolean init = properties.getProperty(header + "init", "1").equals("1");
        this.setFileName(fname);
        this.setCertFile(properties.getProperty(header + "certfile"));
        this.setCheckCert(properties.getProperty(header + "checkcert", "1").equals("1"));
        this.setProxy(properties.getProperty(header + "proxy", ""));
        this.setProxyUser(properties.getProperty(header + "proxyuser", ""));
        this.setProxyPass(properties.getProperty(header + "proxypass", ""));
        if (init) {
            this.read();
            if (this.askForMissingData(true, true, true, true, true, true, true)) {
                this.saveChanges();
            }
        }
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String filename) {
        this.filename = filename;
    }

    @Override
    public void resetPassphrase() {
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    protected void create() {
        String fname = this.getFileName();
        if (fname == null) {
            throw new NullPointerException("client.passport.PinTan.filename must not be null");
        }
        File file = new File(fname);
        if (file.exists() && file.isFile() && file.canRead()) {
            return;
        }
        HBCIUtils.log("have to create new passport file", 2);
        this.askForMissingData(true, true, true, true, true, true, true);
        this.saveChanges();
    }

    protected void read() {
        this.create();
        String fname = this.getFileName();
        if (fname == null) {
            throw new NullPointerException("client.passport.PinTan.filename must not be null");
        }
        HBCIUtils.log("loading data from file " + fname, 4);
        ObjectInputStream o = null;
        try {
            int retries = Integer.parseInt(this.properties.getProperty("client.retries.passphrase", "3"));
            do {
                o = null;
                try {
                    o = new ObjectInputStream(new FileInputStream(fname));
                }
                catch (StreamCorruptedException e) {
                    if (--retries > 0) continue;
                    throw new InvalidPassphraseException();
                }
            } while (o == null);
            this.setCountry((String)o.readObject());
            this.setBLZ((String)o.readObject());
            this.setHost((String)o.readObject());
            this.setPort((Integer)o.readObject());
            this.setUserId((String)o.readObject());
            this.setSysId((String)o.readObject());
            this.setBPD((Properties)o.readObject());
            this.setUPD((Properties)o.readObject());
            this.setHBCIVersion((String)o.readObject());
            this.setCustomerId((String)o.readObject());
            this.setFilterType((String)o.readObject());
            try {
                this.setAllowedTwostepMechanisms((List)o.readObject());
                try {
                    this.setCurrentTANMethod((String)o.readObject());
                }
                catch (Exception e) {
                    HBCIUtils.log("no current secmech found in passport file - automatically upgrading to new file format", 2);
                }
            }
            catch (Exception e) {
                HBCIUtils.log("no list of allowed secmechs found in passport file - automatically upgrading to new file format", 2);
            }
        }
        catch (Exception e) {
            throw new HBCI_Exception("*** loading of passport file failed", e);
        }
        try {
            o.close();
        }
        catch (Exception e) {
            HBCIUtils.log(e);
        }
    }

    @Override
    public void saveChanges() {
        File passportfile = new File(this.getFileName());
        File tempfile = null;
        try {
            File directory = passportfile.getAbsoluteFile().getParentFile();
            String prefix = passportfile.getName() + "_";
            tempfile = File.createTempFile(prefix, "", directory);
            HBCIUtils.log("writing to passport file " + tempfile, 4);
            ObjectOutputStream o = new ObjectOutputStream(new FileOutputStream(tempfile));
            o.writeObject(this.getCountry());
            o.writeObject(this.getBLZ());
            o.writeObject(this.getHost());
            o.writeObject(this.getPort());
            o.writeObject(this.getUserId());
            o.writeObject(this.getSysId());
            o.writeObject(this.getBPD());
            o.writeObject(this.getUPD());
            o.writeObject(this.getHBCIVersion());
            o.writeObject(this.getCustomerId());
            o.writeObject(this.getFilterType());
            List<String> l = this.getAllowedTwostepMechanisms();
            HBCIUtils.log("saving two step mechs: " + l, 4);
            o.writeObject(l);
            String s = this.getCurrentTANMethod(false);
            HBCIUtils.log("saving current tan method: " + s, 4);
            o.writeObject(s);
            HBCIUtils.log("closing output stream", 4);
            o.close();
            this.safeReplace(passportfile, tempfile);
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception("*** saving of passport file failed", e);
        }
    }

    @Override
    public byte[] hash(byte[] data) {
        return data;
    }

    @Override
    public byte[] sign(byte[] data) {
        try {
            if (this.getPIN() == null) {
                StringBuffer s = new StringBuffer();
                HBCIUtilsInternal.getCallback().callback(this, 16, HBCIUtilsInternal.getLocMsg("CALLB_NEED_PTPIN"), 1, s);
                if (s.length() == 0) {
                    throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PINZERO"));
                }
                LogFilter.getInstance().addSecretData(this.getPIN(), "X", 1);
            }
            String tan = "";
            String pintanMethod = this.getCurrentTANMethod(false);
            if (pintanMethod.equals("999")) {
                HBCIUtils.log("onestep method - checking GVs to decide whether or not we need a TAN", 4);
                String codes = this.collectSegCodes(new String(data, "ISO-8859-1"));
                StringTokenizer tok = new StringTokenizer(codes, "|");
                while (tok.hasMoreTokens()) {
                    String code = tok.nextToken();
                    String info = this.getPinTanInfo(code);
                    if (info.equals("J")) {
                        HBCIUtils.log("the job with the code " + code + " needs a TAN", 4);
                        if (tan.length() == 0) {
                            StringBuffer s = new StringBuffer();
                            this.callback.callback(this, 17, HBCIUtilsInternal.getLocMsg("CALLB_NEED_PTTAN"), 2, s);
                            if (s.length() == 0) {
                                throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_TANZERO"));
                            }
                            tan = s.toString();
                            continue;
                        }
                        HBCIUtils.log("there should be only one job that needs a TAN!", 2);
                        continue;
                    }
                    if (info.equals("N")) {
                        HBCIUtils.log("the job with the code " + code + " does not need a TAN", 4);
                        continue;
                    }
                    if (info.length() != 0) continue;
                    HBCIUtils.log("the job with the code " + code + " seems not to be allowed with PIN/TAN", 2);
                }
            } else {
                HBCIUtils.log("twostep method - checking passport(challenge) to decide whether or not we need a TAN", 4);
                Properties secmechInfo = this.getCurrentSecMechInfo();
                String challenge = (String)this.getPersistentData("pintan_challenge");
                this.setPersistentData("pintan_challenge", null);
                if (challenge == null) {
                    HBCIUtils.log("will not sign with a TAN, because there is no challenge", 4);
                } else {
                    HBCIUtils.log("found challenge in passport, so we ask for a TAN", 4);
                    String hhduc = (String)this.getPersistentData("pintan_challenge_hhd_uc");
                    this.setPersistentData("pintan_challenge_hhd_uc", null);
                    HHDVersion hhd = HHDVersion.find(secmechInfo);
                    HBCIUtils.log("detected HHD version: " + (Object)((Object)hhd), 4);
                    StringBuffer payload = new StringBuffer();
                    String msg = secmechInfo.getProperty("name") + "\n" + secmechInfo.getProperty("inputinfo") + "\n\n" + challenge;
                    if (hhd.getType() == HHDVersion.Type.PHOTOTAN) {
                        payload.append(hhduc);
                        this.callback.callback(this, 33, msg, 2, payload);
                    } else {
                        String flicker = this.parseFlickercode(challenge, hhduc);
                        if (flicker != null) {
                            payload.append(flicker);
                        }
                        this.callback.callback(this, 17, msg, 2, payload);
                    }
                    this.setPersistentData("externalid", null);
                    if (payload == null || payload.length() == 0) {
                        throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_TANZERO"));
                    }
                    tan = payload.toString();
                }
            }
            if (tan.length() != 0) {
                LogFilter.getInstance().addSecretData(tan, "X", 1);
            }
            return (this.getPIN() + "|" + tan).getBytes("ISO-8859-1");
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** signing failed", ex);
        }
    }

    private String parseFlickercode(String challenge, String hhduc) {
        if (hhduc != null && hhduc.trim().length() > 0) {
            try {
                FlickerCode code = new FlickerCode(hhduc);
                return code.render();
            }
            catch (Exception e) {
                HBCIUtils.log("unable to parse Challenge HHDuc " + hhduc + ":" + HBCIUtils.exception2String(e), 4);
            }
        }
        if (challenge != null && challenge.trim().length() > 0) {
            try {
                FlickerCode code = new FlickerCode(challenge);
                return code.render();
            }
            catch (Exception e) {
                HBCIUtils.log("challenge contains no HHDuc (no problem in most cases):" + HBCIUtils.exception2String(e), 5);
            }
        }
        return null;
    }

    @Override
    public boolean verify(byte[] data, byte[] sig) {
        return true;
    }

    @Override
    public byte[][] encrypt(byte[] plainMsg) {
        try {
            byte padLength = plainMsg[plainMsg.length - 1];
            byte[] encrypted = new String(plainMsg, 0, plainMsg.length - padLength, "ISO-8859-1").getBytes("ISO-8859-1");
            return new byte[][]{new byte[8], encrypted};
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** encrypting message failed", ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] cryptedKey, byte[] cryptedMsg) {
        try {
            return new String(new String(cryptedMsg, "ISO-8859-1") + '\u0001').getBytes("ISO-8859-1");
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** decrypting of message failed", ex);
        }
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    protected CommPinTan getCommInstance() {
        return new CommPinTan(this);
    }

    @Override
    public void setCallback(HBCICallback callback) {
        this.callback = callback;
    }
}

