/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kapott.hbci.passport.HBCIPassportInternal;

public class HBCIPassportList {
    private List<Entry> passports = new ArrayList<Entry>();

    private boolean contains(HBCIPassportInternal passport) {
        boolean ret = false;
        Iterator<Entry> i = this.passports.iterator();
        while (i.hasNext()) {
            if (i.next().getPassport() != passport) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private void addPassport(Entry entry) {
        this.addPassport(entry.getPassport(), entry.getRole());
    }

    public void addPassport(HBCIPassportInternal passport, String role) {
        if (!this.contains(passport)) {
            Entry entry = new Entry(passport, role);
            this.passports.add(entry);
        }
    }

    public void addAll(HBCIPassportList passportList) {
        Iterator<Entry> i = passportList.iterator();
        while (i.hasNext()) {
            this.addPassport(i.next());
        }
    }

    public HBCIPassportInternal getMainPassport() {
        return this.getPassport(0);
    }

    public HBCIPassportInternal getPassport(int idx) {
        return this.passports.get(idx).getPassport();
    }

    public String getRole(int idx) {
        return this.passports.get(idx).getRole();
    }

    private Iterator<Entry> iterator() {
        return this.passports.iterator();
    }

    public int size() {
        return this.passports.size();
    }

    public void clear() {
        this.passports.clear();
    }

    private static class Entry {
        private HBCIPassportInternal passport;
        private String role;

        public Entry(HBCIPassportInternal passport, String role) {
            this.passport = passport;
            this.role = role;
        }

        public HBCIPassportInternal getPassport() {
            return this.passport;
        }

        public String getRole() {
            return this.role;
        }
    }
}

