/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.comm.CommPinTan;
import org.kapott.hbci.comm.Filter;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.IHandlerData;
import org.kapott.hbci.manager.LogFilter;
import org.kapott.hbci.passport.AbstractPinTanPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Limit;
import org.kapott.hbci.structures.Value;

public abstract class AbstractHBCIPassport
implements HBCIPassportInternal,
Serializable {
    private String paramHeader;
    private Properties bpd;
    private Properties upd;
    private String hbciversion;
    private String country;
    private String blz;
    private String host;
    private Integer port;
    private String filterType;
    private String userid;
    private String customerid;
    private String sysid;
    private Long sigid;
    private String cid;
    private CommPinTan comm;
    private Hashtable<String, Object> persistentData = new Hashtable();
    protected HBCICallback callback;
    private IHandlerData parentHandlerData;
    protected Properties properties;
    protected static final boolean FOR_SAVE = true;
    protected static final boolean FOR_LOAD = false;

    public AbstractHBCIPassport(Properties properties, HBCICallback callback, Object init) {
        this.callback = callback;
        this.properties = properties;
        this.setClientData("init", init);
    }

    protected boolean askForMissingData(boolean needCountry, boolean needBLZ, boolean needHost, boolean needPort, boolean needFilter, boolean needUserId, boolean needCustomerId) {
        StringBuffer sb;
        boolean dataChanged = false;
        if (needCountry && (this.getCountry() == null || this.getCountry().length() == 0)) {
            sb = new StringBuffer("DE");
            this.callback.callback(this, 7, HBCIUtilsInternal.getLocMsg("COUNTRY"), 2, sb);
            if (sb.length() == 0) {
                throw new InvalidUserDataException(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_X", HBCIUtilsInternal.getLocMsg("COUNTRY")));
            }
            this.setCountry(sb.toString());
            dataChanged = true;
        }
        if (needBLZ && (this.getBLZ() == null || this.getBLZ().length() == 0)) {
            sb = new StringBuffer();
            this.callback.callback(this, 8, HBCIUtilsInternal.getLocMsg("BLZ"), 2, sb);
            if (sb.length() == 0) {
                throw new InvalidUserDataException(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_X", HBCIUtilsInternal.getLocMsg("BLZ")));
            }
            this.setBLZ(sb.toString());
            dataChanged = true;
        }
        if (needHost && (this.getHost() == null || this.getHost().length() == 0)) {
            if (this instanceof AbstractPinTanPassport) {
                sb = new StringBuffer(HBCIUtils.getPinTanURLForBLZ(this.getBLZ()));
                if (sb.indexOf("https://") == 0) {
                    sb.delete(0, 8);
                }
            } else {
                sb = new StringBuffer(HBCIUtils.getHBCIHostForBLZ(this.getBLZ()));
            }
            this.callback.callback(this, 9, HBCIUtilsInternal.getLocMsg("HOST"), 2, sb);
            if (sb.length() == 0) {
                throw new InvalidUserDataException(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_X", HBCIUtilsInternal.getLocMsg("HOST")));
            }
            this.setHost(sb.toString());
            dataChanged = true;
        }
        if (needFilter && (this.getFilterType() == null || this.getFilterType().length() == 0)) {
            sb = new StringBuffer("Base64");
            this.callback.callback(this, 26, HBCIUtilsInternal.getLocMsg("FILTER"), 2, sb);
            if (sb.length() == 0) {
                throw new InvalidUserDataException(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_X", HBCIUtilsInternal.getLocMsg("FILTER")));
            }
            this.setFilterType(sb.toString());
            dataChanged = true;
        }
        if (needUserId && (this.getUserId() == null || this.getUserId().length() == 0)) {
            sb = new StringBuffer();
            this.callback.callback(this, 11, HBCIUtilsInternal.getLocMsg("USERID"), 2, sb);
            if (sb.length() == 0) {
                throw new InvalidUserDataException(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_X", HBCIUtilsInternal.getLocMsg("USERID")));
            }
            this.setUserId(sb.toString());
            dataChanged = true;
        }
        if (needCustomerId && (this.getStoredCustomerId() == null || this.getStoredCustomerId().length() == 0)) {
            sb = new StringBuffer(this.getCustomerId());
            this.callback.callback(this, 18, HBCIUtilsInternal.getLocMsg("CUSTOMERID"), 2, sb);
            this.setCustomerId(sb.toString());
            dataChanged = true;
        }
        return dataChanged;
    }

    @Override
    public final CommPinTan getComm() {
        if (this.comm == null) {
            this.comm = this.getCommInstance();
        }
        return this.comm;
    }

    public void unsetComm() {
        this.comm = null;
    }

    protected abstract CommPinTan getCommInstance();

    @Override
    public final Filter getCommFilter() {
        return Filter.getInstance(this.getFilterType());
    }

    @Override
    public final void closeComm() {
        if (this.comm != null) {
            this.comm.close();
            this.comm = null;
        }
    }

    @Override
    public final Properties getBPD() {
        return this.bpd;
    }

    @Override
    public final void setHBCIVersion(String hbciversion) {
        this.hbciversion = hbciversion;
    }

    @Override
    public final String getHBCIVersion() {
        return this.hbciversion != null ? this.hbciversion : "";
    }

    @Override
    public final Properties getUPD() {
        return this.upd;
    }

    @Override
    public final String getBLZ() {
        return this.blz;
    }

    @Override
    public final String getCountry() {
        return this.country;
    }

    @Override
    public final Konto[] getAccounts() {
        ArrayList<Konto> ret = new ArrayList<Konto>();
        if (this.upd != null) {
            String header;
            String number;
            int i = 0;
            while ((number = this.upd.getProperty((header = HBCIUtilsInternal.withCounter("KInfo", i)) + ".KTV.number")) != null) {
                String gvHeader;
                String code;
                Konto entry = new Konto();
                entry.blz = this.upd.getProperty(header + ".KTV.KIK.blz");
                entry.country = this.upd.getProperty(header + ".KTV.KIK.country");
                entry.number = number;
                entry.subnumber = this.upd.getProperty(header + ".KTV.subnumber");
                entry.curr = this.upd.getProperty(header + ".cur");
                entry.type = this.upd.getProperty(header + ".konto");
                entry.customerid = this.upd.getProperty(header + ".customerid");
                entry.name = this.upd.getProperty(header + ".name1");
                entry.name2 = this.upd.getProperty(header + ".name2");
                entry.bic = this.upd.getProperty(header + ".KTV.bic");
                entry.iban = this.upd.getProperty(header + ".KTV.iban");
                entry.acctype = this.upd.getProperty(header + ".acctype");
                String st = this.upd.getProperty(header + ".KLimit.limittype");
                if (st != null) {
                    Limit limit = new Limit();
                    limit.type = st.charAt(0);
                    limit.value = new Value(this.upd.getProperty(header + ".KLimit.BTG.value"), this.upd.getProperty(header + ".KLimit.BTG.curr"));
                    st = this.upd.getProperty(header + ".KLimit.limitdays");
                    if (st != null) {
                        limit.days = Integer.parseInt(st);
                    }
                }
                ArrayList<String> codes = new ArrayList<String>();
                int j = 0;
                while ((code = this.upd.getProperty((gvHeader = HBCIUtilsInternal.withCounter(header + ".AllowedGV", j)) + ".code")) != null) {
                    codes.add(code);
                    ++j;
                }
                if (!codes.isEmpty()) {
                    entry.allowedGVs = codes;
                }
                ret.add(entry);
                ++i;
            }
        }
        return ret.toArray(new Konto[ret.size()]);
    }

    @Override
    public final void fillAccountInfo(Konto account) {
        String number = HBCIUtilsInternal.stripLeadingZeroes(account.number);
        String iban = HBCIUtilsInternal.stripLeadingZeroes(account.iban);
        boolean haveNumber = number != null && number.length() != 0;
        boolean haveIBAN = iban != null && iban.length() != 0;
        Konto[] accounts = this.getAccounts();
        for (int i = 0; i < accounts.length; ++i) {
            String temp_number = HBCIUtilsInternal.stripLeadingZeroes(accounts[i].number);
            String temp_iban = HBCIUtilsInternal.stripLeadingZeroes(accounts[i].iban);
            if ((!haveNumber || !number.equals(temp_number)) && (!haveIBAN || !iban.equals(temp_iban))) continue;
            account.blz = accounts[i].blz;
            account.country = accounts[i].country;
            account.number = accounts[i].number;
            account.subnumber = accounts[i].subnumber;
            account.type = accounts[i].type;
            account.curr = accounts[i].curr;
            account.customerid = accounts[i].customerid;
            account.name = accounts[i].name;
            account.bic = accounts[i].bic;
            account.iban = accounts[i].iban;
            account.acctype = accounts[i].acctype;
            break;
        }
    }

    @Override
    public final Konto getAccount(String number) {
        Konto ret = new Konto();
        ret.number = number;
        this.fillAccountInfo(ret);
        if (ret.blz == null) {
            ret.blz = this.getBLZ();
            ret.country = this.getCountry();
            ret.customerid = this.getCustomerId();
            ret.name = this.getCustomerId();
        }
        return ret;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public final Integer getPort() {
        return this.port != null ? this.port : new Integer(0);
    }

    @Override
    public final String getFilterType() {
        return this.filterType;
    }

    @Override
    public String getUserId() {
        return this.userid;
    }

    @Override
    public final String getCustomerId(int idx) {
        String header = HBCIUtilsInternal.withCounter("KInfo", idx) + ".customerid";
        String c = this.upd != null ? this.upd.getProperty(header) : this.customerid;
        return c != null ? c : this.getUserId();
    }

    @Override
    public String getCustomerId() {
        return this.customerid != null && this.customerid.length() != 0 ? this.customerid : this.getUserId();
    }

    public String getStoredCustomerId() {
        return this.customerid;
    }

    @Override
    public String getSysId() {
        return this.sysid != null && this.sysid.length() != 0 ? this.sysid : "0";
    }

    @Override
    public final String getCID() {
        return this.cid != null ? this.cid : "";
    }

    @Override
    public final void clearInstSigKey() {
        this.setInstSigKey(null);
    }

    @Override
    public final void clearInstEncKey() {
        this.setInstEncKey(null);
    }

    @Override
    public final void clearMySigKey() {
        this.setMyPublicSigKey(null);
        this.setMyPrivateSigKey(null);
    }

    @Override
    public final void clearMyEncKey() {
        this.setMyPublicEncKey(null);
        this.setMyPrivateEncKey(null);
    }

    @Override
    public final void clearMyDigKey() {
        this.setMyPublicDigKey(null);
        this.setMyPrivateDigKey(null);
    }

    @Override
    public final String getBPDVersion() {
        String version = this.bpd != null ? this.bpd.getProperty("BPA.version") : null;
        return version != null ? version : "0";
    }

    @Override
    public final String getUPDVersion() {
        String version = this.upd != null ? this.upd.getProperty("UPA.version") : null;
        return version != null ? version : "0";
    }

    @Override
    public final String getInstName() {
        return this.bpd != null ? this.bpd.getProperty("BPA.kiname") : null;
    }

    @Override
    public int getMaxGVperMsg() {
        return this.bpd != null ? Integer.parseInt(this.bpd.getProperty("BPA.numgva")) : -1;
    }

    @Override
    public final int getMaxMsgSizeKB() {
        return this.bpd != null ? Integer.parseInt(this.bpd.getProperty("BPA.maxmsgsize", "0")) : 0;
    }

    @Override
    public final String[] getSuppLangs() {
        String[] ret = new String[]{};
        if (this.bpd != null) {
            String value;
            String header;
            ArrayList<String> temp = new ArrayList<String>();
            int i = 0;
            while ((header = HBCIUtilsInternal.withCounter("BPA.SuppLangs.lang", i)) != null && (value = this.bpd.getProperty(header)) != null) {
                temp.add(value);
                ++i;
            }
            if (temp.size() != 0) {
                ret = temp.toArray(ret);
            }
        }
        return ret;
    }

    @Override
    public final String[] getSuppVersions() {
        String[] ret = new String[]{};
        if (this.bpd != null) {
            String value;
            String header;
            ArrayList<String> temp = new ArrayList<String>();
            int i = 0;
            while ((header = HBCIUtilsInternal.withCounter("BPA.SuppVersions.version", i)) != null && (value = this.bpd.getProperty(header)) != null) {
                temp.add(value);
                ++i;
            }
            if (temp.size() != 0) {
                ret = temp.toArray(ret);
            }
        }
        return ret;
    }

    @Override
    public final String getDefaultLang() {
        String value = this.bpd != null ? this.bpd.getProperty("CommListRes.deflang") : null;
        return value != null ? value : "0";
    }

    @Override
    public final boolean canMixSecMethods() {
        String value;
        boolean ret = false;
        if (this.bpd != null && (value = this.bpd.getProperty("SecMethod.mixing")) != null && value.equals("J")) {
            ret = true;
        }
        return ret;
    }

    @Override
    public final String[][] getSuppSecMethods() {
        String[][] ret = new String[][]{};
        if (this.bpd != null) {
            String method;
            String header;
            ArrayList<String[]> temp = new ArrayList<String[]>();
            int i = 0;
            while ((header = HBCIUtilsInternal.withCounter("SecMethod.SuppSecMethods", i)) != null && (method = this.bpd.getProperty(header + ".method")) != null) {
                String version;
                String header2;
                int j = 0;
                while ((header2 = HBCIUtilsInternal.withCounter(header + ".version", j)) != null && (version = this.bpd.getProperty(header2)) != null) {
                    String[] entry = new String[]{method, version};
                    temp.add(entry);
                    ++j;
                }
                ++i;
            }
            if (temp.size() != 0) {
                ret = (String[][])temp.toArray((T[])ret);
            }
        }
        return ret;
    }

    @Override
    public final String[][] getSuppCompMethods() {
        String[][] ret = new String[][]{};
        if (this.bpd != null) {
            String method;
            String header;
            ArrayList<String[]> temp = new ArrayList<String[]>();
            int i = 0;
            while ((header = HBCIUtilsInternal.withCounter("CompMethod.SuppCompMethods", i)) != null && (method = this.bpd.getProperty(header + ".func")) != null) {
                String version = this.bpd.getProperty(header + ".version");
                String[] entry = new String[]{method, version};
                temp.add(entry);
                ++i;
            }
            if (temp.size() != 0) {
                ret = (String[][])temp.toArray((T[])ret);
            }
        }
        return ret;
    }

    @Override
    public final String getLang() {
        String value = this.bpd != null ? this.bpd.getProperty("CommListRes.deflang") : null;
        return value != null ? value : "0";
    }

    @Override
    public final Long getSigId() {
        return this.sigid != null ? this.sigid : new Long(1L);
    }

    @Override
    public final void clearBPD() {
        this.setBPD(null);
    }

    @Override
    public void setBPD(Properties bpd) {
        this.bpd = bpd;
    }

    @Override
    public final void clearUPD() {
        this.setUPD(null);
    }

    @Override
    public final void setUPD(Properties upd) {
        this.upd = upd;
    }

    @Override
    public final void setCountry(String country) {
        this.country = country;
    }

    @Override
    public final void setBLZ(String blz) {
        LogFilter.getInstance().addSecretData(blz, "X", 3);
        this.blz = blz;
    }

    @Override
    public final void setHost(String host) {
        this.host = host;
    }

    @Override
    public final void setPort(Integer port) {
        this.port = port;
    }

    @Override
    public final void setFilterType(String filter) {
        this.filterType = filter;
    }

    @Override
    public final void setUserId(String userid) {
        LogFilter.getInstance().addSecretData(userid, "X", 2);
        this.userid = userid;
    }

    @Override
    public final void setCustomerId(String customerid) {
        LogFilter.getInstance().addSecretData(customerid, "X", 2);
        this.customerid = customerid;
    }

    @Override
    public final void setSigId(Long sigid) {
        this.sigid = sigid;
    }

    @Override
    public final void setSysId(String sysid) {
        this.sysid = sysid;
    }

    @Override
    public final void setCID(String cid) {
        LogFilter.getInstance().addSecretData(cid, "X", 2);
        this.cid = cid;
    }

    @Override
    public void incSigId() {
        this.setSigId(new Long(this.getSigId() + 1L));
    }

    @Override
    public final boolean onlyBPDGVs() {
        return this.getUPD().getProperty("UPA.usage").equals("0");
    }

    public static HBCIPassport getInstance(HBCICallback callback, Properties properties, String name, Object init) {
        if (name == null) {
            throw new NullPointerException("name of passport implementation must not be null");
        }
        String className = "org.kapott.hbci.passport.HBCIPassport" + name;
        try {
            if (init == null) {
                init = name;
            }
            HBCIUtils.log("creating new instance of a " + name + " passport", 4);
            Class<?> cl = Class.forName(className);
            Constructor<?> con = cl.getConstructor(Properties.class, HBCICallback.class, Object.class);
            HBCIPassport p = (HBCIPassport)con.newInstance(properties, callback, init);
            return p;
        }
        catch (ClassNotFoundException e) {
            throw new InvalidUserDataException("*** No passport implementation '" + name + "' found - there must be a class " + className);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof HBCI_Exception) {
                throw (HBCI_Exception)cause;
            }
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSPORT_INST", name), ite);
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSPORT_INST", name), e);
        }
    }

    public static HBCIPassport getInstance(HBCICallback callback, Properties properties, Object init) {
        String passportName = properties.getProperty("client.passport.default");
        if (passportName == null) {
            throw new InvalidUserDataException(HBCIUtilsInternal.getLocMsg("EXCMSG_NODEFPASS"));
        }
        return AbstractHBCIPassport.getInstance(callback, properties, passportName, init);
    }

    public static HBCIPassport getInstance(HBCICallback callback, Properties properties, String name) {
        return AbstractHBCIPassport.getInstance(callback, properties, name, null);
    }

    public static HBCIPassport getInstance(HBCICallback callback, Properties properties) {
        return AbstractHBCIPassport.getInstance(callback, properties, null);
    }

    @Override
    public void close() {
        this.closeComm();
    }

    protected SecretKey calculatePassportKey(boolean forSaving) {
        try {
            StringBuffer passphrase = new StringBuffer();
            this.callback.callback(this, forSaving ? 22 : 21, forSaving ? HBCIUtilsInternal.getLocMsg("CALLB_NEED_PASS_NEW") : HBCIUtilsInternal.getLocMsg("CALLB_NEED_PASS"), 1, passphrase);
            if (passphrase.length() == 0) {
                throw new InvalidUserDataException(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSZERO"));
            }
            LogFilter.getInstance().addSecretData(passphrase.toString(), "X", 1);
            SecretKeyFactory fac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            PBEKeySpec keyspec = new PBEKeySpec(passphrase.toString().toCharArray());
            SecretKey passportKey = fac.generateSecret(keyspec);
            keyspec.clearPassword();
            passphrase = null;
            return passportKey;
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSPORT_KEYCALCERR"), ex);
        }
    }

    @Override
    public Properties getParamSegmentNames() {
        Properties ret = new Properties();
        Enumeration<?> e = this.bpd.propertyNames();
        while (e.hasMoreElements()) {
            String knownVersion;
            String version;
            String key = (String)e.nextElement();
            if (!key.startsWith("Params") || !key.endsWith(".SegHead.code")) continue;
            int dotPos = key.indexOf(46);
            int dotPos2 = key.indexOf(46, dotPos + 1);
            String gvname = key.substring(dotPos + 1, dotPos2);
            int len = gvname.length();
            int versionPos = -1;
            for (int i = len - 1; i >= 0; --i) {
                char ch = gvname.charAt(i);
                if (ch >= '0' && ch <= '9') continue;
                versionPos = i + 1;
                break;
            }
            if ((version = gvname.substring(versionPos)).length() == 0 || (knownVersion = (String)ret.get(gvname = gvname.substring(0, versionPos - 3))) != null && Integer.parseInt(version) <= Integer.parseInt(knownVersion)) continue;
            ret.setProperty(gvname, version);
        }
        return ret;
    }

    @Override
    public Properties getJobRestrictions(String specname) {
        char ch;
        int versionPos = specname.length() - 1;
        while ((ch = specname.charAt(versionPos)) >= '0' && ch <= '9') {
            --versionPos;
        }
        return this.getJobRestrictions(specname.substring(0, versionPos + 1), specname.substring(versionPos + 1));
    }

    @Override
    public Properties getJobRestrictions(String gvname, String version) {
        Properties result = new Properties();
        String searchstring = gvname + "Par" + version;
        Enumeration<?> e = this.bpd.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("Params") || key.indexOf("." + searchstring + ".Par") == -1) continue;
            int searchIdx = key.indexOf(searchstring);
            result.setProperty(key.substring(key.indexOf(".", searchIdx + searchstring.length() + 4) + 1), this.bpd.getProperty(key));
        }
        return result;
    }

    @Override
    public void setPersistentData(String id, Object o) {
        if (o != null) {
            this.persistentData.put(id, o);
        } else {
            this.persistentData.remove(id);
        }
    }

    public void setPersistentData(Hashtable<String, Object> persistentData) {
        this.persistentData = persistentData;
    }

    @Override
    public Object getPersistentData(String id) {
        return this.persistentData.get(id);
    }

    public Hashtable<String, Object> getPersistentData() {
        return this.persistentData;
    }

    @Override
    public void syncSigId() {
        this.setSigId(new Long("-1"));
    }

    @Override
    public void syncSysId() {
        this.setSysId("0");
    }

    @Override
    public void changePassphrase() {
        this.resetPassphrase();
        this.saveChanges();
    }

    @Override
    public final void setClientData(String id, Object o) {
        this.setPersistentData("client_" + id, o);
    }

    @Override
    public final Object getClientData(String id) {
        return this.getPersistentData("client_" + id);
    }

    public boolean isAnonymous() {
        return false;
    }

    protected void setParamHeader(String paramHeader) {
        this.paramHeader = paramHeader;
    }

    protected String getParamHeader() {
        return this.paramHeader;
    }

    @Override
    public void setParentHandlerData(IHandlerData handler) {
        this.parentHandlerData = handler;
    }

    @Override
    public IHandlerData getParentHandlerData() {
        return this.parentHandlerData;
    }

    public static byte[] checkForCryptDataSize(byte[] buffer, int size) {
        byte[] result = buffer;
        if (buffer.length != size) {
            HBCIUtils.log("checking for crypted_data_length==" + size + "; current length is " + buffer.length, 4);
            if (buffer.length > size) {
                int diff = buffer.length - size;
                boolean ok = true;
                for (int i = 0; i < diff; ++i) {
                    if (buffer[i] == 0) continue;
                    HBCIUtils.log("byte " + i + " in crypted_data is not zero, but it should be zero - please contact the author", 2);
                    ok = false;
                }
                if (ok) {
                    HBCIUtils.log("removing " + diff + " unnecessary null-bytes from crypted_data", 4);
                    result = new byte[size];
                    System.arraycopy(buffer, diff, result, 0, size);
                }
            } else if (buffer.length < size) {
                int diff = size - buffer.length;
                HBCIUtils.log("prepending " + diff + " null bytes to crypted_data", 2);
                result = new byte[size];
                Arrays.fill(result, (byte)0);
                System.arraycopy(buffer, 0, result, diff, buffer.length);
            }
        }
        return result;
    }

    @Override
    public boolean postInitResponseHook(HBCIMsgStatus msgStatus) {
        return false;
    }

    @Override
    public void beforeCustomDialogHook(HBCIDialog dialog) {
    }

    @Override
    public void afterCustomDialogInitHook(List<List<HBCIJobImpl>> msgs) {
    }

    @Override
    public int getMaxGVSegsPerMsg() {
        return 0;
    }

    protected void safeReplace(File origFile, File tmpFile) {
        HBCIUtils.log("saving passport file " + origFile, 4);
        if (origFile.exists()) {
            HBCIUtils.log("deleting old passport file " + origFile, 4);
            if (!origFile.delete()) {
                HBCIUtils.log("delete method for " + origFile + " returned false", 1);
            }
        }
        int retry = 0;
        while (origFile.exists() && retry++ < 20) {
            try {
                HBCIUtils.log("wait a little bit, maybe another thread (antivirus scanner) holds a lock, file still exists", 2);
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                HBCIUtils.log("interrupted", 2);
                break;
            }
            if (origFile.exists()) continue;
            HBCIUtils.log("passport file now gone: " + origFile, 3);
            break;
        }
        if (origFile.exists()) {
            throw new HBCI_Exception("could not delete " + origFile);
        }
        retry = 0;
        HBCIUtils.log("renaming " + tmpFile.getName() + " to " + origFile.getName(), 4);
        while (!origFile.exists() && retry++ < 20) {
            if (!tmpFile.renameTo(origFile)) {
                HBCIUtils.log("rename method for " + tmpFile + " to " + origFile + " returned false", 1);
            }
            if (origFile.exists()) {
                HBCIUtils.log("new passport file now exists: " + origFile, 4);
                break;
            }
            try {
                HBCIUtils.log("wait a little bit, maybe another thread (antivirus scanner) holds a lock, file still not renamed", 2);
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                HBCIUtils.log("interrupted", 2);
                break;
            }
        }
        if (!origFile.exists()) {
            throw new HBCI_Exception("could not rename " + tmpFile.getName() + " to " + origFile.getName());
        }
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public HBCICallback getCallback() {
        return this.callback;
    }
}

