/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InfoPointConnector {
    private URL url;

    public InfoPointConnector() {
        String _url = HBCIUtils.getParam("infoPoint.url", "http://hbci4java.kapott.org/infoPoint");
        HBCIUtils.log("configuring InfoPointer-Server with " + _url, 3);
        try {
            this.url = new URL(_url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private Element properties2XML(Document doc, String elemName, Properties props) {
        Element elem = doc.createElement(elemName);
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Element paramElem = doc.createElement("param");
            paramElem.setAttribute("name", key);
            paramElem.setAttribute("value", props.getProperty(key));
            elem.appendChild(paramElem);
        }
        return elem;
    }

    private String prepareXMLDocument(String xmlType, Properties passportData, Properties msgData) {
        try {
            String bpd_st;
            Element rootElem;
            Document doc;
            block7: {
                int startpos;
                DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
                fac.setIgnoringComments(true);
                fac.setValidating(false);
                DocumentBuilder builder = fac.newDocumentBuilder();
                doc = builder.newDocument();
                rootElem = doc.createElement(xmlType);
                doc.appendChild(rootElem);
                Element passElem = this.properties2XML(doc, "passport", passportData);
                rootElem.appendChild(passElem);
                Properties sentData = new Properties();
                Enumeration<Object> e = msgData.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (!key.startsWith("orig_") || key.indexOf(".ProcPrep.") == -1) continue;
                    String value = msgData.getProperty(key);
                    if (key.endsWith(".lang")) {
                        sentData.setProperty("language", value);
                        continue;
                    }
                    if (key.endsWith(".prodName")) {
                        sentData.setProperty("productName", value);
                        continue;
                    }
                    if (!key.endsWith(".prodVersion")) continue;
                    sentData.setProperty("productVersion", value);
                }
                Element sentElem = this.properties2XML(doc, "sent", sentData);
                rootElem.appendChild(sentElem);
                String msg_st = msgData.getProperty("_msg");
                int len = msg_st.length();
                int posi = startpos = msg_st.indexOf("'HIBPA:") + 1;
                int prevDelimiter = 39;
                List<String> bpdSegCodes = Arrays.asList("HIBPA", "HIKOM", "HISHV", "HIKPV");
                bpd_st = "";
                while (true) {
                    String segCode;
                    int delimpos = HBCIUtilsInternal.getPosiOfNextDelimiter(msg_st, posi);
                    if (!(prevDelimiter != 39 || bpdSegCodes.contains(segCode = msg_st.substring(posi, delimpos)) || segCode.length() == 6 && segCode.charAt(1) == 'I' && segCode.charAt(5) == 'S')) {
                        bpd_st = msg_st.substring(startpos, posi);
                        break block7;
                    }
                    if (delimpos >= len) break;
                    prevDelimiter = msg_st.charAt(delimpos);
                    posi = delimpos + 1;
                }
                HBCIUtils.log("reached end of msg without finding the end of BPD - message seems to be broken", 1);
                bpd_st = msg_st.substring(startpos);
            }
            Element bpdElem = doc.createElement("bpd");
            bpdElem.setAttribute("encoding", "base64");
            rootElem.appendChild(bpdElem);
            String bpd_encoded = HBCIUtils.encodeBase64(bpd_st.getBytes("ISO-8859-1"));
            bpdElem.appendChild(doc.createTextNode(bpd_encoded));
            TransformerFactory tfac = TransformerFactory.newInstance();
            Transformer trans = tfac.newTransformer();
            trans.setOutputProperty("method", "xml");
            trans.setOutputProperty("omit-xml-declaration", "no");
            trans.setOutputProperty("encoding", "ISO-8859-1");
            trans.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream xmlStream = new ByteArrayOutputStream();
            StreamResult target = new StreamResult(xmlStream);
            trans.transform(source, target);
            return xmlStream.toString("ISO-8859-1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void sendDataToServer(HBCIPassportInternal passport, String data) {
        StringBuffer retData = new StringBuffer(data);
        HBCIUtilsInternal.getCallback().callback(passport, 31, HBCIUtilsInternal.getLocMsg("CALLB_INFOPOINT_ACK"), 3, retData);
        if (retData.length() == 0) {
            HBCIUtils.log("sending data about successfully received BPD to InfoPoint server", 3);
            HBCIUtilsInternal.getCallback().status((HBCIPassport)passport, 29, data);
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)this.url.openConnection();
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "text/xml");
                conn.connect();
                OutputStream out = conn.getOutputStream();
                out.write(data.getBytes("ISO-8859-1"));
                out.flush();
                conn.getResponseCode();
                conn.disconnect();
            }
            catch (Exception e) {
                HBCIUtils.log(e);
            }
        } else {
            HBCIUtils.log("data NOT sent because of missing user confirmation", 3);
        }
    }

    private Properties preparePassportData(HBCIPassportInternal passport) {
        Properties passportData = new Properties();
        passportData.setProperty("type", passport.getPassportTypeName());
        passportData.setProperty("country", passport.getCountry());
        passportData.setProperty("blz", passport.getBLZ());
        passportData.setProperty("host", passport.getHost());
        passportData.setProperty("filter", passport.getFilterType());
        String version = passport.getHBCIVersion();
        passportData.setProperty("hbciVersion", version.equals("plus") ? "220" : version);
        return passportData;
    }

    public void sendBPD(HBCIPassportInternal passport, Properties msgData) {
        Properties passportData = this.preparePassportData(passport);
        String xmlData = this.prepareXMLDocument("bpdReceived", passportData, msgData);
        this.sendDataToServer(passport, xmlData);
    }

    public void sendPublicKeys(HBCIPassportInternal passport, Properties msgData) {
    }
}

