/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.InfoPointConnector;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.slf4j.LoggerFactory;

public class HBCIUtilsInternal {
    public static Properties blzs;
    public static Map<String, BankInfo> banks;
    private static InfoPointConnector infoPointConnector;

    public static String bigDecimal2String(BigDecimal value) {
        DecimalFormat format = new DecimalFormat("0.##");
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        format.setDecimalFormatSymbols(symbols);
        format.setDecimalSeparatorAlwaysShown(false);
        return format.format(value);
    }

    public static String getBLZData(String blz) {
        return blz != null ? blzs.getProperty(blz, "|||||") : "|||||";
    }

    public static String getNthToken(String st, int idx) {
        String[] parts = st.split("\\|");
        String ret = null;
        ret = idx - 1 < parts.length ? parts[idx - 1] : "";
        return ret;
    }

    public static String getAlgForBLZ(String blz) {
        BankInfo info = banks.get(blz);
        if (info == null) {
            return "";
        }
        return info.getChecksumMethod() != null ? info.getChecksumMethod() : "";
    }

    public static String getLocMsg(String key) {
        try {
            return ResourceBundle.getBundle("hbci4java-messages", Locale.getDefault()).getString(key);
        }
        catch (MissingResourceException re) {
            LoggerFactory.getLogger(HBCIUtilsInternal.class).debug(re.getMessage(), (Throwable)re);
            return key;
        }
    }

    public static String getLocMsg(String key, Object o) {
        return HBCIUtilsInternal.getLocMsg(key, new Object[]{o});
    }

    public static String getLocMsg(String key, Object[] o) {
        return MessageFormat.format(HBCIUtilsInternal.getLocMsg(key), o);
    }

    public static boolean ignoreError(HBCIPassport passport, String paramName, String msg) {
        boolean ret = false;
        String paramValue = "no";
        if (passport != null) {
            paramValue = passport.getProperties().getProperty(paramName, "no");
        }
        if (paramValue.equals("yes")) {
            LoggerFactory.getLogger(HBCIUtilsInternal.class).info(msg, (Object)1);
            LoggerFactory.getLogger(HBCIUtilsInternal.class).info("ignoring error because param " + paramName + "=yes", (Object)1);
            ret = true;
        } else if (paramValue.equals("callback")) {
            StringBuffer sb = new StringBuffer();
            HBCIUtilsInternal.getCallback().callback(passport, 20, msg, 3, sb);
            if (sb.length() == 0) {
                LoggerFactory.getLogger(HBCIUtilsInternal.class).info(msg, (Object)1);
                LoggerFactory.getLogger(HBCIUtilsInternal.class).info("ignoring error because param " + paramName + "=callback", (Object)1);
                ret = true;
            }
        }
        return ret;
    }

    public static long string2Long(String st, long factor) {
        BigDecimal result = new BigDecimal(st);
        result = result.multiply(new BigDecimal(factor));
        return result.longValue();
    }

    public static String withCounter(String st, int idx) {
        return st + (idx != 0 ? "_" + Integer.toString(idx + 1) : "");
    }

    public static String[] getNextRelativePathElem(String currentPath, String targetPath) {
        String[] ret = null;
        if (targetPath.startsWith(currentPath + ".")) {
            String nextPath;
            ret = new String[2];
            String subPath = targetPath.substring(currentPath.length() + 1);
            int dotPosi = subPath.indexOf(46);
            if (dotPosi == -1) {
                dotPosi = subPath.length();
            }
            String nextName = nextPath = subPath.substring(0, dotPosi);
            int underscorePosi = nextPath.lastIndexOf(95);
            if (underscorePosi != -1) {
                nextName = nextPath.substring(0, underscorePosi);
            }
            ret[0] = nextName;
            ret[1] = nextPath;
        }
        return ret;
    }

    public static int getPosiOfNextDelimiter(String st, int posi) {
        int len = st.length();
        boolean quoting = false;
        while (posi < len) {
            char ch = st.charAt(posi);
            if (!quoting) {
                if (ch == '?') {
                    quoting = true;
                } else if (ch == '@') {
                    int endpos = st.indexOf(64, posi + 1);
                    String binlen_st = st.substring(posi + 1, endpos);
                    int binlen = Integer.parseInt(binlen_st);
                    posi += binlen_st.length() + 1 + binlen;
                } else if (ch == '\'' || ch == '+' || ch == ':') {
                    break;
                }
            } else {
                quoting = false;
            }
            ++posi;
        }
        return posi;
    }

    public static String ba2string(byte[] ba) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < ba.length; ++i) {
            String st;
            int x = ba[i];
            if (x < 0) {
                x += 256;
            }
            if ((st = Integer.toString(x, 16)).length() == 1) {
                st = "0" + st;
            }
            ret.append(st + " ");
        }
        return ret.toString();
    }

    public static String stripLeadingZeroes(String st) {
        String ret = null;
        if (st != null) {
            int start;
            int l = st.length();
            for (start = 0; start < l && st.charAt(start) == '0'; ++start) {
            }
            ret = st.substring(start);
        }
        return ret;
    }

    private static InfoPointConnector getInfoPointConnector() {
        if (infoPointConnector == null) {
            infoPointConnector = new InfoPointConnector();
        }
        return infoPointConnector;
    }

    public static void infoPointSendBPD(HBCIPassportInternal passport, Properties msgData) {
        if (HBCIUtils.getParam("infoPoint.enabled", "0").equals("1")) {
            HBCIUtilsInternal.getInfoPointConnector().sendBPD(passport, msgData);
        }
    }

    public static void infoPointSendPublicKeys(HBCIPassportInternal passport, Properties msgData) {
        if (HBCIUtils.getParam("infoPoint.enabled", "0").equals("1")) {
            HBCIUtilsInternal.getInfoPointConnector().sendPublicKeys(passport, msgData);
        }
    }

    public static HBCICallback getCallback() {
        return null;
    }

    static {
        banks = null;
    }
}

