/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.spec.RSAPublicKeySpec;
import java.util.Enumeration;
import java.util.Properties;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.NeedKeyAckException;
import org.kapott.hbci.exceptions.ProcessException;
import org.kapott.hbci.manager.HBCIInstitute;
import org.kapott.hbci.manager.HBCIKernelImpl;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.IHandlerData;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;

public final class HBCIUser
implements IHandlerData {
    private HBCIPassportInternal passport;
    private HBCIKernelImpl kernel;

    public HBCIUser(HBCIKernelImpl kernel, HBCIPassportInternal passport, boolean forceAsParent) {
        this.kernel = kernel;
        if (forceAsParent || this.kernel.getParentHandlerData() == null) {
            this.kernel.setParentHandlerData(this);
        }
        this.passport = passport;
        if (forceAsParent || this.passport.getParentHandlerData() == null) {
            this.passport.setParentHandlerData(this);
        }
    }

    private void doDialogEnd(String dialogid, String msgnum, boolean signIt, boolean cryptIt, boolean needCrypt) {
        this.passport.getCallback().status((HBCIPassport)this.passport, 19, null);
        this.kernel.rawNewMsg("DialogEnd");
        this.kernel.rawSet("MsgHead.dialogid", dialogid);
        this.kernel.rawSet("MsgHead.msgnum", msgnum);
        this.kernel.rawSet("DialogEndS.dialogid", dialogid);
        this.kernel.rawSet("MsgTail.msgnum", msgnum);
        HBCIMsgStatus status = this.kernel.rawDoIt(signIt, cryptIt, true, needCrypt);
        this.passport.getCallback().status((HBCIPassport)this.passport, 20, status);
        if (!status.isOK()) {
            HBCIUtils.log("dialog end failed: " + status.getErrorString(), 1);
            String msg = HBCIUtilsInternal.getLocMsg("ERR_INST_ENDFAILED");
            if (!HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreDialogEndErrors", msg + ": " + status.getErrorString())) {
                throw new ProcessException(msg, status);
            }
        }
    }

    private void sendAndActivateNewUserKeys(HBCIKey[] sigKey, HBCIKey[] encKey) {
        block23: {
            try {
                HBCIUtils.log("sending user keys to institute", 3);
                String country = this.passport.getCountry();
                String blz = this.passport.getBLZ();
                String[] exponent = new String[2];
                String[] modulus = new String[2];
                for (int i = 0; i < 2; ++i) {
                    int startpos;
                    KeyFactory fac = KeyFactory.getInstance("RSA");
                    RSAPublicKeySpec spec = null;
                    if (i == 0) {
                        spec = fac.getKeySpec(sigKey[0].key, RSAPublicKeySpec.class);
                    } else if (i == 1) {
                        spec = fac.getKeySpec(encKey[0].key, RSAPublicKeySpec.class);
                    }
                    byte[] ba = spec.getPublicExponent().toByteArray();
                    int len = ba.length;
                    for (startpos = 0; startpos < len && ba[startpos] == 0; ++startpos) {
                    }
                    exponent[i] = new String(ba, startpos, len - startpos, "ISO-8859-1");
                    ba = spec.getModulus().toByteArray();
                    len = ba.length;
                    for (startpos = 0; startpos < len && ba[startpos] == 0; ++startpos) {
                    }
                    modulus[i] = new String(ba, startpos, len - startpos, "ISO-8859-1");
                }
                if (!this.passport.hasMySigKey()) {
                    this.passport.getCallback().status((HBCIPassport)this.passport, 7, null);
                    this.passport.setSigId(new Long(1L));
                    this.kernel.rawNewMsg("SendKeys");
                    this.kernel.rawSet("Idn.KIK.blz", blz);
                    this.kernel.rawSet("Idn.KIK.country", country);
                    this.kernel.rawSet("Idn.customerid", this.passport.getCustomerId());
                    this.kernel.rawSet("Idn.sysid", this.passport.getSysId());
                    this.kernel.rawSet("KeyChange.KeyName.KIK.blz", blz);
                    this.kernel.rawSet("KeyChange.KeyName.KIK.country", country);
                    this.kernel.rawSet("KeyChange.KeyName.userid", this.passport.getUserId());
                    this.kernel.rawSet("KeyChange.KeyName.keynum", sigKey[0].num);
                    this.kernel.rawSet("KeyChange.KeyName.keytype", "S");
                    this.kernel.rawSet("KeyChange.KeyName.keyversion", sigKey[0].version);
                    this.kernel.rawSet("KeyChange.SecProfile.method", this.passport.getProfileMethod());
                    this.kernel.rawSet("KeyChange.SecProfile.version", this.passport.getProfileVersion());
                    this.kernel.rawSet("KeyChange.PubKey.mode", "16");
                    this.kernel.rawSet("KeyChange.PubKey.exponent", "B" + exponent[0]);
                    this.kernel.rawSet("KeyChange.PubKey.modulus", "B" + modulus[0]);
                    this.kernel.rawSet("KeyChange.PubKey.usage", "6");
                    this.kernel.rawSet("KeyChange_2.KeyName.KIK.blz", blz);
                    this.kernel.rawSet("KeyChange_2.KeyName.KIK.country", country);
                    this.kernel.rawSet("KeyChange_2.KeyName.userid", this.passport.getUserId());
                    this.kernel.rawSet("KeyChange_2.KeyName.keynum", encKey[0].num);
                    this.kernel.rawSet("KeyChange_2.KeyName.keytype", "V");
                    this.kernel.rawSet("KeyChange_2.KeyName.keyversion", encKey[0].version);
                    this.kernel.rawSet("KeyChange_2.SecProfile.method", this.passport.getProfileMethod());
                    this.kernel.rawSet("KeyChange_2.SecProfile.version", this.passport.getProfileVersion());
                    this.kernel.rawSet("KeyChange_2.PubKey.mode", "16");
                    this.kernel.rawSet("KeyChange_2.PubKey.exponent", "B" + exponent[1]);
                    this.kernel.rawSet("KeyChange_2.PubKey.modulus", "B" + modulus[1]);
                    this.kernel.rawSet("KeyChange_2.PubKey.usage", "5");
                    this.passport.setMyPublicSigKey(sigKey[0]);
                    this.passport.setMyPrivateSigKey(sigKey[1]);
                    this.passport.setMyPublicEncKey(encKey[0]);
                    this.passport.setMyPrivateEncKey(encKey[1]);
                    this.passport.saveChanges();
                    HBCIMsgStatus ret = this.kernel.rawDoIt(true, true, true, false);
                    this.passport.postInitResponseHook(ret);
                    Properties result = ret.getData();
                    this.passport.getCallback().status((HBCIPassport)this.passport, 8, ret);
                    if (!ret.isOK()) {
                        if (!ret.hasExceptions()) {
                            HBCIUtils.log("deleting locally generated user keys", 2);
                            this.passport.clearMySigKey();
                            this.passport.clearMyEncKey();
                            this.passport.clearMyDigKey();
                            this.passport.saveChanges();
                        } else {
                            HBCIUtils.log("keys have not been thrown away", 2);
                        }
                        throw new ProcessException(HBCIUtilsInternal.getLocMsg("EXCMSG_SENDKEYERR"), ret);
                    }
                    try {
                        this.doDialogEnd(result.getProperty("MsgHead.dialogid"), "2", false, true, false);
                    }
                    catch (Exception e) {
                        HBCIUtils.log(e);
                    }
                    this.triggerNewKeysEvent();
                    break block23;
                }
                this.passport.getCallback().status((HBCIPassport)this.passport, 17, null);
                HBCIMsgStatus ret = null;
                boolean restarted = false;
                while (true) {
                    this.kernel.rawNewMsg("DialogInit");
                    this.kernel.rawSet("Idn.KIK.blz", blz);
                    this.kernel.rawSet("Idn.KIK.country", country);
                    this.kernel.rawSet("Idn.customerid", this.passport.getCustomerId());
                    this.kernel.rawSet("Idn.sysid", this.passport.getSysId());
                    String sysstatus = this.passport.getSysStatus();
                    this.kernel.rawSet("Idn.sysStatus", sysstatus);
                    this.kernel.rawSet("ProcPrep.BPD", this.passport.getBPDVersion());
                    this.kernel.rawSet("ProcPrep.UPD", this.passport.getUPDVersion());
                    this.kernel.rawSet("ProcPrep.lang", this.passport.getLang());
                    this.kernel.rawSet("ProcPrep.prodName", HBCIUtils.getParam("client.product.name", "HBCI4Java"));
                    this.kernel.rawSet("ProcPrep.prodVersion", HBCIUtils.getParam("client.product.version", "2.5"));
                    ret = this.kernel.rawDoIt(true, true, true, true);
                    boolean need_restart = this.passport.postInitResponseHook(ret);
                    if (!need_restart) break;
                    HBCIUtils.log("for some reason we have to restart this dialog", 3);
                    if (restarted) {
                        HBCIUtils.log("this dialog already has been restarted once - to avoid endless loops we stop here", 2);
                        throw new HBCI_Exception("*** restart loop - aborting");
                    }
                    restarted = true;
                }
                Properties result = ret.getData();
                if (!ret.isOK()) {
                    throw new ProcessException(HBCIUtilsInternal.getLocMsg("EXCMSG_GETUPDFAIL"), ret);
                }
                HBCIInstitute inst = new HBCIInstitute(this.kernel, this.passport, false);
                inst.updateBPD(result);
                this.updateUPD(result);
                this.passport.saveChanges();
                this.passport.getCallback().status((HBCIPassport)this.passport, 18, new Object[]{ret, result.getProperty("MsgHead.dialogid")});
                this.passport.getCallback().status((HBCIPassport)this.passport, 7, null);
                this.kernel.rawNewMsg("ChangeKeys");
                this.kernel.rawSet("MsgHead.dialogid", result.getProperty("MsgHead.dialogid"));
                this.kernel.rawSet("MsgHead.msgnum", "2");
                this.kernel.rawSet("MsgTail.msgnum", "2");
                this.kernel.rawSet("KeyChange.KeyName.KIK.blz", blz);
                this.kernel.rawSet("KeyChange.KeyName.KIK.country", country);
                this.kernel.rawSet("KeyChange.KeyName.userid", this.passport.getUserId());
                this.kernel.rawSet("KeyChange.KeyName.keynum", sigKey[0].num);
                this.kernel.rawSet("KeyChange.KeyName.keytype", "S");
                this.kernel.rawSet("KeyChange.KeyName.keyversion", sigKey[0].version);
                this.kernel.rawSet("KeyChange.SecProfile.method", this.passport.getProfileMethod());
                this.kernel.rawSet("KeyChange.SecProfile.version", this.passport.getProfileVersion());
                this.kernel.rawSet("KeyChange.PubKey.mode", "16");
                this.kernel.rawSet("KeyChange.PubKey.exponent", "B" + exponent[0]);
                this.kernel.rawSet("KeyChange.PubKey.modulus", "B" + modulus[0]);
                this.kernel.rawSet("KeyChange.PubKey.usage", "6");
                this.kernel.rawSet("KeyChange_2.KeyName.KIK.blz", blz);
                this.kernel.rawSet("KeyChange_2.KeyName.KIK.country", country);
                this.kernel.rawSet("KeyChange_2.KeyName.userid", this.passport.getUserId());
                this.kernel.rawSet("KeyChange_2.KeyName.keynum", encKey[0].num);
                this.kernel.rawSet("KeyChange_2.KeyName.keytype", "V");
                this.kernel.rawSet("KeyChange_2.KeyName.keyversion", encKey[0].version);
                this.kernel.rawSet("KeyChange_2.SecProfile.method", this.passport.getProfileMethod());
                this.kernel.rawSet("KeyChange_2.SecProfile.version", this.passport.getProfileVersion());
                this.kernel.rawSet("KeyChange_2.PubKey.mode", "16");
                this.kernel.rawSet("KeyChange_2.PubKey.exponent", "B" + exponent[1]);
                this.kernel.rawSet("KeyChange_2.PubKey.modulus", "B" + modulus[1]);
                this.kernel.rawSet("KeyChange_2.PubKey.usage", "5");
                HBCIKey[] oldEncKeys = new HBCIKey[]{this.passport.getMyPublicEncKey(), this.passport.getMyPrivateEncKey()};
                this.passport.setMyPublicEncKey(encKey[0]);
                this.passport.setMyPrivateEncKey(encKey[1]);
                this.passport.saveChanges();
                ret = this.kernel.rawDoIt(true, true, true, true);
                if (!ret.isOK()) {
                    if (!ret.hasExceptions()) {
                        HBCIUtils.log("deleting locally generated user keys", 2);
                        this.passport.setMyPublicEncKey(oldEncKeys[0]);
                        this.passport.setMyPrivateEncKey(oldEncKeys[1]);
                        this.passport.saveChanges();
                    } else {
                        HBCIUtils.log("keys have not been thrown away", 2);
                    }
                    throw new ProcessException(HBCIUtilsInternal.getLocMsg("EXCMSG_SENDKEYERR"), ret);
                }
                this.passport.setSigId(new Long(1L));
                this.passport.setMyPublicSigKey(sigKey[0]);
                this.passport.setMyPrivateSigKey(sigKey[1]);
                this.passport.saveChanges();
                result = ret.getData();
                this.passport.getCallback().status((HBCIPassport)this.passport, 8, ret);
                this.doDialogEnd(result.getProperty("MsgHead.dialogid"), "3", true, true, true);
            }
            catch (Exception e) {
                throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_SENDABORT"), e);
            }
            finally {
                this.passport.closeComm();
            }
        }
    }

    private void triggerNewKeysEvent() {
        this.passport.getCallback().callback(this.passport, 13, HBCIUtilsInternal.getLocMsg("CALLB_NEW_USER_KEYS"), 0, new StringBuffer());
        throw new NeedKeyAckException();
    }

    public void manuallySetNewKeys(KeyPair sigKey, KeyPair encKey) {
        HBCIKey[] newEncKey;
        HBCIKey[] newSigKey;
        if (this.passport.needUserKeys()) {
            newSigKey = null;
            newEncKey = null;
            try {
                HBCIUtils.log("manually setting new user keys", 3);
                String blz = this.passport.getBLZ();
                String country = this.passport.getCountry();
                String userid = this.passport.getUserId();
                newSigKey = new HBCIKey[2];
                newEncKey = new HBCIKey[2];
                for (int i = 0; i < 2; ++i) {
                    String num;
                    if (i == 0) {
                        num = this.passport.hasMySigKey() ? this.passport.getMyPublicSigKey().num : "0";
                        num = Integer.toString(Integer.parseInt(num) + 1);
                        newSigKey[0] = new HBCIKey(country, blz, userid, num, "1", sigKey.getPublic());
                        newSigKey[1] = new HBCIKey(country, blz, userid, num, "1", sigKey.getPrivate());
                        continue;
                    }
                    num = this.passport.hasMyEncKey() ? this.passport.getMyPublicEncKey().num : "0";
                    num = Integer.toString(Integer.parseInt(num) + 1);
                    newEncKey[0] = new HBCIKey(country, blz, userid, num, "1", encKey.getPublic());
                    newEncKey[1] = new HBCIKey(country, blz, userid, num, "1", encKey.getPrivate());
                }
            }
            catch (Exception ex) {
                throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_GENKEYS_ERR"), ex);
            }
        } else {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_USRKEYS_UNSUPP"));
        }
        this.sendAndActivateNewUserKeys(newSigKey, newEncKey);
    }

    public void fetchSysId() {
        try {
            this.passport.getCallback().status((HBCIPassport)this.passport, 9, null);
            HBCIUtils.log("fetching new sys-id from institute", 3);
            HBCIUtils.log("checking whether passport is supported (but ignoring result)", 4);
            boolean s = this.passport.isSupported();
            HBCIUtils.log("passport supported: " + s, 4);
            String blz = this.passport.getBLZ();
            String country = this.passport.getCountry();
            this.passport.setSigId(new Long(1L));
            this.passport.setSysId("0");
            HBCIMsgStatus ret = null;
            boolean restarted = false;
            while (true) {
                this.kernel.rawNewMsg("Synch");
                this.kernel.rawSet("Idn.KIK.blz", blz);
                this.kernel.rawSet("Idn.KIK.country", country);
                this.kernel.rawSet("Idn.customerid", this.passport.getCustomerId());
                this.kernel.rawSet("Idn.sysid", "0");
                this.kernel.rawSet("Idn.sysStatus", "1");
                this.kernel.rawSet("MsgHead.dialogid", "0");
                this.kernel.rawSet("MsgHead.msgnum", "1");
                this.kernel.rawSet("MsgTail.msgnum", "1");
                this.kernel.rawSet("ProcPrep.BPD", this.passport.getBPDVersion());
                this.kernel.rawSet("ProcPrep.UPD", this.passport.getUPDVersion());
                this.kernel.rawSet("ProcPrep.lang", "0");
                this.kernel.rawSet("ProcPrep.prodName", HBCIUtils.getParam("client.product.name", "HBCI4Java"));
                this.kernel.rawSet("ProcPrep.prodVersion", HBCIUtils.getParam("client.product.version", "2.5"));
                this.kernel.rawSet("Sync.mode", "0");
                ret = this.kernel.rawDoIt(true, true, true, true);
                boolean need_restart = this.passport.postInitResponseHook(ret);
                if (!need_restart) break;
                HBCIUtils.log("for some reason we have to restart this dialog", 3);
                if (restarted) {
                    HBCIUtils.log("this dialog already has been restarted once - to avoid endless loops we stop here", 2);
                    throw new HBCI_Exception("*** restart loop - aborting");
                }
                restarted = true;
            }
            Properties result = ret.getData();
            if (!ret.isOK()) {
                throw new ProcessException(HBCIUtilsInternal.getLocMsg("EXCMSG_SYNCSYSIDFAIL"), ret);
            }
            HBCIInstitute inst = new HBCIInstitute(this.kernel, this.passport, false);
            inst.updateBPD(result);
            this.updateUPD(result);
            this.passport.setSysId(result.getProperty("SyncRes.sysid"));
            this.passport.saveChanges();
            this.passport.getCallback().status((HBCIPassport)this.passport, 10, new Object[]{ret, this.passport.getSysId()});
            HBCIUtils.log("new sys-id is " + this.passport.getSysId(), 4);
            this.doDialogEnd(result.getProperty("MsgHead.dialogid"), "2", true, true, true);
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_SYNCSYSIDFAIL"), e);
        }
        finally {
            this.passport.closeComm();
        }
    }

    public void fetchSigId() {
        try {
            this.passport.getCallback().status((HBCIPassport)this.passport, 15, null);
            HBCIUtils.log("syncing signature id", 3);
            HBCIUtils.log("checking whether passport is supported (but ignoring result)", 4);
            boolean s = this.passport.isSupported();
            HBCIUtils.log("passport supported: " + s, 4);
            String blz = this.passport.getBLZ();
            String country = this.passport.getCountry();
            this.passport.setSigId(new Long("9999999999999999"));
            HBCIMsgStatus ret = null;
            boolean restarted = false;
            while (true) {
                this.kernel.rawNewMsg("Synch");
                this.kernel.rawSet("Idn.KIK.blz", blz);
                this.kernel.rawSet("Idn.KIK.country", country);
                this.kernel.rawSet("Idn.customerid", this.passport.getCustomerId());
                this.kernel.rawSet("Idn.sysid", this.passport.getSysId());
                this.kernel.rawSet("Idn.sysStatus", this.passport.getSysStatus());
                this.kernel.rawSet("MsgHead.dialogid", "0");
                this.kernel.rawSet("MsgHead.msgnum", "1");
                this.kernel.rawSet("MsgTail.msgnum", "1");
                this.kernel.rawSet("ProcPrep.BPD", this.passport.getBPDVersion());
                this.kernel.rawSet("ProcPrep.UPD", this.passport.getUPDVersion());
                this.kernel.rawSet("ProcPrep.lang", "0");
                this.kernel.rawSet("ProcPrep.prodName", HBCIUtils.getParam("client.product.name", "HBCI4Java"));
                this.kernel.rawSet("ProcPrep.prodVersion", HBCIUtils.getParam("client.product.version", "2.5"));
                this.kernel.rawSet("Sync.mode", "2");
                ret = this.kernel.rawDoIt(this.passport.hasMySigKey(), true, true, this.passport.hasMyEncKey());
                boolean need_restart = this.passport.postInitResponseHook(ret);
                if (!need_restart) break;
                HBCIUtils.log("for some reason we have to restart this dialog", 3);
                if (restarted) {
                    HBCIUtils.log("this dialog already has been restarted once - to avoid endless loops we stop here", 2);
                    throw new HBCI_Exception("*** restart loop - aborting");
                }
                restarted = true;
            }
            Properties result = ret.getData();
            if (!ret.isOK()) {
                throw new ProcessException(HBCIUtilsInternal.getLocMsg("EXCMSG_SYNCSIGIDFAIL"), ret);
            }
            HBCIInstitute inst = new HBCIInstitute(this.kernel, this.passport, false);
            inst.updateBPD(result);
            this.updateUPD(result);
            this.passport.setSigId(new Long(result.getProperty("SyncRes.sigid", "1")));
            this.passport.incSigId();
            this.passport.saveChanges();
            this.passport.getCallback().status((HBCIPassport)this.passport, 16, new Object[]{ret, this.passport.getSigId()});
            HBCIUtils.log("signature id set to " + this.passport.getSigId(), 4);
            this.doDialogEnd(result.getProperty("MsgHead.dialogid"), "2", this.passport.hasMySigKey(), true, this.passport.hasMyEncKey());
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_SYNCSIGIDFAIL"), e);
        }
        finally {
            this.passport.closeComm();
        }
    }

    public void updateUPD(Properties result) {
        HBCIUtils.log("extracting UPD from results", 4);
        Properties p = new Properties();
        Enumeration<Object> e = result.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("UPD.")) continue;
            p.setProperty(key.substring("UPD.".length()), result.getProperty(key));
        }
        if (p.size() != 0) {
            String mediaInfo;
            p.setProperty("_hbciversion", this.kernel.getHBCIVersion());
            Properties upd = this.passport.getUPD();
            if (upd != null && (mediaInfo = upd.getProperty("tanmedia.names")) != null) {
                HBCIUtils.log("rescued TAN media info to new UPD: " + mediaInfo, 3);
                p.setProperty("tanmedia.names", mediaInfo);
            }
            String oldVersion = this.passport.getUPDVersion();
            this.passport.setUPD(p);
            HBCIUtils.log("installed new UPD [old version: " + oldVersion + ", new version: " + this.passport.getUPDVersion() + "]", 3);
            this.passport.getCallback().status((HBCIPassport)this.passport, 12, this.passport.getUPD());
        }
    }

    public void fetchUPD() {
        try {
            this.passport.getCallback().status((HBCIPassport)this.passport, 11, null);
            HBCIUtils.log("fetching UPD (BPD-Version: " + this.passport.getBPDVersion() + ")", 3);
            HBCIUtils.log("checking whether passport is supported (but ignoring result)", 4);
            boolean s = this.passport.isSupported();
            HBCIUtils.log("passport supported: " + s, 4);
            String blz = this.passport.getBLZ();
            String country = this.passport.getCountry();
            HBCIMsgStatus ret = null;
            boolean restarted = false;
            while (true) {
                this.kernel.rawNewMsg("DialogInit");
                this.kernel.rawSet("Idn.KIK.blz", blz);
                this.kernel.rawSet("Idn.KIK.country", country);
                this.kernel.rawSet("Idn.customerid", this.passport.getCustomerId());
                this.kernel.rawSet("Idn.sysid", this.passport.getSysId());
                String sysstatus = this.passport.getSysStatus();
                this.kernel.rawSet("Idn.sysStatus", sysstatus);
                this.kernel.rawSet("ProcPrep.BPD", this.passport.getBPDVersion());
                this.kernel.rawSet("ProcPrep.UPD", "0");
                this.kernel.rawSet("ProcPrep.lang", this.passport.getLang());
                this.kernel.rawSet("ProcPrep.prodName", HBCIUtils.getParam("client.product.name", "HBCI4Java"));
                this.kernel.rawSet("ProcPrep.prodVersion", HBCIUtils.getParam("client.product.version", "2.5"));
                ret = this.kernel.rawDoIt(true, true, true, true);
                boolean need_restart = this.passport.postInitResponseHook(ret);
                if (!need_restart) break;
                HBCIUtils.log("for some reason we have to restart this dialog", 3);
                if (restarted) {
                    HBCIUtils.log("this dialog already has been restarted once - to avoid endless loops we stop here", 2);
                    throw new HBCI_Exception("*** restart loop - aborting");
                }
                restarted = true;
            }
            Properties result = ret.getData();
            if (!ret.isOK()) {
                throw new ProcessException(HBCIUtilsInternal.getLocMsg("EXCMSG_GETUPDFAIL"), ret);
            }
            HBCIInstitute inst = new HBCIInstitute(this.kernel, this.passport, false);
            inst.updateBPD(result);
            this.updateUPD(result);
            this.passport.saveChanges();
            this.doDialogEnd(result.getProperty("MsgHead.dialogid"), "2", true, true, true);
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_GETUPDFAIL"), e);
        }
        finally {
            this.passport.closeComm();
        }
    }

    private void updateUserData() {
        String hbciVersionOfUPD;
        if (this.passport.getSysStatus().equals("1")) {
            if (this.passport.getSysId().equals("0")) {
                this.fetchSysId();
            }
            if (this.passport.getSigId() == -1L) {
                this.fetchSigId();
            }
        }
        Properties upd = this.passport.getUPD();
        Properties bpd = this.passport.getBPD();
        String string = hbciVersionOfUPD = upd != null ? upd.getProperty("_hbciversion") : null;
        if (bpd == null || this.passport.getUPD() == null || hbciVersionOfUPD == null || !hbciVersionOfUPD.equals(this.kernel.getHBCIVersion())) {
            this.fetchUPD();
        }
    }

    public void register() {
        this.updateUserData();
        this.passport.setPersistentData("_registered_user", Boolean.TRUE);
    }

    public void lockKeys() {
        if (!this.passport.needUserKeys() || !this.passport.hasMySigKey()) {
            if (!this.passport.needUserKeys()) {
                throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_USR_DONTHAVEUSRKEYS"));
            }
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_USR_NOUSRKEYSAVAIL"));
        }
        try {
            this.passport.getCallback().status((HBCIPassport)this.passport, 17, null);
            HBCIUtils.log("locking user keys", 3);
            String blz = this.passport.getBLZ();
            String country = this.passport.getCountry();
            HBCIMsgStatus status = null;
            boolean restarted = false;
            while (true) {
                this.kernel.rawNewMsg("DialogInit");
                this.kernel.rawSet("Idn.KIK.blz", blz);
                this.kernel.rawSet("Idn.KIK.country", country);
                this.kernel.rawSet("Idn.customerid", this.passport.getCustomerId());
                this.kernel.rawSet("Idn.sysid", this.passport.getSysId());
                this.kernel.rawSet("Idn.sysStatus", this.passport.getSysStatus());
                this.kernel.rawSet("ProcPrep.BPD", this.passport.getBPDVersion());
                this.kernel.rawSet("ProcPrep.UPD", this.passport.getUPDVersion());
                this.kernel.rawSet("ProcPrep.lang", this.passport.getLang());
                this.kernel.rawSet("ProcPrep.prodName", HBCIUtils.getParam("client.product.name", "HBCI4Java"));
                this.kernel.rawSet("ProcPrep.prodVersion", HBCIUtils.getParam("client.product.version", "2.5"));
                status = this.kernel.rawDoIt(true, true, true, true);
                boolean need_restart = this.passport.postInitResponseHook(status);
                if (!need_restart) break;
                HBCIUtils.log("for some reason we have to restart this dialog", 3);
                if (restarted) {
                    HBCIUtils.log("this dialog already has been restarted once - to avoid endless loops we stop here", 2);
                    throw new HBCI_Exception("*** restart loop - aborting");
                }
                restarted = true;
            }
            Properties result = status.getData();
            if (!status.isOK()) {
                throw new ProcessException(HBCIUtilsInternal.getLocMsg("EXCMSG_LOCKFAILED"), status);
            }
            String dialogid = result.getProperty("MsgHead.dialogid");
            this.passport.getCallback().status((HBCIPassport)this.passport, 18, new Object[]{status, dialogid});
            this.passport.getCallback().status((HBCIPassport)this.passport, 13, null);
            this.kernel.rawNewMsg("LockKeys");
            this.kernel.rawSet("MsgHead.dialogid", dialogid);
            this.kernel.rawSet("MsgHead.msgnum", "2");
            this.kernel.rawSet("MsgTail.msgnum", "2");
            this.kernel.rawSet("KeyLock.KeyName.KIK.country", country);
            this.kernel.rawSet("KeyLock.KeyName.KIK.blz", blz);
            this.kernel.rawSet("KeyLock.KeyName.userid", this.passport.getMySigKeyName());
            this.kernel.rawSet("KeyLock.KeyName.keynum", this.passport.getMySigKeyNum());
            this.kernel.rawSet("KeyLock.KeyName.keyversion", this.passport.getMySigKeyVersion());
            this.kernel.rawSet("KeyLock.SecProfile.method", this.passport.getProfileMethod());
            this.kernel.rawSet("KeyLock.SecProfile.version", this.passport.getProfileVersion());
            this.kernel.rawSet("KeyLock.locktype", "999");
            status = this.kernel.rawDoIt(true, true, true, false);
            if (!status.isOK()) {
                throw new ProcessException(HBCIUtilsInternal.getLocMsg("EXCMSG_LOCKFAILED"), status);
            }
            this.passport.clearMyDigKey();
            this.passport.clearMySigKey();
            this.passport.clearMyEncKey();
            this.passport.setSigId(new Long(1L));
            this.passport.saveChanges();
            this.passport.getCallback().status((HBCIPassport)this.passport, 14, status);
            this.doDialogEnd(dialogid, "3", false, true, false);
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_LOCKFAILED"), e);
        }
        finally {
            this.passport.closeComm();
        }
    }

    @Override
    public MsgGen getMsgGen() {
        return this.kernel.getMsgGen();
    }

    @Override
    public HBCIPassport getPassport() {
        return this.passport;
    }
}

