/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.kapott.hbci.GV.GVTemplate;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIInstitute;
import org.kapott.hbci.manager.HBCIKernel;
import org.kapott.hbci.manager.HBCIKernelImpl;
import org.kapott.hbci.manager.HBCIUser;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.IHandlerData;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.AbstractPinTanPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIDialogStatus;
import org.kapott.hbci.status.HBCIExecStatus;

public final class HBCIHandler
implements IHandlerData {
    public static final int REFRESH_BPD = 1;
    public static final int REFRESH_UPD = 2;
    private HBCIKernelImpl kernel;
    private HBCIPassportInternal passport;
    private HBCIDialog dialog;
    private boolean closeDialog;

    public HBCIHandler(HBCIPassport passport) {
        this(passport, null, true, true);
    }

    public HBCIHandler(HBCIPassport passport, HBCIDialog hbciDialog, boolean init, boolean closeDialog) {
        try {
            if (passport == null) {
                throw new InvalidArgumentException(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSPORT_NULL"));
            }
            this.dialog = hbciDialog;
            this.closeDialog = closeDialog;
            this.kernel = new HBCIKernelImpl(this, passport.getHBCIVersion());
            this.passport = (HBCIPassportInternal)passport;
            this.passport.setParentHandlerData(this);
            if (hbciDialog != null) {
                hbciDialog.setKernel(this.kernel);
            }
            if (init) {
                this.registerInstitute();
                this.registerUser();
            }
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CANT_CREATE_HANDLE"), e);
        }
        Properties upd = passport.getUPD();
        if (upd != null && !upd.containsKey("_fetchedMetaInfo")) {
            this.updateMetaInfo();
        }
    }

    public Object getProperty(String key) {
        return this.passport.getProperties().get(key);
    }

    public void updateMetaInfo() {
        Properties bpd = this.passport.getBPD();
        if (bpd == null) {
            HBCIUtils.log("have no bpd, skip fetching of meta info", 2);
            return;
        }
        try {
            HBCIExecStatus status;
            Properties lowlevel = this.getSupportedLowlevelJobs();
            if (lowlevel.getProperty("SEPAInfo") != null) {
                HBCIUtils.log("fetching SEPA information", 3);
                HBCIJobImpl sepainfo = this.newJob("SEPAInfo");
                sepainfo.addToQueue();
            }
            if (lowlevel.getProperty("TANMediaList") != null && this.passport instanceof AbstractPinTanPassport) {
                HBCIUtils.log("fetching TAN media list", 3);
                HBCIJobImpl tanMedia = this.newJob("TANMediaList");
                tanMedia.addToQueue();
            }
            if ((status = this.execute()).isOK()) {
                HBCIUtils.log("successfully fetched meta info", 3);
                this.passport.getUPD().setProperty("_fetchedMetaInfo", new Date().toString());
                this.passport.saveChanges();
            } else {
                HBCIUtils.log("error while fetching meta info: " + status.toString(), 1);
            }
        }
        catch (Exception e) {
            HBCIUtils.log(e);
        }
    }

    public void updateSEPAInfo() {
        Properties bpd = this.passport.getBPD();
        if (bpd == null) {
            HBCIUtils.log("have no bpd, skipping SEPA information fetching", 2);
            return;
        }
        try {
            if (this.getSupportedLowlevelJobs().getProperty("SEPAInfo") != null) {
                HBCIUtils.log("trying to fetch SEPA information from institute", 3);
                HBCIJobImpl sepainfo = this.newJob("SEPAInfo");
                sepainfo.addToQueue();
                HBCIExecStatus status = this.execute();
                if (status.isOK()) {
                    HBCIUtils.log("successfully fetched information about SEPA accounts from institute", 3);
                    this.passport.getUPD().setProperty("_fetchedSEPA", "1");
                    this.passport.saveChanges();
                } else {
                    HBCIUtils.log("error while fetching information about SEPA accounts from institute:", 1);
                    HBCIUtils.log(status.toString(), 1);
                }
            } else {
                HBCIUtils.log("institute does not support SEPA accounts, so we skip fetching information about SEPA", 4);
            }
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception(e);
        }
    }

    private void registerInstitute() {
        try {
            HBCIUtils.log("registering institute", 4);
            HBCIInstitute inst = new HBCIInstitute(this.kernel, this.passport, false);
            inst.register();
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CANT_REG_INST"), ex);
        }
    }

    private void registerUser() {
        try {
            HBCIUtils.log("registering user", 4);
            HBCIUser user = new HBCIUser(this.kernel, this.passport, false);
            user.register();
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CANT_REG_USER"), ex);
        }
    }

    public void close() {
        if (this.passport != null) {
            try {
                this.passport.close();
            }
            catch (Exception e) {
                HBCIUtils.log(e);
            }
        }
        this.passport = null;
        this.kernel = null;
        this.dialog = null;
    }

    private String fixUnspecifiedCustomerId(String customerId) {
        if (customerId == null) {
            customerId = this.passport.getCustomerId();
            HBCIUtils.log("using default customerid " + customerId, 4);
        }
        return customerId;
    }

    public HBCIDialog getDialog() {
        if (this.dialog == null) {
            HBCIUtils.log("have to create new dialog for customerid", 4);
            this.dialog = new HBCIDialog((HBCIPassportInternal)this.getPassport(), (HBCIKernelImpl)this.getKernel());
        }
        return this.dialog;
    }

    public void newMsg() {
        HBCIUtils.log("have to create new message for dialog for customer", 4);
        this.getDialog().newMsg();
    }

    public HBCIJobImpl newJob(String jobname) {
        HBCIJobImpl ret;
        block4: {
            HBCIUtils.log("creating new job " + jobname, 4);
            if (jobname == null || jobname.length() == 0) {
                throw new InvalidArgumentException(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
            }
            ret = null;
            String className = "org.kapott.hbci.GV.GV" + jobname;
            try {
                Class<?> cl = Class.forName(className);
                Constructor<?> cons = cl.getConstructor(HBCIHandler.class);
                ret = (HBCIJobImpl)cons.newInstance(this);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidUserDataException("*** there is no highlevel job named " + jobname + " - need class " + className);
            }
            catch (Exception e) {
                String msg = HBCIUtilsInternal.getLocMsg("EXCMSG_JOB_CREATE_ERR", jobname);
                if (HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreCreateJobErrors", msg)) break block4;
                throw new HBCI_Exception(msg, e);
            }
        }
        return ret;
    }

    public HBCIJob newLowlevelJob(String gvname) {
        HBCIUtils.log("generating new lowlevel-job " + gvname, 4);
        if (gvname == null || gvname.length() == 0) {
            throw new InvalidArgumentException(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
        }
        GVTemplate ret = new GVTemplate(gvname, this);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobToDialog(String customerId, HBCIJob job) {
        customerId = this.fixUnspecifiedCustomerId(customerId);
        HBCIDialog dialog = null;
        try {
            dialog = this.getDialog();
            dialog.addTask((HBCIJobImpl)job);
        }
        finally {
            if (dialog != null && dialog.getAllTasks().size() == 0) {
                HBCIUtils.log("removing empty dialog for customerid " + customerId + " from list of dialogs", 4);
                dialog = null;
            }
        }
    }

    public void addJob(String customerId, HBCIJob job) {
        this.addJobToDialog(customerId, job);
    }

    public void addJob(HBCIJob job) {
        this.addJob(null, job);
    }

    public void createEmptyDialog() {
        HBCIUtils.log("creating empty dialog", 4);
        this.getDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HBCIExecStatus execute() {
        String origCustomerId = this.passport.getCustomerId();
        try {
            HBCIExecStatus ret = new HBCIExecStatus();
            HBCIUtils.log("executing dialog", 4);
            try {
                HBCIDialog dialog = this.getDialog();
                HBCIDialogStatus dialogStatus = dialog.doIt(this.closeDialog);
                ret.addDialogStatus(dialogStatus);
            }
            catch (Exception e) {
                ret.addException(e);
            }
            finally {
                if (this.closeDialog) {
                    this.dialog = null;
                }
            }
            HBCIExecStatus hBCIExecStatus = ret;
            return hBCIExecStatus;
        }
        finally {
            if (this.closeDialog) {
                this.reset();
            }
            this.passport.setCustomerId(origCustomerId);
            try {
                this.passport.closeComm();
            }
            catch (Exception e) {
                HBCIUtils.log("nested exception while closing passport: ", 1);
                HBCIUtils.log(e);
            }
        }
    }

    public void reset() {
        this.dialog = null;
    }

    @Override
    public HBCIPassport getPassport() {
        return this.passport;
    }

    public HBCIKernel getKernel() {
        return this.kernel;
    }

    @Override
    public MsgGen getMsgGen() {
        return this.kernel.getMsgGen();
    }

    public String getHBCIVersion() {
        return this.kernel.getHBCIVersion();
    }

    public Properties getSupportedLowlevelJobs() {
        Hashtable<String, List<String>> allValidJobNames = this.kernel.getAllLowlevelJobs();
        Properties paramSegments = this.passport.getParamSegmentNames();
        Properties result = new Properties();
        Enumeration<?> e = paramSegments.propertyNames();
        while (e.hasMoreElements()) {
            String segName = (String)e.nextElement();
            if (!allValidJobNames.containsKey(segName)) continue;
            result.put(segName, paramSegments.getProperty(segName));
        }
        return result;
    }

    public List<String> getLowlevelJobParameterNames(String gvname) {
        if (gvname == null || gvname.length() == 0) {
            throw new InvalidArgumentException(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
        }
        String version = this.getSupportedLowlevelJobs().getProperty(gvname);
        if (version == null) {
            throw new HBCI_Exception("*** lowlevel job " + gvname + " not supported");
        }
        return this.kernel.getLowlevelJobParameterNames(gvname, version);
    }

    public List<String> getLowlevelJobResultNames(String gvname) {
        if (gvname == null || gvname.length() == 0) {
            throw new InvalidArgumentException(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
        }
        String version = this.getSupportedLowlevelJobs().getProperty(gvname);
        if (version == null) {
            throw new HBCI_Exception("*** lowlevel job " + gvname + " not supported");
        }
        return this.kernel.getLowlevelJobResultNames(gvname, version);
    }

    public Properties getLowlevelJobRestrictions(String gvname) {
        if (gvname == null || gvname.length() == 0) {
            throw new InvalidArgumentException(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
        }
        String version = this.getSupportedLowlevelJobs().getProperty(gvname);
        if (version == null) {
            throw new HBCI_Exception("*** lowlevel job " + gvname + " not supported");
        }
        return this.passport.getJobRestrictions(gvname, version);
    }

    public boolean isSupported(String jobnameHL) {
        if (jobnameHL == null || jobnameHL.length() == 0) {
            throw new InvalidArgumentException(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
        }
        try {
            Class<?> cl = Class.forName("org.kapott.hbci.GV.GV" + jobnameHL);
            String lowlevelName = (String)cl.getMethod("getLowlevelName", null).invoke(null, (Object[])null);
            return this.getSupportedLowlevelJobs().keySet().contains(lowlevelName);
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_HANDLER_HLCHECKERR", jobnameHL), e);
        }
    }

    public HBCIDialogStatus refreshXPD(int selectX) {
        if ((selectX & 1) != 0) {
            this.passport.clearBPD();
        }
        if ((selectX & 2) != 0) {
            this.passport.clearUPD();
        }
        this.reset();
        this.getDialog();
        HBCIDialogStatus result = this.execute().getDialogStatus();
        return result;
    }
}

