/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV_Result;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIRetVal;

public final class GVRStatus
extends HBCIJobResultImpl {
    private List<Entry> entries = new ArrayList<Entry>();

    public void addEntry(Entry entry) {
        this.entries.add(entry);
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (Entry e : this.entries) {
            ret.append(e.toString());
            ret.append(System.getProperty("line.separator"));
        }
        return ret.toString().trim();
    }

    public Entry[] getStatusData() {
        return this.entries.toArray(new Entry[this.entries.size()]);
    }

    public Entry getJobEntry(String jobId) {
        Entry ret = null;
        for (Entry entry : this.entries) {
            if (!entry.getJobId().equals(jobId)) continue;
            ret = entry;
            break;
        }
        return ret;
    }

    public static class Entry {
        public String dialogid;
        public String msgnum;
        public Date timestamp;
        public HBCIRetVal retval;

        public String getJobId() {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            return format.format(this.timestamp) + "/" + this.dialogid + "/" + this.msgnum + "/" + this.retval.segref;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append(HBCIUtils.datetime2StringLocal(this.timestamp));
            ret.append(" ");
            ret.append(this.dialogid);
            ret.append("/");
            ret.append(this.msgnum);
            ret.append("/");
            ret.append(this.retval.toString());
            return ret.toString();
        }
    }
}

