/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.generators;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Properties;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.generators.AbstractSEPAGenerator;
import org.kapott.hbci.sepa.PainVersion;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.AccountIdentificationSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.AmountTypeSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.BranchAndFinancialInstitutionIdentificationSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.CashAccountSCT1;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.CashAccountSCT2;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.ChargeBearerTypeSCTCode;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.CreditTransferTransactionInformationSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.CurrencyAndAmountSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.CurrencyCodeSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.Document;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.FinancialInstitutionIdentificationSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.GroupHeaderSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.Grouping1CodeSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.ObjectFactory;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.Pain00100102;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.PartyIdentificationSCT1;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.PartyIdentificationSCT2;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.PaymentIdentification1;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.PaymentInstructionInformationSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.PaymentMethodSCTCode;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.PaymentTypeInformationSCT1;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.PurposeSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.RemittanceInformationSCTChoice;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.ServiceLevelSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_002_02.ServiceLevelSCTCode;

public class GenUebSEPA00100202
extends AbstractSEPAGenerator {
    @Override
    public PainVersion getPainVersion() {
        return PainVersion.PAIN_001_002_02;
    }

    @Override
    public void generate(Properties sepaParams, OutputStream os, boolean validate) throws Exception {
        Integer maxIndex = SepaUtil.maxIndex(sepaParams);
        Document doc = new Document();
        doc.setPain00100102(new Pain00100102());
        doc.getPain00100102().setGrpHdr(new GroupHeaderSCT());
        String batch = SepaUtil.getProperty(sepaParams, "batchbook", null);
        if (batch != null) {
            doc.getPain00100102().getGrpHdr().setBtchBookg(batch.equals("1"));
        }
        String sepaId = sepaParams.getProperty("sepaid");
        String pmtInfId = sepaParams.getProperty("pmtinfid");
        doc.getPain00100102().getGrpHdr().setMsgId(sepaId);
        doc.getPain00100102().getGrpHdr().setCreDtTm(SepaUtil.createCalendar(null));
        doc.getPain00100102().getGrpHdr().setNbOfTxs(String.valueOf(maxIndex != null ? maxIndex + 1 : 1));
        doc.getPain00100102().getGrpHdr().setCtrlSum(SepaUtil.sumBtgValue(sepaParams, maxIndex));
        doc.getPain00100102().getGrpHdr().setGrpg(Grouping1CodeSCT.MIXD);
        doc.getPain00100102().getGrpHdr().setInitgPty(new PartyIdentificationSCT1());
        doc.getPain00100102().getGrpHdr().getInitgPty().setNm(sepaParams.getProperty("src.name"));
        ArrayList pmtInfs = (ArrayList)doc.getPain00100102().getPmtInf();
        PaymentInstructionInformationSCT pmtInf = new PaymentInstructionInformationSCT();
        pmtInfs.add(pmtInf);
        pmtInf.setPmtInfId(pmtInfId != null && pmtInfId.length() > 0 ? pmtInfId : sepaId);
        pmtInf.setPmtMtd(PaymentMethodSCTCode.TRF);
        pmtInf.setPmtTpInf(new PaymentTypeInformationSCT1());
        pmtInf.getPmtTpInf().setSvcLvl(new ServiceLevelSCT());
        pmtInf.getPmtTpInf().getSvcLvl().setCd(ServiceLevelSCTCode.SEPA);
        String date = sepaParams.getProperty("date");
        if (date == null) {
            date = "1999-01-01";
        }
        pmtInf.setReqdExctnDt(SepaUtil.createCalendar(date));
        pmtInf.setDbtr(new PartyIdentificationSCT2());
        pmtInf.setDbtrAcct(new CashAccountSCT1());
        pmtInf.setDbtrAgt(new BranchAndFinancialInstitutionIdentificationSCT());
        pmtInf.getDbtr().setNm(sepaParams.getProperty("src.name"));
        pmtInf.getDbtrAcct().setId(new AccountIdentificationSCT());
        pmtInf.getDbtrAcct().getId().setIBAN(sepaParams.getProperty("src.iban"));
        pmtInf.getDbtrAgt().setFinInstnId(new FinancialInstitutionIdentificationSCT());
        pmtInf.getDbtrAgt().getFinInstnId().setBIC(sepaParams.getProperty("src.bic"));
        pmtInf.setChrgBr(ChargeBearerTypeSCTCode.SLEV);
        ArrayList cdtTrxTxInfs = (ArrayList)pmtInf.getCdtTrfTxInf();
        if (maxIndex != null) {
            for (int tnr = 0; tnr <= maxIndex; ++tnr) {
                cdtTrxTxInfs.add(this.createCreditTransferTransactionInformationSCT(sepaParams, tnr));
            }
        } else {
            cdtTrxTxInfs.add(this.createCreditTransferTransactionInformationSCT(sepaParams, null));
        }
        ObjectFactory of = new ObjectFactory();
        this.marshal(of.createDocument(doc), os, validate);
    }

    private CreditTransferTransactionInformationSCT createCreditTransferTransactionInformationSCT(Properties sepaParams, Integer index) {
        String purposeCode;
        CreditTransferTransactionInformationSCT cdtTrxTxInf = new CreditTransferTransactionInformationSCT();
        cdtTrxTxInf.setPmtId(new PaymentIdentification1());
        cdtTrxTxInf.getPmtId().setEndToEndId(SepaUtil.getProperty(sepaParams, SepaUtil.insertIndex("endtoendid", index), "NOTPROVIDED"));
        cdtTrxTxInf.setCdtr(new PartyIdentificationSCT2());
        cdtTrxTxInf.getCdtr().setNm(sepaParams.getProperty(SepaUtil.insertIndex("dst.name", index)));
        cdtTrxTxInf.setCdtrAcct(new CashAccountSCT2());
        cdtTrxTxInf.getCdtrAcct().setId(new AccountIdentificationSCT());
        cdtTrxTxInf.getCdtrAcct().getId().setIBAN(sepaParams.getProperty(SepaUtil.insertIndex("dst.iban", index)));
        cdtTrxTxInf.setCdtrAgt(new BranchAndFinancialInstitutionIdentificationSCT());
        cdtTrxTxInf.getCdtrAgt().setFinInstnId(new FinancialInstitutionIdentificationSCT());
        cdtTrxTxInf.getCdtrAgt().getFinInstnId().setBIC(sepaParams.getProperty(SepaUtil.insertIndex("dst.bic", index)));
        cdtTrxTxInf.setAmt(new AmountTypeSCT());
        cdtTrxTxInf.getAmt().setInstdAmt(new CurrencyAndAmountSCT());
        cdtTrxTxInf.getAmt().getInstdAmt().setValue(new BigDecimal(sepaParams.getProperty(SepaUtil.insertIndex("btg.value", index))));
        cdtTrxTxInf.getAmt().getInstdAmt().setCcy(CurrencyCodeSCT.EUR);
        String usage = sepaParams.getProperty(SepaUtil.insertIndex("usage", index));
        if (usage != null && usage.length() > 0) {
            cdtTrxTxInf.setRmtInf(new RemittanceInformationSCTChoice());
            cdtTrxTxInf.getRmtInf().setUstrd(usage);
        }
        if ((purposeCode = sepaParams.getProperty(SepaUtil.insertIndex("purposecode", index))) != null && purposeCode.length() > 0) {
            PurposeSCT p = new PurposeSCT();
            p.setCd(purposeCode);
            cdtTrxTxInf.setPurp(p);
        }
        return cdtTrxTxInf;
    }
}

