/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.structures.Value;

public class SepaUtil {
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_UNDEFINED = "1999-01-01";
    private static final Pattern INDEX_PATTERN = Pattern.compile("\\w+\\[(\\d+)\\](\\..*)?");

    public static XMLGregorianCalendar createCalendar(String isoDate) throws Exception {
        if (isoDate == null) {
            SimpleDateFormat format = new SimpleDateFormat(DATETIME_FORMAT);
            isoDate = format.format(new Date());
        }
        DatatypeFactory df = DatatypeFactory.newInstance();
        return df.newXMLGregorianCalendar(isoDate);
    }

    public static String format(XMLGregorianCalendar cal, String format) {
        if (cal == null) {
            return null;
        }
        if (format == null) {
            format = DATE_FORMAT;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(cal.toGregorianCalendar().getTime());
    }

    public static String format(BigDecimal value) {
        return value != null ? value.toString() : null;
    }

    public static Integer maxIndex(Properties properties) {
        Integer max = null;
        for (String key : properties.stringPropertyNames()) {
            Matcher m = INDEX_PATTERN.matcher(key);
            if (!m.matches()) continue;
            int index = Integer.parseInt(m.group(1));
            if (max != null && index <= max) continue;
            max = index;
        }
        return max;
    }

    public static BigDecimal sumBtgValue(Properties sepaParams, Integer max) {
        if (max == null) {
            return new BigDecimal(sepaParams.getProperty("btg.value"));
        }
        BigDecimal sum = BigDecimal.ZERO;
        String curr = null;
        for (int index = 0; index <= max; ++index) {
            sum = sum.add(new BigDecimal(sepaParams.getProperty(SepaUtil.insertIndex("btg.value", index))));
            String indexCurr = sepaParams.getProperty(SepaUtil.insertIndex("btg.curr", index));
            if (curr != null) {
                if (curr.equals(indexCurr)) continue;
                throw new InvalidArgumentException("mixed currencies on multiple transactions");
            }
            curr = indexCurr;
        }
        return sum;
    }

    public static String insertIndex(String key, Integer index) {
        if (index == null) {
            return key;
        }
        int pos = key.indexOf(46);
        if (pos >= 0) {
            return key.substring(0, pos) + '[' + index + ']' + key.substring(pos);
        }
        return key + '[' + index + ']';
    }

    public static Value sumBtgValueObject(Properties properties) {
        Integer maxIndex = SepaUtil.maxIndex(properties);
        BigDecimal btg = SepaUtil.sumBtgValue(properties, maxIndex);
        String curr = properties.getProperty(SepaUtil.insertIndex("btg.curr", maxIndex == null ? null : Integer.valueOf(0)));
        return new Value(btg, curr);
    }

    public static String getProperty(Properties props, String name, String defaultValue) {
        String value = props.getProperty(name);
        return value != null && value.length() > 0 ? value : defaultValue;
    }
}

