/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.cryptalgs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import org.kapott.cryptalgs.RSAPrivateCrtKey2;
import org.kapott.cryptalgs.SignatureParamSpec;

public class PKCS1_15
extends SignatureSpi {
    private RSAPublicKey pubKey;
    private PrivateKey privKey;
    private SignatureParamSpec param;
    private ByteArrayOutputStream plainmsg;

    @Override
    @Deprecated
    protected void engineSetParameter(String param1, Object value) throws InvalidParameterException {
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!(params instanceof SignatureParamSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        this.param = (SignatureParamSpec)params;
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param1) throws InvalidParameterException {
        return null;
    }

    public static MessageDigest getMessageDigest(SignatureParamSpec spec) {
        MessageDigest result;
        try {
            String provider = spec.getProvider();
            result = provider != null ? MessageDigest.getInstance(spec.getHashAlg(), provider) : MessageDigest.getInstance(spec.getHashAlg());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) {
        this.privKey = privateKey;
        this.plainmsg = new ByteArrayOutputStream();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) {
        this.pubKey = (RSAPublicKey)publicKey;
        this.plainmsg = new ByteArrayOutputStream();
    }

    @Override
    protected void engineUpdate(byte b) {
        this.plainmsg.write(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.engineUpdate(b[off + i]);
        }
    }

    @Override
    protected byte[] engineSign() {
        return PKCS1_15.sign(this.param, this.privKey, this.plainmsg.toByteArray());
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) {
        return PKCS1_15.verify(this.param, this.pubKey, this.plainmsg.toByteArray(), sigBytes);
    }

    private static byte[] i2osp(BigInteger x, int len) {
        byte[] bytes = x.toByteArray();
        if (bytes.length > len) {
            for (int i = 0; i < bytes.length - len; ++i) {
                if (bytes[i] == 0) continue;
                throw new RuntimeException("value too large");
            }
            byte[] out = new byte[len];
            System.arraycopy(bytes, bytes.length - len, out, 0, len);
            bytes = out;
        } else if (bytes.length < len) {
            byte[] out = new byte[len];
            System.arraycopy(bytes, 0, out, len - bytes.length, bytes.length);
            bytes = out;
        }
        return bytes;
    }

    private static BigInteger os2ip(byte[] bytes) {
        return new BigInteger(1, bytes);
    }

    private static BigInteger sp1(PrivateKey key, BigInteger m) {
        BigInteger result;
        if (key instanceof RSAPrivateKey) {
            BigInteger d = ((RSAPrivateKey)key).getPrivateExponent();
            BigInteger n = ((RSAPrivateKey)key).getModulus();
            result = m.modPow(d, n);
        } else {
            RSAPrivateCrtKey2 key2 = (RSAPrivateCrtKey2)key;
            BigInteger p = key2.getP();
            BigInteger q = key2.getQ();
            BigInteger dP = key2.getdP();
            BigInteger dQ = key2.getdQ();
            BigInteger qInv = key2.getQInv();
            BigInteger s1 = m.modPow(dP, p);
            BigInteger s2 = m.modPow(dQ, q);
            BigInteger h = s1.subtract(s2).multiply(qInv).mod(p);
            result = s2.add(q.multiply(h));
        }
        return result;
    }

    private static BigInteger vp1(RSAPublicKey key, BigInteger s) {
        BigInteger e = key.getPublicExponent();
        BigInteger n = key.getModulus();
        BigInteger m = s.modPow(e, n);
        return m;
    }

    private static byte[] sign(SignatureParamSpec spec, PrivateKey privKey, byte[] msg) {
        BigInteger bModulus = privKey instanceof RSAPrivateKey ? ((RSAPrivateKey)privKey).getModulus() : ((RSAPrivateCrtKey2)privKey).getP().multiply(((RSAPrivateCrtKey2)privKey).getQ());
        int modBits = bModulus.bitLength();
        int k = modBits >> 3;
        if ((modBits & 7) != 0) {
            ++k;
        }
        byte[] EM = PKCS1_15.emsa_encode(spec, msg, k);
        BigInteger m = PKCS1_15.os2ip(EM);
        BigInteger s = PKCS1_15.sp1(privKey, m);
        byte[] S = PKCS1_15.i2osp(s, k);
        return S;
    }

    private static boolean verify(SignatureParamSpec spec, PublicKey pubKey, byte[] msg, byte[] signature) {
        int modBits = ((RSAPublicKey)pubKey).getModulus().bitLength();
        int k = modBits >> 3;
        if ((modBits & 7) != 0) {
            ++k;
        }
        BigInteger s = PKCS1_15.os2ip(signature);
        BigInteger m = PKCS1_15.vp1((RSAPublicKey)pubKey, s);
        byte[] EM2 = PKCS1_15.i2osp(m, k);
        byte[] EM = PKCS1_15.emsa_encode(spec, msg, k);
        return Arrays.equals(EM, EM2);
    }

    private static byte[] hash(SignatureParamSpec spec, byte[] msg) {
        MessageDigest dig = PKCS1_15.getMessageDigest(spec);
        return dig.digest(msg);
    }

    private static byte[] getHashAlgOID(SignatureParamSpec spec) {
        byte[] result;
        if (spec.getHashAlg().equals("SHA-1")) {
            result = new byte[]{43, 14, 3, 2, 26};
        } else if (spec.getHashAlg().equals("SHA-256")) {
            result = new byte[]{96, -122, 72, 1, 101, 3, 4, 2, 1};
        } else {
            throw new IllegalArgumentException("dont know OID for " + spec.getHashAlg());
        }
        return result;
    }

    public static byte[] createDigestInfo(SignatureParamSpec spec, byte[] hash) {
        ByteArrayOutputStream digestInfoS = new ByteArrayOutputStream();
        byte[] digestInfo_hashAlg = PKCS1_15.getHashAlgOID(spec);
        try {
            digestInfoS.write(48);
            digestInfoS.write(8 + digestInfo_hashAlg.length + hash.length);
            digestInfoS.write(48);
            digestInfoS.write(4 + digestInfo_hashAlg.length);
            digestInfoS.write(6);
            digestInfoS.write(digestInfo_hashAlg.length);
            digestInfoS.write(digestInfo_hashAlg);
            digestInfoS.write(5);
            digestInfoS.write(0);
            digestInfoS.write(4);
            digestInfoS.write(hash.length);
            digestInfoS.write(hash);
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        byte[] digestInfo = digestInfoS.toByteArray();
        return digestInfo;
    }

    private static byte[] emsa_encode(SignatureParamSpec spec, byte[] msg, int emLen) {
        byte[] H = PKCS1_15.hash(spec, msg);
        byte[] T = PKCS1_15.createDigestInfo(spec, H);
        int tLen = T.length;
        byte[] PS = new byte[emLen - tLen - 3];
        Arrays.fill(PS, (byte)-1);
        ByteArrayOutputStream EMs = new ByteArrayOutputStream();
        try {
            EMs.write(0);
            EMs.write(1);
            EMs.write(PS);
            EMs.write(0);
            EMs.write(T);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] EM = EMs.toByteArray();
        return EM;
    }
}

