/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.transactional.impl;

import de.adorsys.common.exceptions.BaseException;
import de.adorsys.dfs.connection.api.filesystem.exceptions.FileNotFoundException;
import de.adorsys.dfs.connection.api.types.ListRecursiveFlag;
import de.adorsys.docusafe.business.DocumentSafeService;
import de.adorsys.docusafe.business.types.DSDocument;
import de.adorsys.docusafe.business.types.DocumentDirectoryFQN;
import de.adorsys.docusafe.business.types.DocumentFQN;
import de.adorsys.docusafe.business.types.MoveType;
import de.adorsys.docusafe.service.api.types.UserID;
import de.adorsys.docusafe.service.api.types.UserIDAuth;
import de.adorsys.docusafe.transactional.RequestMemoryContext;
import de.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import de.adorsys.docusafe.transactional.exceptions.TxInnerException;
import de.adorsys.docusafe.transactional.exceptions.TxNotActiveException;
import de.adorsys.docusafe.transactional.impl.CurrentTransactionData;
import de.adorsys.docusafe.transactional.impl.NonTransactionalDocumentSafeServiceImpl;
import de.adorsys.docusafe.transactional.impl.TxIDHashMapWrapper;
import de.adorsys.docusafe.transactional.types.TxBucketContentFQN;
import de.adorsys.docusafe.transactional.types.TxDocumentFQNVersion;
import de.adorsys.docusafe.transactional.types.TxDocumentFQNWithVersion;
import de.adorsys.docusafe.transactional.types.TxID;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalDocumentSafeServiceImpl
extends NonTransactionalDocumentSafeServiceImpl
implements TransactionalDocumentSafeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalDocumentSafeServiceImpl.class);
    static final DocumentDirectoryFQN txMeta = new DocumentDirectoryFQN("meta.tx");
    static final DocumentDirectoryFQN txContent = new DocumentDirectoryFQN("tx");
    private RequestMemoryContext requestMemoryContext;
    public static final String CURRENT_TRANSACTION_DATA = "CurrentTransactionData";

    public TransactionalDocumentSafeServiceImpl(RequestMemoryContext requestMemoryContext, DocumentSafeService documentSafeService) {
        super(documentSafeService);
        this.requestMemoryContext = requestMemoryContext;
        LOGGER.debug("new Instance of TransactionalDocumentSafeServiceImpl");
    }

    @Override
    public void beginTransaction(UserIDAuth userIDAuth) {
        Date beginTxDate = new Date();
        CurrentTransactionData currentTransactionData = this.findCurrentTransactionData(userIDAuth.getUserID());
        if (currentTransactionData != null) {
            throw new TxInnerException();
        }
        TxID currentTxID = new TxID();
        LOGGER.debug("beginTransaction " + currentTxID.getValue());
        TxIDHashMapWrapper txIDHashMapWrapper = TxIDHashMapWrapper.fromPreviousFileOrNew(this.documentSafeService, userIDAuth, currentTxID, beginTxDate);
        currentTransactionData = new CurrentTransactionData(currentTxID, txIDHashMapWrapper);
        this.setCurrentTransactionData(userIDAuth.getUserID(), currentTransactionData);
    }

    @Override
    public void txStoreDocument(UserIDAuth userIDAuth, DSDocument dsDocument) {
        LOGGER.debug("txStoreDocument " + dsDocument.getDocumentFQN().getValue() + " " + (Object)((Object)this.getCurrentTxID(userIDAuth.getUserID())));
        this.documentSafeService.storeDocument(userIDAuth, TransactionalDocumentSafeServiceImpl.modifyTxDocument(dsDocument, this.getCurrentTxID(userIDAuth.getUserID())));
        this.getCurrentTxIDHashMap(userIDAuth.getUserID()).storeDocument(dsDocument.getDocumentFQN());
    }

    @Override
    public DSDocument txReadDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        LOGGER.debug("txReadDocument " + documentFQN.getValue() + " " + (Object)((Object)this.getCurrentTxID(userIDAuth.getUserID())));
        TxID txidOfDocument = this.getCurrentTxIDHashMap(userIDAuth.getUserID()).getTxIDOfDocument(documentFQN);
        DSDocument dsDocument = this.documentSafeService.readDocument(userIDAuth, TransactionalDocumentSafeServiceImpl.modifyTxDocumentName(documentFQN, txidOfDocument));
        this.markDocumentRead(userIDAuth, documentFQN, txidOfDocument);
        return new DSDocument(documentFQN, dsDocument.getDocumentContent());
    }

    @Override
    public void txDeleteDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        LOGGER.debug("txDeleteDocument " + documentFQN.getValue() + " " + (Object)((Object)this.getCurrentTxID(userIDAuth.getUserID())));
        this.getCurrentTxIDHashMap(userIDAuth.getUserID()).deleteDocument(documentFQN);
    }

    @Override
    public TxBucketContentFQN txListDocuments(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        LOGGER.debug("txListDocuments " + (Object)((Object)this.getCurrentTxID(userIDAuth.getUserID())));
        TxIDHashMapWrapper txIDHashMapWrapper = this.getCurrentTxIDHashMap(userIDAuth.getUserID());
        return txIDHashMapWrapper.list(documentDirectoryFQN, recursiveFlag);
    }

    @Override
    public TxDocumentFQNVersion getVersion(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        TxBucketContentFQN txBucketContentFQN = this.txListDocuments(userIDAuth, documentFQN.getDocumentDirectory(), ListRecursiveFlag.FALSE);
        if (txBucketContentFQN.getFilesWithVersion().isEmpty()) {
            throw new FileNotFoundException(documentFQN.getValue(), null);
        }
        return ((TxDocumentFQNWithVersion)txBucketContentFQN.getFilesWithVersion().stream().findFirst().get()).getVersion();
    }

    @Override
    public boolean txDocumentExists(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        LOGGER.debug("txDocumentExists " + documentFQN.getValue() + " " + (Object)((Object)this.getCurrentTxID(userIDAuth.getUserID())));
        return this.getCurrentTxIDHashMap(userIDAuth.getUserID()).documentExists(documentFQN);
    }

    @Override
    public void txDeleteFolder(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN) {
        LOGGER.debug("txDeleteFolder " + documentDirectoryFQN.getValue() + " " + (Object)((Object)this.getCurrentTxID(userIDAuth.getUserID())));
        this.getCurrentTxIDHashMap(userIDAuth.getUserID()).deleteFolder(documentDirectoryFQN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endTransaction(UserIDAuth userIDAuth) {
        try {
            TxID txid = this.getCurrentTxID(userIDAuth.getUserID());
            LOGGER.debug("endTransaction " + txid.getValue());
            CurrentTransactionData currentTransactionData = this.getCurrentTransactionData(userIDAuth.getUserID());
            boolean changed = this.getCurrentTransactionData(userIDAuth.getUserID()).anyDifferenceToInitalState();
            if (changed) {
                LOGGER.debug("something has changed, so write down the new state");
                TxIDHashMapWrapper txIDHashMapWrapper = this.getCurrentTxIDHashMap(userIDAuth.getUserID());
                txIDHashMapWrapper.setEndTransactionDate(new Date());
                txIDHashMapWrapper.saveOnce(this.documentSafeService, userIDAuth);
                txIDHashMapWrapper.transactionIsOver(this.documentSafeService, userIDAuth, currentTransactionData);
                for (DocumentFQN doc : this.getCurrentTransactionData(userIDAuth.getUserID()).getNonTxInboxDocumentsToBeDeletedAfterCommit()) {
                    try {
                        LOGGER.debug("delete file of inbox after commit " + doc);
                        this.documentSafeService.deleteDocumentFromInbox(userIDAuth, doc);
                    }
                    catch (BaseException e) {
                        LOGGER.warn("Exception is ignored. File deletion after commit does not raise exception");
                    }
                    catch (Exception e) {
                        new BaseException((Throwable)e);
                        LOGGER.warn("Exception is ignored. File deletion after commit does not raise exception");
                    }
                }
            } else {
                LOGGER.debug("nothing has changed, so nothing has to be written down");
            }
        }
        finally {
            this.setCurrentTransactionDataToNull(userIDAuth.getUserID());
        }
    }

    @Override
    public void txMoveDocumentToInboxOfUser(UserIDAuth userIDAuth, UserID receiverUserID, DocumentFQN sourceDocumentFQN, DocumentFQN destDocumentFQN, MoveType moveType) {
        LOGGER.debug("start txMoveDocumentToInboxOfUser from " + userIDAuth.getUserID() + " " + sourceDocumentFQN + " to " + receiverUserID + " " + destDocumentFQN);
        DSDocument document = this.txReadDocument(userIDAuth, sourceDocumentFQN);
        this.documentSafeService.writeDocumentToInboxOfUser(receiverUserID, document, destDocumentFQN);
        if (moveType.equals((Object)MoveType.MOVE)) {
            this.txDeleteDocument(userIDAuth, sourceDocumentFQN);
        }
        LOGGER.debug("finished txMoveDocumentToInboxOfUser from " + userIDAuth.getUserID() + " " + sourceDocumentFQN + " to " + receiverUserID + " " + destDocumentFQN);
    }

    @Override
    public DSDocument txMoveDocumentFromInbox(UserIDAuth userIDAuth, DocumentFQN source, DocumentFQN destination) {
        LOGGER.debug("start nonTxReadFromInbox for " + userIDAuth + " " + source + " to " + destination);
        DSDocument documentFromInbox = this.documentSafeService.readDocumentFromInbox(userIDAuth, source);
        DSDocument dsDocument = new DSDocument(destination, documentFromInbox.getDocumentContent());
        this.txStoreDocument(userIDAuth, dsDocument);
        this.getCurrentTransactionData(userIDAuth.getUserID()).addNonTxInboxFileToBeDeletedAfterCommit(source);
        LOGGER.debug("finishdd nonTxReadFromInbox for " + userIDAuth + " " + source + " to " + destination);
        return this.txReadDocument(userIDAuth, destination);
    }

    public static DSDocument modifyTxDocument(DSDocument dsDocument, TxID txid) {
        return new DSDocument(TransactionalDocumentSafeServiceImpl.modifyTxDocumentName(dsDocument.getDocumentFQN(), txid), dsDocument.getDocumentContent());
    }

    public static DocumentFQN modifyTxDocumentName(DocumentFQN origName, TxID txid) {
        return txContent.addName(origName.getValue() + "." + txid.getValue());
    }

    public static DocumentFQN modifyTxMetaDocumentName(DocumentFQN origName, TxID txid) {
        return txMeta.addName(origName.getValue() + "." + txid.getValue());
    }

    private TxID getCurrentTxID(UserID userID) {
        return this.getCurrentTransactionData(userID).getCurrentTxID();
    }

    private void markDocumentRead(UserIDAuth userIDAuth, DocumentFQN documentFQN, TxID txidOfDocument) {
        this.getCurrentTransactionData(userIDAuth.getUserID()).getDocumentsReadInThisTx().put(documentFQN, txidOfDocument);
    }

    private TxIDHashMapWrapper getCurrentTxIDHashMap(UserID userID) {
        return this.getCurrentTransactionData(userID).getCurrentTxHashMap();
    }

    private void setCurrentTransactionDataToNull(UserID userID) {
        this.setCurrentTransactionData(userID, null);
    }

    private CurrentTransactionData findCurrentTransactionData(UserID userID) {
        return (CurrentTransactionData)this.requestMemoryContext.get("CurrentTransactionData-" + userID.getValue());
    }

    private CurrentTransactionData getCurrentTransactionData(UserID userID) {
        CurrentTransactionData currentTransactionData = this.findCurrentTransactionData(userID);
        if (currentTransactionData == null) {
            throw new TxNotActiveException(userID);
        }
        return currentTransactionData;
    }

    private void setCurrentTransactionData(UserID userID, CurrentTransactionData currentTransactionData) {
        this.requestMemoryContext.put("CurrentTransactionData-" + userID.getValue(), currentTransactionData);
    }
}

