/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.transactional.impl;

import de.adorsys.common.exceptions.BaseException;
import de.adorsys.docusafe.business.DocumentSafeService;
import de.adorsys.docusafe.business.types.DSDocument;
import de.adorsys.docusafe.business.types.DocumentFQN;
import de.adorsys.docusafe.service.api.types.UserIDAuth;
import de.adorsys.docusafe.transactional.impl.CurrentTransactionData;
import de.adorsys.docusafe.transactional.impl.TransactionalDocumentSafeServiceImpl;
import de.adorsys.docusafe.transactional.impl.TxIDHashMapWrapper;
import de.adorsys.docusafe.transactional.impl.helper.Class2JsonHelper;
import de.adorsys.docusafe.transactional.impl.helper.CleanupLogic;
import de.adorsys.docusafe.transactional.impl.helper.ParallelTransactionLogic;
import de.adorsys.docusafe.transactional.impl.helper.TransactionInformation;
import de.adorsys.docusafe.transactional.impl.helper.TransactionInformationList;
import de.adorsys.docusafe.transactional.types.TxID;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxIDLog {
    public static final int MAX_COMMITED_TX_FOR_CLEANUP = 5;
    private static final Logger LOGGER = LoggerFactory.getLogger(TxIDLog.class);
    private static String LOG_FILE_NAME = "LastCommitedTxID.txt";
    private static DocumentFQN txidLogFilename = TransactionalDocumentSafeServiceImpl.txMeta.addName(LOG_FILE_NAME);
    private TransactionInformationList txidList = new TransactionInformationList();

    public static TxID findLastCommitedTxID(DocumentSafeService documentSafeService, UserIDAuth userIDAuth) {
        if (documentSafeService.documentExists(userIDAuth, txidLogFilename)) {
            DSDocument dsDocument = documentSafeService.readDocument(userIDAuth, txidLogFilename);
            TxIDLog txIDLog = new Class2JsonHelper().txidLogFromContent(dsDocument.getDocumentContent());
            if (txIDLog.txidList.isEmpty()) {
                throw new BaseException("file " + txidLogFilename + " must not be empty");
            }
            int size = txIDLog.txidList.size();
            TransactionInformation lastTuple = (TransactionInformation)txIDLog.txidList.get(size - 1);
            return lastTuple.getCurrentTxID();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveJustFinishedTx(DocumentSafeService documentSafeService, UserIDAuth userIDAuth, CurrentTransactionData currentTransactionData) {
        String string = userIDAuth.getUserID().getValue().intern();
        synchronized (string) {
            TxID previousTxID;
            TransactionInformation lastTuple;
            TxID lastCommitedTxID;
            LOGGER.debug("start synchronized for " + userIDAuth.getUserID().getValue());
            TxIDHashMapWrapper joinedTx = null;
            TxIDLog txIDLog = new TxIDLog();
            if (documentSafeService.documentExists(userIDAuth, txidLogFilename)) {
                DSDocument dsDocument = documentSafeService.readDocument(userIDAuth, txidLogFilename);
                txIDLog = new Class2JsonHelper().txidLogFromContent(dsDocument.getDocumentContent());
            }
            if (!txIDLog.txidList.isEmpty() && !(lastCommitedTxID = (lastTuple = (TransactionInformation)txIDLog.txidList.get(txIDLog.txidList.size() - 1)).getCurrentTxID()).equals((Object)(previousTxID = currentTransactionData.getCurrentTxHashMap().getLastCommitedTxID()))) {
                TxIDHashMapWrapper stateOfLastCommitedTx = TxIDHashMapWrapper.readHashMapOfTx(documentSafeService, userIDAuth, lastCommitedTxID);
                new ParallelTransactionLogic();
                joinedTx = ParallelTransactionLogic.join(stateOfLastCommitedTx, currentTransactionData.getInitialTxHashMap(), currentTransactionData.getCurrentTxHashMap(), currentTransactionData.getDocumentsReadInThisTx());
                joinedTx.saveOnce(documentSafeService, userIDAuth);
            }
            TxID previousTxID2 = currentTransactionData.getCurrentTxHashMap().getLastCommitedTxID();
            TxID currentTxID = currentTransactionData.getCurrentTxHashMap().getCurrentTxID();
            Date start = currentTransactionData.getCurrentTxHashMap().getBeginTx();
            Date finished = currentTransactionData.getCurrentTxHashMap().getEndTx();
            txIDLog.txidList.add(new TransactionInformation(start, finished, previousTxID2, currentTxID));
            if (joinedTx != null) {
                previousTxID2 = joinedTx.getLastCommitedTxID();
                currentTxID = joinedTx.getCurrentTxID();
                start = joinedTx.getBeginTx();
                finished = joinedTx.getEndTx();
                txIDLog.txidList.add(new TransactionInformation(start, finished, previousTxID2, currentTxID));
            }
            DSDocument document = new DSDocument(txidLogFilename, new Class2JsonHelper().txidLogToContent(txIDLog));
            documentSafeService.storeDocument(userIDAuth, document);
            LOGGER.debug("successfully wrote new Version to " + txidLogFilename);
            int size = txIDLog.txidList.size();
            if (size > 5) {
                txIDLog.txidList = CleanupLogic.cleaupTxHistory(documentSafeService, userIDAuth, txIDLog.txidList);
                int newsize = txIDLog.txidList.size();
                document = new DSDocument(txidLogFilename, new Class2JsonHelper().txidLogToContent(txIDLog));
                documentSafeService.storeDocument(userIDAuth, document);
                LOGGER.info("cleanup reduced number of tx from " + size + " to " + newsize + " in " + txidLogFilename);
            }
            LOGGER.debug("finished synchronized for " + userIDAuth.getUserID().getValue());
        }
    }
}

